/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.categories;

import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategoryType;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class TaxEntryCategory
extends NotificationCategory {
    public static final NotificationCategoryType<TaxEntryCategory> TYPE = new NotificationCategoryType<TaxEntryCategory>(VersionUtil.lcResource("tax_entry"), TaxEntryCategory::new);
    private final long entryID;
    private final MutableComponent entryName;

    public MutableComponent getEntryName() {
        return this.entryName;
    }

    public TaxEntryCategory(MutableComponent entryName, long entryID) {
        this.entryID = entryID;
        this.entryName = entryName;
    }

    public TaxEntryCategory(CompoundTag tag, @Nonnull HolderLookup.Provider lookup) {
        this.entryName = tag.contains("EntryName") ? Component.Serializer.fromJson((String)tag.getString("EntryName"), (HolderLookup.Provider)lookup) : ModBlocks.TAX_COLLECTOR.get().getName();
        this.entryID = tag.contains("TraderID") ? tag.getLong("TraderID") : -1L;
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of(ModBlocks.TAX_COLLECTOR);
    }

    @Override
    @Nonnull
    public MutableComponent getName() {
        return this.getEntryName();
    }

    @Nonnull
    protected NotificationCategoryType<TaxEntryCategory> getType() {
        return TYPE;
    }

    @Override
    public boolean matches(NotificationCategory other) {
        if (other instanceof TaxEntryCategory) {
            TaxEntryCategory otherTax = (TaxEntryCategory)other;
            return otherTax.entryID == this.entryID;
        }
        return false;
    }

    @Override
    protected void saveAdditional(CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        compound.putString("EntryName", Component.Serializer.toJson((Component)this.entryName, (HolderLookup.Provider)lookup));
        compound.putLong("EntryID", this.entryID);
    }
}

