/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.trader;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.taxes.notifications.SingleLineTaxableNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.data.ItemData;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineEntry;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class SlotMachineTradeNotification
extends SingleLineTaxableNotification {
    public static final NotificationType<SlotMachineTradeNotification> TYPE = new NotificationType<SlotMachineTradeNotification>(VersionUtil.lcResource("slot_machine_trade"), SlotMachineTradeNotification::new);
    TraderCategory traderData;
    List<ItemData> items;
    MoneyValue cost = MoneyValue.empty();
    MoneyValue money = MoneyValue.empty();
    String customer;

    private SlotMachineTradeNotification() {
    }

    protected SlotMachineTradeNotification(SlotMachineEntry entry, MoneyValue cost, PlayerReference customer, TraderCategory traderData, MoneyValue taxesPaid) {
        super(taxesPaid);
        this.traderData = traderData;
        this.cost = cost;
        this.items = new ArrayList<ItemData>();
        if (entry.isMoney()) {
            this.money = entry.getMoneyValue();
        } else {
            for (ItemStack item : InventoryUtil.combineQueryItems(entry.items)) {
                this.items.add(new ItemData(item));
            }
        }
        this.customer = customer.getName(false);
    }

    public static Supplier<Notification> create(SlotMachineEntry entry, MoneyValue cost, PlayerReference customer, TraderCategory traderData, MoneyValue taxesPaid) {
        return () -> new SlotMachineTradeNotification(entry, cost, customer, traderData, taxesPaid);
    }

    @Nonnull
    protected NotificationType<SlotMachineTradeNotification> getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public NotificationCategory getCategory() {
        return this.traderData;
    }

    @Override
    @Nonnull
    public MutableComponent getNormalMessage() {
        Object rewardText = !this.money.isEmpty() ? this.money.getText() : ItemData.getItemNames(this.items);
        return LCText.NOTIFICATION_TRADE_SLOT_MACHINE.get(this.customer, this.cost.getText(), rewardText);
    }

    @Override
    protected void saveNormal(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        compound.put("TraderInfo", (Tag)this.traderData.save(lookup));
        ListTag itemList = new ListTag();
        for (ItemData item : this.items) {
            itemList.add((Object)item.save(lookup));
        }
        compound.put("Items", (Tag)itemList);
        compound.put("Money", (Tag)this.money.save());
        compound.put("Price", (Tag)this.cost.save());
        compound.putString("Customer", this.customer);
    }

    @Override
    protected void loadNormal(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        this.traderData = new TraderCategory(compound.getCompound("TraderInfo"), lookup);
        ListTag itemList = compound.getList("Items", 10);
        this.items = new ArrayList<ItemData>();
        for (int i = 0; i < itemList.size(); ++i) {
            this.items.add(ItemData.load(itemList.getCompound(i), lookup));
        }
        this.money = MoneyValue.safeLoad(compound, "Money");
        this.cost = MoneyValue.safeLoad(compound, "Price");
        this.customer = compound.getString("Customer");
    }

    @Override
    protected boolean canMerge(@Nonnull Notification other) {
        if (other instanceof SlotMachineTradeNotification) {
            SlotMachineTradeNotification smtn = (SlotMachineTradeNotification)other;
            if (!smtn.traderData.matches(this.traderData)) {
                return false;
            }
            if (smtn.items.size() != this.items.size()) {
                return false;
            }
            for (int i = 0; i < this.items.size(); ++i) {
                if (this.items.get(i).matches(smtn.items.get(i))) continue;
                return false;
            }
            if (!smtn.money.equals(this.money)) {
                return false;
            }
            if (!smtn.cost.equals(this.cost)) {
                return false;
            }
            if (!smtn.customer.equals(this.customer)) {
                return false;
            }
            return this.TaxesMatch(smtn);
        }
        return false;
    }
}

