/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.teams;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.api.misc.ISidedObject;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.TeamBankReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationAPI;
import io.github.lightman314.lightmanscurrency.api.stats.StatKeys;
import io.github.lightman314.lightmanscurrency.api.stats.StatTracker;
import io.github.lightman314.lightmanscurrency.api.teams.ITeam;
import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.data.types.TeamDataCache;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.DepositWithdrawNotification;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.common.util.TagUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class Team
implements ITeam,
ISidedObject {
    public static final int MAX_NAME_LENGTH = 32;
    private final long id;
    PlayerReference owner;
    String teamName;
    private boolean isClient = false;
    List<PlayerReference> admins = new ArrayList<PlayerReference>();
    List<PlayerReference> members = new ArrayList<PlayerReference>();
    int bankAccountLimit = 2;
    BankAccount bankAccount = null;
    private final StatTracker statTracker = new StatTracker(this::markDirty, this);
    private final List<UUID> onlineDuringSalary = new ArrayList<UUID>();
    private boolean requireLoginForSalary = false;
    long lastSalaryTime = 0L;
    boolean salaryNotification = true;
    long salaryDelay = 0L;
    boolean creativeSalaryMode = false;
    boolean seperateAdminSalary = false;
    private MoneyValue memberSalary = MoneyValue.empty();
    private MoneyValue adminSalary = MoneyValue.empty();
    boolean failedLastSalary = false;

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public PlayerReference getOwner() {
        return this.owner;
    }

    @Override
    public String getName() {
        return this.teamName;
    }

    @Override
    public boolean isClient() {
        return this.isClient;
    }

    @Override
    public Team flagAsClient() {
        this.isClient = true;
        return this;
    }

    @Override
    public Team flagAsClient(boolean isClient) {
        this.isClient = isClient;
        return this;
    }

    @Override
    public Team flagAsClient(IClientTracker context) {
        this.isClient = context.isClient();
        return this;
    }

    @Override
    public List<PlayerReference> getAdmins() {
        return ImmutableList.copyOf(this.admins);
    }

    @Override
    public List<PlayerReference> getMembers() {
        return ImmutableList.copyOf(this.members);
    }

    @Override
    public int getBankLimit() {
        return this.bankAccountLimit;
    }

    @Override
    public boolean hasBankAccount() {
        return this.bankAccount != null;
    }

    @Override
    public boolean canAccessBankAccount(PlayerReference player) {
        if (this.bankAccountLimit < 1) {
            return this.isMember(player);
        }
        if (this.bankAccountLimit < 2) {
            return this.isAdmin(player);
        }
        return this.isOwner(player);
    }

    @Override
    public boolean canAccessBankAccount(Player player) {
        if (this.bankAccountLimit < 1) {
            return this.isMember(player);
        }
        if (this.bankAccountLimit < 2) {
            return this.isAdmin(player);
        }
        return this.isOwner(player);
    }

    @Override
    @Nullable
    public IBankAccount getBankAccount() {
        return this.bankAccount;
    }

    @Override
    @Nullable
    public BankReference getBankReference() {
        if (this.hasBankAccount()) {
            return TeamBankReference.of(this.id).flagAsClient(this.isClient);
        }
        return null;
    }

    @Override
    public StatTracker getStats() {
        return this.statTracker;
    }

    @Override
    public boolean getLoginRequiredForSalary() {
        return this.requireLoginForSalary;
    }

    public void setLoginRequiredForSalary(Player player, boolean requireLoginForSalary) {
        if (!this.isAdmin(player)) {
            return;
        }
        this.requireLoginForSalary = requireLoginForSalary;
        this.checkForOnlinePlayers();
        this.markDirty();
    }

    @Override
    public long getLastSalaryTime() {
        return this.lastSalaryTime;
    }

    public void setAutoSalaryEnabled(Player player, boolean enabled) {
        if (!this.isAdmin(player)) {
            return;
        }
        if (enabled) {
            this.lastSalaryTime = TimeUtil.getCurrentTime();
            this.onlineDuringSalary.clear();
            this.checkForOnlinePlayers();
        } else {
            this.lastSalaryTime = 0L;
        }
        this.markDirty();
    }

    @Override
    public boolean getSalaryNotification() {
        return this.salaryNotification;
    }

    public void setSalaryNotification(Player player, boolean salaryNotification) {
        if (!this.isAdmin(player)) {
            return;
        }
        this.salaryNotification = salaryNotification;
        this.markDirty();
    }

    @Override
    public long getSalaryDelay() {
        return this.salaryDelay;
    }

    public void setSalaryDelay(Player player, long salaryDelay) {
        if (!this.isAdmin(player)) {
            return;
        }
        this.salaryDelay = salaryDelay;
        this.markDirty();
    }

    @Override
    public boolean isSalaryCreative() {
        return this.creativeSalaryMode;
    }

    public void setSalaryMoneyCreative(Player player, boolean creative) {
        if (creative && !LCAdminMode.isAdminPlayer(player)) {
            return;
        }
        this.creativeSalaryMode = creative;
        this.markDirty();
    }

    @Override
    public boolean isAdminSalarySeperate() {
        return this.seperateAdminSalary;
    }

    public void setAdminSalarySeperate(Player player, boolean seperateAdminSalary) {
        if (!this.isOwner(player)) {
            return;
        }
        this.seperateAdminSalary = seperateAdminSalary;
        this.markDirty();
    }

    @Override
    public MoneyValue getMemberSalary() {
        return this.memberSalary;
    }

    public void setMemberSalary(Player player, MoneyValue memberSalary) {
        if (!this.isAdmin(player)) {
            return;
        }
        this.memberSalary = memberSalary;
        this.markDirty();
    }

    @Override
    public MoneyValue getAdminSalary() {
        return this.adminSalary;
    }

    public void setAdminSalary(Player player, MoneyValue adminSalary) {
        if (!this.isOwner(player)) {
            return;
        }
        this.adminSalary = adminSalary;
        this.markDirty();
    }

    @Override
    public boolean failedLastSalaryAttempt() {
        return this.failedLastSalary;
    }

    @Override
    public List<MoneyValue> getTotalSalaryCost(boolean validateOnlinePlayers) {
        if (this.seperateAdminSalary) {
            int validAdminCount;
            int validMemberCount;
            ArrayList result = new ArrayList();
            if (validateOnlinePlayers && this.requireLoginForSalary) {
                validMemberCount = (int)this.members.stream().filter(m -> this.onlineDuringSalary.contains(m.id)).count();
                validAdminCount = (int)this.getAdminsAndOwner().stream().filter(m -> this.onlineDuringSalary.contains(m.id)).count();
            } else {
                validMemberCount = this.members.size();
                validAdminCount = this.getAdminsAndOwner().size();
            }
            MoneyValue memberCost = this.memberSalary.fromCoreValue(this.memberSalary.getCoreValue() * (long)validMemberCount);
            MoneyValue adminCost = this.adminSalary.fromCoreValue(this.adminSalary.getCoreValue() * (long)validAdminCount);
            if (memberCost.isEmpty()) {
                if (adminCost.isEmpty()) {
                    return ImmutableList.of();
                }
                return ImmutableList.of((Object)adminCost);
            }
            if (adminCost.isEmpty()) {
                return ImmutableList.of((Object)memberCost);
            }
            if (memberCost.sameType(adminCost)) {
                return ImmutableList.of((Object)memberCost.addValue(adminCost));
            }
            return ImmutableList.of((Object)memberCost, (Object)adminCost);
        }
        int validMemberCount = validateOnlinePlayers && this.requireLoginForSalary ? (int)this.getAllMembers().stream().filter(m -> this.onlineDuringSalary.contains(m.id)).count() : this.getMemberCount();
        return ImmutableList.of((Object)this.memberSalary.fromCoreValue(this.memberSalary.getCoreValue() * (long)validMemberCount));
    }

    @Override
    public boolean canAffordNextSalary(boolean validateOnlinePlayers) {
        if (this.creativeSalaryMode) {
            return true;
        }
        IBankAccount account = this.getBankAccount();
        if (account == null) {
            return false;
        }
        for (MoneyValue cost : this.getTotalSalaryCost(validateOnlinePlayers)) {
            if (account.getMoneyStorage().containsValue(cost)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isOwner(Player player) {
        return this.isOwner(player.getUUID()) || LCAdminMode.isAdminPlayer(player);
    }

    @Override
    public boolean isOwner(UUID playerID) {
        return this.owner != null && this.owner.is(playerID);
    }

    @Override
    public boolean isAdmin(Player player) {
        return PlayerReference.isInList(this.admins, (Entity)player) || this.isOwner(player);
    }

    @Override
    public boolean isAdmin(UUID playerID) {
        return PlayerReference.isInList(this.admins, playerID) || this.isOwner(playerID);
    }

    @Override
    public boolean isMember(Player player) {
        return PlayerReference.isInList(this.members, (Entity)player) || this.isAdmin(player);
    }

    @Override
    public boolean isMember(UUID playerID) {
        return PlayerReference.isInList(this.members, playerID) || this.isAdmin(playerID);
    }

    public void changePromoteMember(Player requestor, PlayerReference player) {
        if (!this.isAdmin(requestor)) {
            return;
        }
        if (this.isAdmin(player)) {
            return;
        }
        if (this.isMember(player)) {
            if (!this.isOwner(requestor)) {
                return;
            }
            PlayerReference.removeFromList(this.members, player);
            this.admins.add(player);
        } else {
            this.members.add(player);
            this.checkForOnlinePlayers();
        }
        this.markDirty();
    }

    public void changeDemoteMember(Player requestor, PlayerReference player) {
        boolean isSelf = player.is((Entity)requestor);
        if (!this.isAdmin(requestor) && !isSelf) {
            return;
        }
        if (this.isAdmin(player)) {
            if (this.isOwner(player)) {
                return;
            }
            if (!this.isOwner(requestor) && !isSelf) {
                return;
            }
            PlayerReference.removeFromList(this.admins, player);
            this.members.addFirst(player);
            this.markDirty();
        } else if (this.isMember(player)) {
            PlayerReference.removeFromList(this.members, player);
            this.markDirty();
        }
    }

    public void changeOwner(Player requestor, PlayerReference player) {
        if (!this.isOwner(requestor)) {
            return;
        }
        if (player == null) {
            return;
        }
        if (this.owner.is(player)) {
            return;
        }
        this.admins.add(this.owner);
        this.owner = player;
        PlayerReference.removeFromList(this.admins, player);
        PlayerReference.removeFromList(this.members, player);
        this.markDirty();
    }

    public void changeName(Player requestor, String newName) {
        if (this.isAdmin(requestor)) {
            this.teamName = newName;
            if (this.bankAccount != null) {
                this.bankAccount.updateOwnersName(this.teamName);
            }
            this.markDirty();
        }
    }

    public void createBankAccount(Player requestor) {
        if (this.hasBankAccount() || !this.isOwner(requestor)) {
            return;
        }
        this.bankAccount = new BankAccount(this::markDirty);
        this.bankAccount.updateOwnersName(this.teamName);
        this.bankAccount.setNotificationConsumer(this::notificationSender);
        this.markDirty();
    }

    private void notificationSender(Supplier<Notification> notification) {
        ArrayList<PlayerReference> sendTo = new ArrayList<PlayerReference>();
        if (this.bankAccountLimit < 1) {
            sendTo.addAll(this.members);
        }
        if (this.bankAccountLimit < 2) {
            sendTo.addAll(this.admins);
        }
        sendTo.add(this.owner);
        for (PlayerReference player : sendTo) {
            if (player == null || player.id == null) continue;
            NotificationAPI.API.PushPlayerNotification(player.id, notification.get());
        }
    }

    public void changeBankLimit(Player requestor, int newLimit) {
        if (this.isOwner(requestor) && this.bankAccountLimit != newLimit) {
            this.bankAccountLimit = newLimit;
            this.markDirty();
        }
    }

    public static int NextBankLimit(int currentLimit) {
        int result = currentLimit - 1;
        if (result < 0) {
            result = 2;
        }
        return result;
    }

    public void clearStats(Player requestor, boolean fullClear) {
        if (this.isAdmin(requestor)) {
            this.statTracker.clear(fullClear);
        }
    }

    private Team(long teamID, PlayerReference owner, String name) {
        this.id = teamID;
        this.owner = owner;
        this.teamName = name;
    }

    public void markDirty() {
        if (!this.isClient) {
            TeamDataCache.TYPE.get(this).markTeamDirty(this.id);
        }
    }

    public CompoundTag save(HolderLookup.Provider lookup) {
        CompoundTag compound = new CompoundTag();
        compound.putLong("ID", this.id);
        if (this.owner != null) {
            compound.put("Owner", (Tag)this.owner.save());
        }
        compound.putString("Name", this.teamName);
        PlayerReference.saveList(compound, this.members, "Members");
        PlayerReference.saveList(compound, this.admins, "Admins");
        if (this.bankAccount != null) {
            compound.put("BankAccount", (Tag)this.bankAccount.save(lookup));
            compound.putInt("BankLimit", this.bankAccountLimit);
        }
        compound.put("Stats", (Tag)this.statTracker.save(lookup));
        compound.putBoolean("SalaryLoginCheck", this.requireLoginForSalary);
        compound.putLong("LastSalaryTime", this.lastSalaryTime);
        compound.putBoolean("SalaryNotification", this.salaryNotification);
        compound.putLong("SalaryDelay", this.salaryDelay);
        compound.putBoolean("CreativeSalaryMode", this.creativeSalaryMode);
        compound.putBoolean("ExtraAdminSalary", this.seperateAdminSalary);
        compound.put("MemberSalary", (Tag)this.memberSalary.save());
        compound.put("AdminSalary", (Tag)this.adminSalary.save());
        compound.putBoolean("FailedLastSalary", this.failedLastSalary);
        compound.put("SalaryLogins", (Tag)TagUtil.writeUUIDList(this.onlineDuringSalary));
        return compound;
    }

    public static Team load(CompoundTag compound, HolderLookup.Provider lookup) {
        PlayerReference owner = null;
        long id = -1L;
        if (compound.contains("ID")) {
            id = compound.getLong("ID");
        }
        if (compound.contains("Owner", 10)) {
            owner = PlayerReference.load(compound.getCompound("Owner"));
        }
        String name = compound.getString("Name");
        if (owner != null) {
            Team team = Team.of(id, owner, name);
            team.admins = PlayerReference.loadList(compound, "Admins");
            team.members = PlayerReference.loadList(compound, "Members");
            if (compound.contains("BankAccount", 10)) {
                team.bankAccount = new BankAccount(team::markDirty, compound.getCompound("BankAccount"), lookup);
                if (compound.contains("BankLimit", 3)) {
                    team.bankAccountLimit = compound.getInt("BankLimit");
                }
                team.bankAccount.updateOwnersName(team.teamName);
                team.bankAccount.setNotificationConsumer(team::notificationSender);
            }
            if (compound.contains("Stats")) {
                team.statTracker.load(compound.getCompound("Stats"), lookup);
            }
            if (compound.contains("LastSalaryTime")) {
                team.lastSalaryTime = compound.getLong("LastSalaryTime");
            }
            if (compound.contains("SalaryNotification")) {
                team.salaryNotification = compound.getBoolean("SalaryNotification");
            }
            if (compound.contains("SalaryDelay")) {
                team.salaryDelay = compound.getLong("SalaryDelay");
            }
            if (compound.contains("CreativeSalaryMode")) {
                team.creativeSalaryMode = compound.getBoolean("CreativeSalaryMode");
            }
            if (compound.contains("ExtraAdminSalary")) {
                team.seperateAdminSalary = compound.getBoolean("ExtraAdminSalary");
            }
            if (compound.contains("MemberSalary")) {
                team.memberSalary = MoneyValue.load(compound.getCompound("MemberSalary"));
            }
            if (compound.contains("AdminSalary")) {
                team.adminSalary = MoneyValue.load(compound.getCompound("AdminSalary"));
            }
            if (compound.contains("FailedLastSalary")) {
                team.failedLastSalary = compound.getBoolean("FailedLastSalary");
            }
            if (compound.contains("SalaryLoginCheck")) {
                team.requireLoginForSalary = compound.getBoolean("SalaryLoginCheck");
            }
            if (compound.contains("SalaryLogins")) {
                team.onlineDuringSalary.addAll(TagUtil.readUUIDList(compound.getList("SalaryLogins", 11)));
            }
            return team;
        }
        return null;
    }

    public static Team of(long id, PlayerReference owner, String name) {
        return new Team(id, owner, name);
    }

    public static Comparator<ITeam> sorterFor(Player player) {
        return new TeamSorter(player);
    }

    public void tick() {
        if (this.lastSalaryTime > 0L && this.salaryDelay > 0L && !TimeUtil.compareTime(this.salaryDelay, this.lastSalaryTime)) {
            this.lastSalaryTime = TimeUtil.getCurrentTime();
            this.forcePaySalaries(true);
        }
    }

    public void onPlayerJoin(ServerPlayer player) {
        if (this.isMember(PlayerReference.of((Player)player))) {
            this.flagPlayerAsOnline(player);
        }
    }

    @Override
    public void forcePaySalaries(boolean validateOnlinePlayers) {
        if (!this.hasBankAccount()) {
            return;
        }
        if (!this.canAffordNextSalary(validateOnlinePlayers)) {
            this.failedLastSalary = true;
            this.markDirty();
            return;
        }
        this.failedLastSalary = false;
        this.statTracker.incrementStat(StatKeys.Generic.SALARY_TRIGGERS, 1);
        for (MoneyValue payment : this.getTotalSalaryCost(validateOnlinePlayers)) {
            if (!this.creativeSalaryMode) {
                this.bankAccount.pushNotification(() -> new DepositWithdrawNotification.Custom(this.teamName, this.bankAccount.getName(), false, payment), this.salaryNotification);
                this.bankAccount.withdrawMoney(payment);
            }
            this.statTracker.incrementStat(StatKeys.Generic.MONEY_PAID, payment);
        }
        if (!this.memberSalary.isEmpty()) {
            List<PlayerReference> membersToPay;
            List<PlayerReference> list = membersToPay = this.seperateAdminSalary ? this.members : this.getAllMembers();
            if (this.requireLoginForSalary) {
                membersToPay = membersToPay.stream().filter(m -> this.onlineDuringSalary.contains(m.id)).toList();
            }
            for (PlayerReference member : membersToPay) {
                this.payMember(member, this.memberSalary);
            }
        }
        if (this.seperateAdminSalary && !this.adminSalary.isEmpty()) {
            List<PlayerReference> adminsToPay = this.getAdminsAndOwner();
            if (this.requireLoginForSalary) {
                adminsToPay = adminsToPay.stream().filter(m -> this.onlineDuringSalary.contains(m.id)).toList();
            }
            for (PlayerReference admin : adminsToPay) {
                this.payMember(admin, this.adminSalary);
            }
        }
        if (validateOnlinePlayers) {
            this.onlineDuringSalary.clear();
            this.checkForOnlinePlayers();
        }
        this.markDirty();
    }

    private void checkForOnlinePlayers() {
        if (!this.requireLoginForSalary || !this.isAutoSalaryEnabled()) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        List<PlayerReference> members = this.getAllMembers();
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            if (!this.isMember(PlayerReference.of((Player)player))) continue;
            this.flagPlayerAsOnline(player);
        }
    }

    private void flagPlayerAsOnline(ServerPlayer player) {
        if (!this.requireLoginForSalary || !this.isAutoSalaryEnabled()) {
            return;
        }
        UUID playerID = player.getUUID();
        if (!this.onlineDuringSalary.contains(playerID)) {
            this.onlineDuringSalary.add(playerID);
            this.markDirty();
        }
    }

    private void payMember(PlayerReference member, MoneyValue value) {
        IBankAccount memberAccount = PlayerBankReference.of(member).get();
        if (memberAccount != null) {
            memberAccount.pushNotification(() -> new DepositWithdrawNotification.Custom(this.teamName, memberAccount.getName(), true, value), this.salaryNotification);
            memberAccount.depositMoney(value);
        }
    }

    private record TeamSorter(Player player) implements Comparator<ITeam>
    {
        @Override
        public int compare(ITeam o1, ITeam o2) {
            if (o1.isOwner(this.player) && !o2.isOwner(this.player)) {
                return -1;
            }
            if (!o1.isOwner(this.player) && o2.isOwner(this.player)) {
                return 1;
            }
            if (o1.isAdmin(this.player) && !o2.isAdmin(this.player)) {
                return -1;
            }
            if (!o1.isAdmin(this.player) && o2.isAdmin(this.player)) {
                return 1;
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }
}

