/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.commands.tradedata.client;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayEntry;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.traders.commands.CommandTrader;
import io.github.lightman314.lightmanscurrency.common.traders.commands.tradedata.CommandTrade;
import io.github.lightman314.lightmanscurrency.common.util.TooltipHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class CommandTradeButtonRenderer
extends TradeRenderManager<CommandTrade> {
    public CommandTradeButtonRenderer(CommandTrade trade) {
        super(trade);
    }

    @Override
    public int tradeButtonWidth(TradeContext context) {
        return 189;
    }

    @Override
    public Optional<ScreenPosition> arrowPosition(TradeContext context) {
        return ScreenPosition.ofOptional(36, 1);
    }

    @Override
    public DisplayData inputDisplayArea(TradeContext context) {
        return new DisplayData(1, 1, 34, 16);
    }

    @Override
    public List<DisplayEntry> getInputDisplays(TradeContext context) {
        return this.lazyPriceDisplayList(context);
    }

    @Override
    public DisplayData outputDisplayArea(TradeContext context) {
        return new DisplayData(60, 1, 127, 16);
    }

    @Override
    public List<DisplayEntry> getOutputDisplays(TradeContext context) {
        return ImmutableList.of((Object)DisplayEntry.of((Component)EasyText.literal(((CommandTrade)this.trade).getCommandDisplay()), 0xFFFFFF, TooltipHelper.splitTooltips(((CommandTrade)this.trade).getCommandTooltip(), new ChatFormatting[0])));
    }

    @Override
    protected void getAdditionalAlertData(TradeContext context, List<AlertData> alerts) {
        TraderData traderData;
        if (context.hasTrader() && (traderData = context.getTrader()) instanceof CommandTrader) {
            CommandTrader trader = (CommandTrader)traderData;
            if (!((CommandTrade)this.trade).canAfford(context)) {
                alerts.add(AlertData.warn(LCText.TOOLTIP_CANNOT_AFFORD));
            }
        }
    }
}

