/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeData;
import io.github.lightman314.lightmanscurrency.common.blockentity.CoinChestBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModSounds;
import io.github.lightman314.lightmanscurrency.common.menus.CoinChestMenu;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgradeData;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.TickableCoinChestUpgrade;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3f;

public class CoinChestMagnetUpgrade
extends TickableCoinChestUpgrade {
    public static final String RANGE = "magnet_range";

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public void HandleMenuMessage(@Nonnull CoinChestMenu menu, @Nonnull CoinChestUpgradeData data, @Nonnull LazyPacketData message) {
    }

    @Override
    public void addClientTabs(@Nonnull CoinChestUpgradeData data, @Nonnull Object screen, @Nonnull Consumer<Object> consumer) {
    }

    public int getRadius(CoinChestUpgradeData data) {
        return data.getUpgradeData().getIntValue(RANGE);
    }

    @Override
    public void OnServerTick(@Nonnull CoinChestBlockEntity be, @Nonnull CoinChestUpgradeData data) {
        int radius = this.getRadius(data);
        Vector3f pos = be.getBlockPos().getCenter().toVector3f();
        AABB searchBox = new AABB((double)(pos.x - (float)radius), (double)(pos.y - (float)radius), (double)(pos.z - (float)radius), (double)(pos.x + (float)radius), (double)(pos.y + (float)radius), (double)(pos.z + (float)radius));
        boolean playSound = false;
        for (Entity e2 : be.getLevel().getEntities((Entity)null, searchBox, e -> {
            ItemEntity item;
            return e instanceof ItemEntity && CoinAPI.API.IsCoin((item = (ItemEntity)e).getItem(), true);
        })) {
            ItemEntity ie = (ItemEntity)e2;
            ItemStack coinStack = ie.getItem();
            ItemStack leftovers = InventoryUtil.TryPutItemStack((Container)be.getStorage(), coinStack);
            if (leftovers.getCount() == coinStack.getCount()) continue;
            playSound = true;
            if (leftovers.isEmpty()) {
                ie.discard();
                continue;
            }
            ie.setItem(leftovers);
        }
        if (playSound) {
            be.getLevel().playSound(null, be.getBlockPos(), ModSounds.COINS_CLINKING.get(), SoundSource.PLAYERS, 0.4f, 1.0f);
        }
    }

    @Override
    @Nonnull
    public List<Component> getTooltip(@Nonnull UpgradeData data) {
        return ImmutableList.of((Object)LCText.TOOLTIP_UPGRADE_MAGNET.get(data.getIntValue(RANGE)));
    }
}

