/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public record ExchangeUpgradeData(boolean exchangeWhileOpen, List<String> exchangeCommands) {
    public static final ExchangeUpgradeData DEFAULT = new ExchangeUpgradeData(true, (List<String>)ImmutableList.of());
    public static final Codec<ExchangeUpgradeData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("ExchangeWhileOpen").forGetter(ExchangeUpgradeData::exchangeWhileOpen), (App)Codec.STRING.optionalFieldOf("ExchangeCommand").forGetter(d -> Optional.empty()), (App)Codec.STRING.sizeLimitedListOf(10).optionalFieldOf("ExchangeCommands").forGetter(d -> Optional.of(d.exchangeCommands()))).apply((Applicative)builder, ExchangeUpgradeData::load));
    public static final StreamCodec<FriendlyByteBuf, ExchangeUpgradeData> STREAM_CODEC = StreamCodec.of((b, d) -> {
        b.writeBoolean(d.exchangeWhileOpen);
        b.writeInt(d.exchangeCommands.size());
        for (String c : d.exchangeCommands) {
            b.writeUtf(c);
        }
    }, b -> {
        boolean exchangeWhileOpen = b.readBoolean();
        int count = b.readInt();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            list.add(b.readUtf());
        }
        return new ExchangeUpgradeData(exchangeWhileOpen, (List<String>)ImmutableList.copyOf(list));
    });

    private static ExchangeUpgradeData load(boolean exchangeWhileOpen, Optional<String> oldCommand, Optional<List<String>> commandList) {
        return commandList.map(strings -> new ExchangeUpgradeData(exchangeWhileOpen, (List<String>)strings)).orElseGet(() -> oldCommand.map(s -> new ExchangeUpgradeData(exchangeWhileOpen, (List<String>)ImmutableList.of((Object)s))).orElseGet(() -> new ExchangeUpgradeData(exchangeWhileOpen, (List<String>)ImmutableList.of())));
    }

    public boolean hasCommand(String exchangeCommand) {
        return this.exchangeCommands.contains(exchangeCommand);
    }

    public ExchangeUpgradeData withExchangeWhileOpen(boolean newValue) {
        return new ExchangeUpgradeData(newValue, this.exchangeCommands);
    }

    public ExchangeUpgradeData withAddedExchangeCommand(String newCommand) {
        if (this.hasCommand(newCommand) || newCommand.isBlank() || this.exchangeCommands.size() >= 10) {
            return this;
        }
        ArrayList<String> list = new ArrayList<String>(this.exchangeCommands);
        list.add(newCommand);
        return new ExchangeUpgradeData(this.exchangeWhileOpen, (List<String>)ImmutableList.copyOf(list));
    }

    public ExchangeUpgradeData withRemovedExchangeCommand(String removedCommand) {
        if (!this.hasCommand(removedCommand)) {
            return this;
        }
        ArrayList<String> list = new ArrayList<String>(this.exchangeCommands);
        list.remove(removedCommand);
        return new ExchangeUpgradeData(this.exchangeWhileOpen, (List<String>)ImmutableList.copyOf(list));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.exchangeWhileOpen, this.exchangeCommands);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ExchangeUpgradeData) {
            ExchangeUpgradeData other = (ExchangeUpgradeData)obj;
            return other.exchangeWhileOpen == this.exchangeWhileOpen && other.exchangeCommands.equals(this.exchangeCommands);
        }
        return false;
    }
}

