/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.mixinsupport.create;

import com.mojang.datafixers.util.Pair;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyStorage;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue;
import io.github.lightman314.lightmanscurrency.common.attachments.WalletHandler;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.items.data.WalletDataWrapper;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemHandlerHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class WalletInventoryWrapper
extends Inventory {
    public static MoneyView expectedCost = MoneyView.empty();
    private final Inventory inventory;
    private final List<Pair<Integer, ItemStack>> paymentItemsInInventory = new ArrayList<Pair<Integer, ItemStack>>();
    private final List<ItemStack> paymentItems = new ArrayList<ItemStack>();

    public WalletInventoryWrapper(Inventory inventory, WalletHandler walletHandler, InventorySummary paymentItems) {
        super(inventory.player);
        this.inventory = inventory;
        this.setupPaymentItems(walletHandler, paymentItems);
    }

    private void setupPaymentItems(WalletHandler walletHandler, InventorySummary paymentItems) {
        ItemStack wallet = walletHandler.getWallet();
        WalletDataWrapper wrapper = WalletItem.getDataWrapper(wallet);
        Container walletContents = wrapper.getContents();
        MoneyStorage cost = new MoneyStorage(() -> {});
        IMoneyHandler walletMoney = MoneyAPI.API.GetContainersMoneyHandler(walletContents, this.player);
        ArrayList<ItemStack> coinsToAdd = new ArrayList<ItemStack>();
        for (Object stack : paymentItems.getStacks()) {
            if (CoinAPI.API.IsCoin(((BigItemStack)stack).stack, false)) {
                int countToExtract = ((BigItemStack)stack).count;
                if ((countToExtract -= this.queryPaymentItems((BigItemStack)stack)) <= 0) continue;
                ChainData chain = CoinAPI.API.ChainDataOfCoin(((BigItemStack)stack).stack);
                cost.addValue(CoinValue.fromNumber(chain, chain.getCoreValue(((BigItemStack)stack).stack) * (long)((BigItemStack)stack).count));
                coinsToAdd.add(((BigItemStack)stack).stack.copyWithCount(countToExtract));
                continue;
            }
            this.queryPaymentItems((BigItemStack)stack);
        }
        if (!cost.isEmpty()) {
            MoneyView availableFunds = walletMoney.getStoredMoney();
            for (MoneyValue val : cost.allValues()) {
                if (availableFunds.containsValue(val)) continue;
                return;
            }
            ArrayList<MoneyValue> taken = new ArrayList<MoneyValue>();
            for (MoneyValue val : cost.allValues()) {
                if (walletMoney.extractMoney(val, true).isEmpty()) {
                    walletMoney.extractMoney(val, false);
                    taken.add(val);
                    continue;
                }
                for (MoneyValue v : taken) {
                    walletMoney.insertMoney(v, false);
                }
                return;
            }
            wrapper.setContents(walletContents, (LivingEntity)this.player);
            walletHandler.setWallet(wallet);
            this.paymentItems.addAll(coinsToAdd);
        }
    }

    private int queryPaymentItems(BigItemStack stack) {
        int foundCount = 0;
        for (int i = 0; i < this.inventory.items.size(); ++i) {
            ItemStack item = this.inventory.getItem(i);
            if (!item.is(stack.stack.getItem())) continue;
            this.paymentItemsInInventory.add((Pair<Integer, ItemStack>)Pair.of((Object)i, (Object)item));
            foundCount += item.getCount();
        }
        return foundCount;
    }

    public void clearContents() {
        WalletHandler walletHandler = WalletHandler.get((LivingEntity)this.player);
        if (walletHandler != null) {
            ItemStack wallet = walletHandler.getWallet();
            Container walletContents = WalletItem.getDataWrapper(wallet).getContents();
            for (ItemStack item : this.paymentItems) {
                if ((item = InventoryUtil.TryPutItemStack(walletContents, item)).isEmpty()) continue;
                ItemHandlerHelper.giveItemToPlayer((Player)this.player, (ItemStack)item);
            }
            WalletItem.getDataWrapper(wallet).setContents(walletContents, (LivingEntity)this.player);
            walletHandler.setWallet(wallet);
            return;
        }
        for (ItemStack item : this.paymentItems) {
            if (item.isEmpty()) continue;
            ItemHandlerHelper.giveItemToPlayer((Player)this.player, (ItemStack)item);
        }
    }

    public ItemStack getItem(int slot) {
        if (slot < this.paymentItemsInInventory.size()) {
            return (ItemStack)this.paymentItemsInInventory.get(slot).getSecond();
        }
        if ((slot -= this.paymentItemsInInventory.size()) < this.paymentItems.size()) {
            return this.paymentItems.get(slot);
        }
        return ItemStack.EMPTY;
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot < this.paymentItemsInInventory.size()) {
            Pair<Integer, ItemStack> pair = this.paymentItemsInInventory.get(slot);
            this.inventory.setItem(((Integer)pair.getFirst()).intValue(), stack);
            this.paymentItemsInInventory.set(slot, (Pair<Integer, ItemStack>)Pair.of((Object)((Integer)pair.getFirst()), (Object)stack));
            return;
        }
        if ((slot -= this.paymentItemsInInventory.size()) < this.paymentItems.size()) {
            this.paymentItems.set(slot, stack);
        } else if (!stack.isEmpty()) {
            ItemHandlerHelper.giveItemToPlayer((Player)this.player, (ItemStack)stack);
        }
    }
}

