/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.bank;

import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.BankAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.menu.IBankAccountAdvancedMenu;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.network.message.bank.SPacketBankTransferResponse;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CPacketBankTransferPlayer
extends ClientToServerPacket {
    private static final CustomPacketPayload.Type<CPacketBankTransferPlayer> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("c_bank_transfer_player"));
    public static final CustomPacket.Handler<CPacketBankTransferPlayer> HANDLER = new H();
    String playerName;
    MoneyValue amount;

    public CPacketBankTransferPlayer(String playerName, MoneyValue amount) {
        super(TYPE);
        this.playerName = playerName;
        this.amount = amount;
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull CPacketBankTransferPlayer message) {
        buffer.writeUtf(message.playerName);
        message.amount.encode(buffer);
    }

    private static CPacketBankTransferPlayer decode(@Nonnull FriendlyByteBuf buffer) {
        return new CPacketBankTransferPlayer(buffer.readUtf(), MoneyValue.decode(buffer));
    }

    private static class H
    extends CustomPacket.Handler<CPacketBankTransferPlayer> {
        protected H() {
            super(TYPE, CustomPacket.easyCodec(CPacketBankTransferPlayer::encode, CPacketBankTransferPlayer::decode));
        }

        @Override
        protected void handle(@Nonnull CPacketBankTransferPlayer message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            BankReference destination;
            IBankAccountAdvancedMenu menu;
            MutableComponent response;
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof IBankAccountAdvancedMenu && (response = BankAPI.API.BankTransfer(menu = (IBankAccountAdvancedMenu)abstractContainerMenu, message.amount, (destination = PlayerBankReference.of(PlayerReference.of(false, message.playerName))).get())) != null) {
                context.reply((CustomPacketPayload)new SPacketBankTransferResponse((Component)response));
            }
        }
    }
}

