/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.wallet;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CPacketChestQuickCollect
extends ClientToServerPacket {
    private static final CustomPacketPayload.Type<CPacketChestQuickCollect> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("c_wallet_chest_collection"));
    public static final CustomPacket.Handler<CPacketChestQuickCollect> HANDLER = new H();
    private final boolean allowSideChains;

    private CPacketChestQuickCollect(boolean allowSideChains) {
        super(TYPE);
        this.allowSideChains = allowSideChains;
    }

    public static void sendToServer() {
        new CPacketChestQuickCollect((Boolean)LCConfig.CLIENT.chestButtonAllowSideChains.get()).send();
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull CPacketChestQuickCollect message) {
        buffer.writeBoolean(message.allowSideChains);
    }

    private static CPacketChestQuickCollect decode(@Nonnull FriendlyByteBuf buffer) {
        return new CPacketChestQuickCollect(buffer.readBoolean());
    }

    private static class H
    extends CustomPacket.Handler<CPacketChestQuickCollect> {
        protected H() {
            super(TYPE, CustomPacket.easyCodec(CPacketChestQuickCollect::encode, CPacketChestQuickCollect::decode));
        }

        @Override
        protected void handle(@Nonnull CPacketChestQuickCollect message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof ChestMenu) {
                ChestMenu menu = (ChestMenu)abstractContainerMenu;
                WalletItem.QuickCollect(player, menu.getContainer(), message.allowSideChains);
            }
        }
    }
}

