package net.invictusslayer.slayersbeasts.world.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class AntWorker extends AbstractAnt {
	public AntWorker(EntityType<AntWorker> type, Level level) {
		super(type, level);
	}

	protected void registerGoals() {
		super.registerGoals();
	}

	public static AttributeSupplier.Builder createAttributes() {
		return createMobAttributes()
				.add(Attributes.MOVEMENT_SPEED, 0.22D)
				.add(Attributes.MAX_HEALTH, 5D);
//				.add(ForgeMod.ENTITY_GRAVITY.get(), 0.1D);
	}

	public static boolean canSpawn(EntityType<AntWorker> entity, LevelAccessor levelAccess, EntitySpawnReason reason, BlockPos pos, RandomSource random) {
		return checkMobSpawnRules(entity, levelAccess, reason, pos, random);
	}
}
