package net.invictusslayer.slayersbeasts.registries;

import net.invictusslayer.slayersbeasts.SlayersBeasts;
import net.invictusslayer.slayersbeasts.world.entity.vehicle.SBBoatType;
import net.invictusslayer.slayersbeasts.world.item.CryptPortalItem;
import net.invictusslayer.slayersbeasts.world.item.SBFoods;
import net.invictusslayer.slayersbeasts.world.item.SBJukeboxSongs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.*;

import java.util.function.Supplier;

public class SBItems {
	public static final Supplier<Item> MUSIC_DISC_INKISH = register("music_disc_inkish", () -> new Item(new Item.Properties().stacksTo(1).rarity(Rarity.RARE).jukeboxPlayable(SBJukeboxSongs.INKISH)));

	public static final Supplier<Item> JADE = register("jade", () -> new CryptPortalItem(new Item.Properties()));
	public static final Supplier<Item> JADE_SHARD = register("jade_shard", () -> new Item(new Item.Properties()));
	public static final Supplier<Item> CRYSTALLINE_WING = register("crystalline_wing", () -> new Item(new Item.Properties().stacksTo(1)));
	public static final Supplier<Item> CRYSTALLINE_CLAW = register("crystalline_claw", () -> new Item(new Item.Properties().stacksTo(1)));
	public static final Supplier<Item> CRYSTALLINE_CARAPACE = register("crystalline_carapace", () -> new Item(new Item.Properties().stacksTo(1)));

	public static final Supplier<Item> INSECT_WING = register("insect_wing", () -> new Item(new Item.Properties()));
	public static final Supplier<Item> INSECT_CLAW = register("insect_claw", () -> new Item(new Item.Properties()));
	public static final Supplier<Item> INSECT_EYE = register("insect_eye", () -> new Item(new Item.Properties().food(SBFoods.INSECT_EYE)));
	public static final Supplier<Item> INSECT_LEG = register("insect_leg", () -> new Item(new Item.Properties().food(SBFoods.INSECT_LEG)));
	public static final Supplier<Item> FRIED_INSECT_LEG = register("fried_insect_leg", () -> new Item(new Item.Properties().food(SBFoods.FRIED_INSECT_LEG)));

	public static final Supplier<Item> WITHERBONE = register("witherbone", () -> new Item(new Item.Properties()));
	public static final Supplier<Item> TIED_LEATHER = register("tied_leather", () -> new Item(new Item.Properties()));
	public static final Supplier<Item> TANNED_LEATHER = register("tanned_leather", () -> new Item(new Item.Properties()));

	public static final Supplier<Item> MUD_BALL = register("mud_ball", () -> new Item(new Item.Properties()));

	public static final Supplier<SpawnEggItem> MANTIS_SPAWN_EGG = registerSpawnEgg("mantis_spawn_egg", SBEntities.MANTIS::get, 0xffffff, 0xffffff, new Item.Properties());
	public static final Supplier<SpawnEggItem> ANT_WORKER_SPAWN_EGG = registerSpawnEgg("ant_worker_spawn_egg", SBEntities.ANT_WORKER::get, 0xffffff, 0xffffff, new Item.Properties());
	public static final Supplier<SpawnEggItem> ANT_SOLDIER_SPAWN_EGG = registerSpawnEgg("ant_soldier_spawn_egg", SBEntities.ANT_SOLDIER::get, 0xffffff, 0xffffff, new Item.Properties());
	public static final Supplier<SpawnEggItem> ANT_QUEEN_SPAWN_EGG = registerSpawnEgg("ant_queen_spawn_egg", SBEntities.ANT_QUEEN::get, 0xffffff, 0xffffff, new Item.Properties());
	public static final Supplier<SpawnEggItem> WITHER_SPIDER_SPAWN_EGG = registerSpawnEgg("wither_spider_spawn_egg", SBEntities.WITHER_SPIDER::get, 0xffffff, 0xffffff, new Item.Properties());
	public static final Supplier<SpawnEggItem> TYRACHNID_SPAWN_EGG = registerSpawnEgg("tyrachnid_spawn_egg", SBEntities.TYRACHNID::get, 0xffffff, 0xffffff, new Item.Properties());
	public static final Supplier<SpawnEggItem> DAMSELFLY_SPAWN_EGG = registerSpawnEgg("damselfly_spawn_egg", SBEntities.DAMSELFLY::get, 0xffffff, 0xffffff, new Item.Properties());
	public static final Supplier<SpawnEggItem> ENT_SPAWN_EGG = registerSpawnEgg("ent_spawn_egg", SBEntities.ENT_MEDIUM::get, 0xffffff, 0xffffff, new Item.Properties());
	public static final Supplier<SpawnEggItem> WUDU_SPAWN_EGG = registerSpawnEgg("wudu_spawn_egg", SBEntities.WUDU::get, 0xffffff, 0xffffff, new Item.Properties());
	public static final Supplier<SpawnEggItem> SPORETRAP_SPAWN_EGG = registerSpawnEgg("sporetrap_spawn_egg", SBEntities.SPORETRAP::get, 0xffffff, 0xffffff, new Item.Properties());

	public static final Supplier<Item> ASPEN_SIGN = register("aspen_sign", () -> new SignItem(new Item.Properties().stacksTo(16), SBBlocks.ASPEN_SIGN.get(), SBBlocks.ASPEN_WALL_SIGN.get()));
	public static final Supplier<Item> ASPEN_HANGING_SIGN = register("aspen_hanging_sign", () -> new HangingSignItem(SBBlocks.ASPEN_HANGING_SIGN.get(), SBBlocks.ASPEN_WALL_HANGING_SIGN.get(), new Item.Properties().stacksTo(16)));
	public static final Supplier<Item> ASPEN_BOAT = register("aspen_boat", () -> new BoatItem(false, SBBoatType.ASPEN, new Item.Properties().stacksTo(1)));
	public static final Supplier<Item> ASPEN_CHEST_BOAT = register("aspen_chest_boat", () -> new BoatItem(true, SBBoatType.ASPEN, new Item.Properties().stacksTo(1)));

	public static final Supplier<Item> BLOODWOOD_SIGN = register("bloodwood_sign", () -> new SignItem(new Item.Properties().stacksTo(16), SBBlocks.BLOODWOOD_SIGN.get(), SBBlocks.BLOODWOOD_WALL_SIGN.get()));
	public static final Supplier<Item> BLOODWOOD_HANGING_SIGN = register("bloodwood_hanging_sign", () -> new HangingSignItem(SBBlocks.BLOODWOOD_HANGING_SIGN.get(), SBBlocks.BLOODWOOD_WALL_HANGING_SIGN.get(), new Item.Properties().stacksTo(16)));
	public static final Supplier<Item> BLOODWOOD_BOAT = register("bloodwood_boat", () -> new BoatItem(false, SBBoatType.BLOODWOOD, new Item.Properties().stacksTo(1)));
	public static final Supplier<Item> BLOODWOOD_CHEST_BOAT = register("bloodwood_chest_boat", () -> new BoatItem(true, SBBoatType.BLOODWOOD, new Item.Properties().stacksTo(1)));

	public static final Supplier<Item> CYPRESS_SIGN = register("cypress_sign", () -> new SignItem(new Item.Properties().stacksTo(16), SBBlocks.CYPRESS_SIGN.get(), SBBlocks.CYPRESS_WALL_SIGN.get()));
	public static final Supplier<Item> CYPRESS_HANGING_SIGN = register("cypress_hanging_sign", () -> new HangingSignItem(SBBlocks.CYPRESS_HANGING_SIGN.get(), SBBlocks.CYPRESS_WALL_HANGING_SIGN.get(), new Item.Properties().stacksTo(16)));
	public static final Supplier<Item> CYPRESS_BOAT = register("cypress_boat", () -> new BoatItem(false, SBBoatType.CYPRESS, new Item.Properties().stacksTo(1)));
	public static final Supplier<Item> CYPRESS_CHEST_BOAT = register("cypress_chest_boat", () -> new BoatItem(true, SBBoatType.CYPRESS, new Item.Properties().stacksTo(1)));

	public static final Supplier<Item> DESERT_OAK_SIGN = register("desert_oak_sign", () -> new SignItem(new Item.Properties().stacksTo(16), SBBlocks.DESERT_OAK_SIGN.get(), SBBlocks.DESERT_OAK_WALL_SIGN.get()));
	public static final Supplier<Item> DESERT_OAK_HANGING_SIGN = register("desert_oak_hanging_sign", () -> new HangingSignItem(SBBlocks.DESERT_OAK_HANGING_SIGN.get(), SBBlocks.DESERT_OAK_WALL_HANGING_SIGN.get(), new Item.Properties().stacksTo(16)));
	public static final Supplier<Item> DESERT_OAK_BOAT = register("desert_oak_boat", () -> new BoatItem(false, SBBoatType.DESERT_OAK, new Item.Properties().stacksTo(1)));
	public static final Supplier<Item> DESERT_OAK_CHEST_BOAT = register("desert_oak_chest_boat", () -> new BoatItem(true, SBBoatType.DESERT_OAK, new Item.Properties().stacksTo(1)));

	public static final Supplier<Item> EUCALYPTUS_SIGN = register("eucalyptus_sign", () -> new SignItem(new Item.Properties().stacksTo(16), SBBlocks.EUCALYPTUS_SIGN.get(), SBBlocks.EUCALYPTUS_WALL_SIGN.get()));
	public static final Supplier<Item> EUCALYPTUS_HANGING_SIGN = register("eucalyptus_hanging_sign", () -> new HangingSignItem(SBBlocks.EUCALYPTUS_HANGING_SIGN.get(), SBBlocks.EUCALYPTUS_WALL_HANGING_SIGN.get(), new Item.Properties().stacksTo(16)));
	public static final Supplier<Item> EUCALYPTUS_BOAT = register("eucalyptus_boat", () -> new BoatItem(false, SBBoatType.EUCALYPTUS, new Item.Properties().stacksTo(1)));
	public static final Supplier<Item> EUCALYPTUS_CHEST_BOAT = register("eucalyptus_chest_boat", () -> new BoatItem(true, SBBoatType.EUCALYPTUS, new Item.Properties().stacksTo(1)));

	public static final Supplier<Item> KAPOK_SIGN = register("kapok_sign", () -> new SignItem(new Item.Properties().stacksTo(16), SBBlocks.KAPOK_SIGN.get(), SBBlocks.KAPOK_WALL_SIGN.get()));
	public static final Supplier<Item> KAPOK_HANGING_SIGN = register("kapok_hanging_sign", () -> new HangingSignItem(SBBlocks.KAPOK_HANGING_SIGN.get(), SBBlocks.KAPOK_WALL_HANGING_SIGN.get(), new Item.Properties().stacksTo(16)));
	public static final Supplier<Item> KAPOK_BOAT = register("kapok_boat", () -> new BoatItem(false, SBBoatType.KAPOK, new Item.Properties().stacksTo(1)));
	public static final Supplier<Item> KAPOK_CHEST_BOAT = register("kapok_chest_boat", () -> new BoatItem(true, SBBoatType.KAPOK, new Item.Properties().stacksTo(1)));

	public static final Supplier<Item> REDWOOD_SIGN = register("redwood_sign", () -> new SignItem(new Item.Properties().stacksTo(16), SBBlocks.REDWOOD_SIGN.get(), SBBlocks.REDWOOD_WALL_SIGN.get()));
	public static final Supplier<Item> REDWOOD_HANGING_SIGN = register("redwood_hanging_sign", () -> new HangingSignItem(SBBlocks.REDWOOD_HANGING_SIGN.get(), SBBlocks.REDWOOD_WALL_HANGING_SIGN.get(), new Item.Properties().stacksTo(16)));
	public static final Supplier<Item> REDWOOD_BOAT = register("redwood_boat", () -> new BoatItem(false, SBBoatType.REDWOOD, new Item.Properties().stacksTo(1)));
	public static final Supplier<Item> REDWOOD_CHEST_BOAT = register("redwood_chest_boat", () -> new BoatItem(true, SBBoatType.REDWOOD, new Item.Properties().stacksTo(1)));

	public static final Supplier<Item> WILLOW_SIGN = register("willow_sign", () -> new SignItem(new Item.Properties().stacksTo(16), SBBlocks.WILLOW_SIGN.get(), SBBlocks.WILLOW_WALL_SIGN.get()));
	public static final Supplier<Item> WILLOW_HANGING_SIGN = register("willow_hanging_sign", () -> new HangingSignItem(SBBlocks.WILLOW_HANGING_SIGN.get(), SBBlocks.WILLOW_WALL_HANGING_SIGN.get(), new Item.Properties().stacksTo(16)));
	public static final Supplier<Item> WILLOW_BOAT = register("willow_boat", () -> new BoatItem(false, SBBoatType.WILLOW, new Item.Properties().stacksTo(1)));
	public static final Supplier<Item> WILLOW_CHEST_BOAT = register("willow_chest_boat", () -> new BoatItem(true, SBBoatType.WILLOW, new Item.Properties().stacksTo(1)));

	static Supplier<SpawnEggItem> registerSpawnEgg(String name, Supplier<EntityType<? extends Mob>> entity, int bgColor, int fgColor, Item.Properties props) {
		return SlayersBeasts.PLATFORM.registerSpawnEgg(SlayersBeasts.MOD_ID, name, entity, bgColor, fgColor, props);
	}

	static <T extends Item> Supplier<T> register(String name, Supplier<T> supplier) {
		return SlayersBeasts.PLATFORM.register(BuiltInRegistries.ITEM, SlayersBeasts.MOD_ID, name, supplier);
	}

	public static void register() {
		SlayersBeasts.LOGGER.info("Registering SBItems...");
	}
}
