/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.client.model;

import net.invictusslayer.slayersbeasts.client.animation.EntMediumAnimation;
import net.invictusslayer.slayersbeasts.world.entity.EntMedium;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public class EntMediumModel<T extends EntMedium>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"ent_medium_model"), "main");
    private final ModelPart root;
    private final ModelPart head;

    public EntMediumModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("body").getChild("head");
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.getAllParts().forEach(ModelPart::resetPose);
        this.head.yRot = netHeadYaw * (float)Math.PI / 180.0f;
        this.animateWalk(EntMediumAnimation.WALK, limbSwing, limbSwingAmount, 8.0f, 10.0f);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(34, 33).addBox(-6.0f, -3.5f, -4.0f, 12.0f, 15.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(48, 10).addBox(-7.0f, -7.5f, -5.0f, 14.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-9.0f, -16.5f, -6.0f, 18.0f, 9.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(90, 55).addBox(6.0f, -17.5f, -5.0f, 6.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(90, 41).addBox(-12.0f, -17.5f, -5.0f, 6.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(47, 0).addBox(12.0f, -17.5f, -4.0f, 4.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(31, 20).addBox(-16.0f, -17.5f, -4.0f, 4.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-21.0f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 20).addBox(-5.0f, -10.5f, -5.0f, 10.0f, 10.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-16.0f, (float)-1.0f));
        PartDefinition branch = head.addOrReplaceChild("branch", CubeListBuilder.create().texOffs(0, 0).addBox(2.0f, -8.5f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 80).addBox(-1.0f, -13.5f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-10.0f, (float)0.0f, (float)0.5236f, (float)0.0f, (float)0.3491f));
        PartDefinition branch2 = head.addOrReplaceChild("branch2", CubeListBuilder.create().texOffs(0, 0).addBox(2.0f, -8.5f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 80).addBox(-1.0f, -13.5f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-10.0f, (float)0.0f, (float)-0.3873f, (float)0.0665f, (float)0.1615f));
        PartDefinition branch3 = head.addOrReplaceChild("branch3", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -8.5f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 80).addBox(-4.0f, -13.5f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-10.0f, (float)0.0f, (float)0.3054f, (float)0.0f, (float)0.1309f));
        PartDefinition branch4 = head.addOrReplaceChild("branch4", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -8.5f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 80).addBox(-6.0f, -13.5f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-10.0f, (float)0.0f, (float)-0.48f, (float)0.0f, (float)-0.3491f));
        PartDefinition branch5 = head.addOrReplaceChild("branch5", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -8.5f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 80).addBox(-6.0f, -13.5f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-10.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)-0.5672f));
        PartDefinition arm_left = body.addOrReplaceChild("arm_left", CubeListBuilder.create().texOffs(100, 19).addBox(2.0f, -2.5f, -3.0f, 4.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)-14.0f, (float)0.0f));
        PartDefinition arm_lower_left = arm_left.addOrReplaceChild("arm_lower_left", CubeListBuilder.create().texOffs(66, 24).addBox(-4.0f, 10.0f, -4.5f, 8.0f, 8.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(80, 100).addBox(2.0f, 18.0f, -3.5f, 2.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(87, 81).addBox(-3.0f, -2.0f, -3.5f, 6.0f, 12.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)9.5f, (float)-0.5f));
        PartDefinition arm_right = body.addOrReplaceChild("arm_right", CubeListBuilder.create().texOffs(24, 96).addBox(-6.0f, -2.5f, -3.0f, 4.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.0f, (float)-14.0f, (float)0.0f));
        PartDefinition arm_lower_right = arm_right.addOrReplaceChild("arm_lower_right", CubeListBuilder.create().texOffs(94, 68).addBox(-4.0f, 18.0f, -3.5f, 2.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(86, 0).addBox(-3.0f, -2.0f, -3.5f, 6.0f, 12.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(65, 47).addBox(-4.0f, 10.0f, -4.5f, 8.0f, 8.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)9.5f, (float)-0.5f));
        PartDefinition leg_left = body.addOrReplaceChild("leg_left", CubeListBuilder.create().texOffs(0, 88).addBox(-3.0f, -1.5f, -3.0f, 6.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)11.0f, (float)0.0f, (float)-0.3927f, (float)-0.3491f, (float)0.0f));
        PartDefinition leg_lower_left = leg_left.addOrReplaceChild("leg_lower_left", CubeListBuilder.create().texOffs(0, 46).addBox(-5.0f, 13.5f, -2.0f, 10.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 66).addBox(-4.0f, -0.5f, -1.0f, 8.0f, 14.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)-3.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition leg_right = body.addOrReplaceChild("leg_right", CubeListBuilder.create().texOffs(56, 88).addBox(-3.0f, -1.5f, -3.0f, 6.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)11.0f, (float)0.0f, (float)-0.3927f, (float)0.3491f, (float)0.0f));
        PartDefinition leg_lower_right = leg_right.addOrReplaceChild("leg_lower_right", CubeListBuilder.create().texOffs(30, 56).addBox(-5.0f, 13.5f, -2.0f, 10.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(62, 66).addBox(-4.0f, -0.5f, -1.0f, 8.0f, 14.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)-3.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition branch_left = body.addOrReplaceChild("branch_left", CubeListBuilder.create(), PartPose.offset((float)12.0f, (float)-17.0f, (float)-1.0f));
        PartDefinition cube_r1 = branch_left.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -8.5f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 80).addBox(-3.0f, -14.5f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.2182f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r2 = branch_left.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(24, 80).addBox(-2.0f, -11.5f, -3.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.1415f, (float)0.1666f, (float)-0.4681f));
        PartDefinition cube_r3 = branch_left.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(24, 80).addBox(-3.0f, -13.5f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(0.0f, -8.5f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition branch_right = body.addOrReplaceChild("branch_right", CubeListBuilder.create(), PartPose.offset((float)-12.0f, (float)-17.0f, (float)-1.0f));
        PartDefinition cube_r4 = branch_right.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -8.5f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 80).addBox(-3.0f, -12.5f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r5 = branch_right.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(24, 80).addBox(-1.0f, -11.5f, -3.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition cube_r6 = branch_right.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(24, 80).addBox(-3.0f, -13.5f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(0.0f, -8.5f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }
}

