/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.data;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.invictusslayer.scabbard.world.biome.BiomeModifierHandler;
import net.invictusslayer.scabbard.world.biome.ForgeBiomeModifications;
import net.invictusslayer.slayersbeasts.data.tags.SBBiomeTagsProvider;
import net.invictusslayer.slayersbeasts.world.level.biome.SBBiomeModifications;
import net.minecraft.core.Cloner;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SBForgeDataGen {
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(ForgeRegistries.Keys.BIOME_MODIFIERS, context -> ForgeBiomeModifications.bootstrap((BootstrapContext)context, (BiomeModifierHandler)SBBiomeModifications.HANDLER));

    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean hasServer = event.includeServer();
        gen.addProvider(hasServer, (DataProvider)new DatapackBuiltinEntriesProvider(output, provider, BUILDER, Collections.singleton("slayersbeasts")));
        gen.addProvider(hasServer, (DataProvider)new SBBiomeTagsProvider(output, (CompletableFuture<HolderLookup.Provider>)provider.thenApply(SBForgeDataGen::patchRegistry), helper));
    }

    private static HolderLookup.Provider patchRegistry(HolderLookup.Provider provider) {
        Cloner.Factory factory = new Cloner.Factory();
        RegistryDataLoader.WORLDGEN_REGISTRIES.forEach(data -> data.runWithArguments((arg_0, arg_1) -> ((Cloner.Factory)factory).addCodec(arg_0, arg_1)));
        return BUILDER.buildPatch((RegistryAccess)RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY), provider, factory).full();
    }
}

