/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.block;

import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class IcicleBlock
extends Block
implements Fallable,
SimpleWaterloggedBlock {
    public static final DirectionProperty TIP_DIRECTION = BlockStateProperties.VERTICAL_DIRECTION;
    public static final EnumProperty<DripstoneThickness> THICKNESS = BlockStateProperties.DRIPSTONE_THICKNESS;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape TIP_MERGE_SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_UP = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_DOWN = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape BASE_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape DRIP_THROUGH_SPACE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public IcicleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TIP_DIRECTION, THICKNESS, WATERLOGGED});
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return IcicleBlock.isValidPlacement(level, pos, (Direction)state.getValue((Property)TIP_DIRECTION));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (direction != Direction.UP && direction != Direction.DOWN) {
            return state;
        }
        Direction tipDirection = (Direction)state.getValue((Property)TIP_DIRECTION);
        if (tipDirection == Direction.DOWN && level.getBlockTicks().hasScheduledTick(pos, (Object)this)) {
            return state;
        }
        if (direction == tipDirection.getOpposite() && !this.canSurvive(state, (LevelReader)level, pos)) {
            if (tipDirection == Direction.DOWN) {
                level.scheduleTick(pos, (Block)this, 2);
            } else {
                level.scheduleTick(pos, (Block)this, 1);
            }
            return state;
        }
        DripstoneThickness thickness = IcicleBlock.calculateThickness((LevelReader)level, pos, tipDirection, state.getValue(THICKNESS) == DripstoneThickness.TIP_MERGE);
        return (BlockState)state.setValue(THICKNESS, (Comparable)thickness);
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos pos = hit.getBlockPos();
        if (!level.isClientSide && projectile.mayInteract(level, pos) && projectile instanceof ThrownTrident && projectile.getDeltaMovement().length() > 0.6) {
            level.destroyBlock(pos, true);
        }
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (state.getValue((Property)TIP_DIRECTION) == Direction.UP && state.getValue(THICKNESS) == DripstoneThickness.TIP) {
            entity.causeFallDamage(fallDistance + 2.0f, 2.0f, level.damageSources().stalagmite());
        } else {
            super.fallOn(level, state, pos, entity, fallDistance);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (IcicleBlock.isIcicleWithDirection(state, Direction.UP) && !this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        } else {
            IcicleBlock.spawnFallingStalactite(state, level, pos);
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.nextFloat() < 0.0114f && IcicleBlock.isStalactiteStartPos(state, (LevelReader)level, pos)) {
            IcicleBlock.growStalactiteOrStalagmiteIfPossible(state, level, pos, random);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction opposite;
        BlockPos clickedPos;
        Level level = context.getLevel();
        Direction direction = IcicleBlock.calculateTipDirection((LevelReader)level, clickedPos = context.getClickedPos(), opposite = context.getNearestLookingVerticalDirection().getOpposite());
        if (direction == null) {
            return null;
        }
        boolean flag = !context.isSecondaryUseActive();
        DripstoneThickness thickness = IcicleBlock.calculateThickness((LevelReader)level, clickedPos, direction, flag);
        return thickness == null ? null : (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TIP_DIRECTION, (Comparable)direction)).setValue(THICKNESS, (Comparable)thickness)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(clickedPos).getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        DripstoneThickness thickness = (DripstoneThickness)state.getValue(THICKNESS);
        VoxelShape shape = thickness == DripstoneThickness.TIP_MERGE ? TIP_MERGE_SHAPE : (thickness == DripstoneThickness.TIP ? (state.getValue((Property)TIP_DIRECTION) == Direction.DOWN ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (thickness == DripstoneThickness.FRUSTUM ? FRUSTUM_SHAPE : (thickness == DripstoneThickness.MIDDLE ? MIDDLE_SHAPE : BASE_SHAPE)));
        Vec3 vec3 = state.getOffset(level, pos);
        return shape.move(vec3.x, 0.0, vec3.z);
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public float getMaxHorizontalOffset() {
        return 0.125f;
    }

    public void onBrokenAfterFall(Level level, BlockPos pPos, FallingBlockEntity fallingBlock) {
        if (!fallingBlock.isSilent()) {
            level.levelEvent(1045, pPos, 0);
        }
    }

    public DamageSource getFallDamageSource(Entity entity) {
        return entity.damageSources().fallingStalactite(entity);
    }

    private static void spawnFallingStalactite(BlockState state, ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        BlockState blockState = state;
        while (IcicleBlock.isIcicleWithDirection(blockState, Direction.DOWN)) {
            FallingBlockEntity fallingBlock = FallingBlockEntity.fall((Level)level, (BlockPos)mutableBlockPos, (BlockState)blockState);
            fallingBlock.disableDrop();
            if (IcicleBlock.isTip(blockState, true)) {
                fallingBlock.setHurtsEntities((float)Math.max(1 + pos.getY() - mutableBlockPos.getY(), 6), 40);
                break;
            }
            mutableBlockPos.move(Direction.DOWN);
            blockState = level.getBlockState((BlockPos)mutableBlockPos);
        }
    }

    public static void growStalactiteOrStalagmiteIfPossible(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState tipState;
        BlockPos blockPos;
        BlockState fluidState;
        BlockState aboveState = level.getBlockState(pos.above(1));
        if (IcicleBlock.canGrow(aboveState, fluidState = level.getBlockState(pos.above(2))) && (blockPos = IcicleBlock.findTip(state, (LevelAccessor)level, pos)) != null && IcicleBlock.canDrip(tipState = level.getBlockState(blockPos)) && IcicleBlock.canTipGrow(tipState, level, blockPos)) {
            if (random.nextBoolean()) {
                IcicleBlock.grow(level, blockPos, Direction.DOWN);
            } else {
                IcicleBlock.growStalagmiteBelow(level, blockPos);
            }
        }
    }

    private static void growStalagmiteBelow(ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        for (int i = 0; i < 10; ++i) {
            mutableBlockPos.move(Direction.DOWN);
            BlockState state = level.getBlockState((BlockPos)mutableBlockPos);
            if (!state.getFluidState().isEmpty()) break;
            if (IcicleBlock.isUnmergedTipWithDirection(state, Direction.UP) && IcicleBlock.canTipGrow(state, level, (BlockPos)mutableBlockPos)) {
                IcicleBlock.grow(level, (BlockPos)mutableBlockPos, Direction.UP);
                break;
            }
            if (IcicleBlock.isValidPlacement((LevelReader)level, (BlockPos)mutableBlockPos, Direction.UP) && !level.isWaterAt(mutableBlockPos.below())) {
                IcicleBlock.grow(level, mutableBlockPos.below(), Direction.UP);
                break;
            }
            if (!IcicleBlock.canDripThrough((BlockGetter)level, (BlockPos)mutableBlockPos, state)) break;
        }
    }

    private static void grow(ServerLevel level, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.relative(direction);
        BlockState state = level.getBlockState(blockPos);
        if (IcicleBlock.isUnmergedTipWithDirection(state, direction.getOpposite())) {
            IcicleBlock.createMergedTips(state, (LevelAccessor)level, blockPos);
        } else if (state.isAir() || state.is(Blocks.WATER)) {
            IcicleBlock.createIcicle((LevelAccessor)level, blockPos, direction, DripstoneThickness.TIP);
        }
    }

    private static void createIcicle(LevelAccessor level, BlockPos pos, Direction direction, DripstoneThickness thickness) {
        BlockState state = (BlockState)((BlockState)((BlockState)SBBlocks.ICICLE.get().defaultBlockState().setValue((Property)TIP_DIRECTION, (Comparable)direction)).setValue(THICKNESS, (Comparable)thickness)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER));
        level.setBlock(pos, state, 3);
    }

    private static void createMergedTips(BlockState state, LevelAccessor level, BlockPos pos) {
        BlockPos top;
        BlockPos bottom;
        if (state.getValue((Property)TIP_DIRECTION) == Direction.UP) {
            bottom = pos;
            top = pos.above();
        } else {
            top = pos;
            bottom = pos.below();
        }
        IcicleBlock.createIcicle(level, top, Direction.DOWN, DripstoneThickness.TIP_MERGE);
        IcicleBlock.createIcicle(level, bottom, Direction.UP, DripstoneThickness.TIP_MERGE);
    }

    private static BlockPos findTip(BlockState state, LevelAccessor level, BlockPos pos) {
        if (IcicleBlock.isTip(state, false)) {
            return pos;
        }
        Direction direction = (Direction)state.getValue((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> biPredicate = (blockPos, blockState) -> blockState.is(SBBlocks.ICICLE.get()) && blockState.getValue((Property)TIP_DIRECTION) == direction;
        return IcicleBlock.findBlockVertical(level, pos, direction.getAxisDirection(), biPredicate, blockState -> IcicleBlock.isTip(blockState, false), 7).orElse(null);
    }

    private static Direction calculateTipDirection(LevelReader level, BlockPos pos, Direction direction) {
        if (IcicleBlock.isValidPlacement(level, pos, direction)) {
            return direction;
        }
        if (!IcicleBlock.isValidPlacement(level, pos, direction.getOpposite())) {
            return null;
        }
        return direction.getOpposite();
    }

    private static DripstoneThickness calculateThickness(LevelReader level, BlockPos pos, Direction direction, boolean isMerged) {
        Direction opposite = direction.getOpposite();
        BlockState blockState = level.getBlockState(pos.relative(direction));
        if (IcicleBlock.isIcicleWithDirection(blockState, opposite)) {
            return !isMerged && blockState.getValue(THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!IcicleBlock.isIcicleWithDirection(blockState, direction)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness thickness = (DripstoneThickness)blockState.getValue(THICKNESS);
        if (thickness != DripstoneThickness.TIP && thickness != DripstoneThickness.TIP_MERGE) {
            BlockState state = level.getBlockState(pos.relative(opposite));
            return !IcicleBlock.isIcicleWithDirection(state, direction) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    public static boolean canDrip(BlockState state) {
        return IcicleBlock.isIcicleWithDirection(state, Direction.DOWN) && state.getValue(THICKNESS) == DripstoneThickness.TIP && (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    private static boolean canTipGrow(BlockState state, ServerLevel level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)TIP_DIRECTION);
        BlockPos blockPos = pos.relative(direction);
        BlockState blockState = level.getBlockState(blockPos);
        if (!blockState.getFluidState().isEmpty()) {
            return false;
        }
        return blockState.isAir() || IcicleBlock.isUnmergedTipWithDirection(blockState, direction.getOpposite());
    }

    private static Optional<BlockPos> findRootBlock(Level level, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.getValue((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> biPredicate = (blockPos, blockState) -> blockState.is(SBBlocks.ICICLE.get()) && blockState.getValue((Property)TIP_DIRECTION) == direction;
        return IcicleBlock.findBlockVertical((LevelAccessor)level, pos, direction.getOpposite().getAxisDirection(), biPredicate, blockState -> !blockState.is(SBBlocks.ICICLE.get()), 11);
    }

    private static boolean isValidPlacement(LevelReader level, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.relative(direction.getOpposite());
        BlockState state = level.getBlockState(blockPos);
        return state.isFaceSturdy((BlockGetter)level, blockPos, direction) || IcicleBlock.isIcicleWithDirection(state, direction);
    }

    private static boolean isTip(BlockState state, boolean isMerged) {
        if (!state.is(SBBlocks.ICICLE.get())) {
            return false;
        }
        DripstoneThickness thickness = (DripstoneThickness)state.getValue(THICKNESS);
        return thickness == DripstoneThickness.TIP || isMerged && thickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean isUnmergedTipWithDirection(BlockState state, Direction direction) {
        return IcicleBlock.isTip(state, false) && state.getValue((Property)TIP_DIRECTION) == direction;
    }

    private static boolean isStalactiteStartPos(BlockState state, LevelReader level, BlockPos pos) {
        return IcicleBlock.isIcicleWithDirection(state, Direction.DOWN) && !level.getBlockState(pos.above()).is(SBBlocks.ICICLE.get());
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    private static boolean isIcicleWithDirection(BlockState state, Direction direction) {
        return state.is(SBBlocks.ICICLE.get()) && state.getValue((Property)TIP_DIRECTION) == direction;
    }

    private static Optional<FluidInfo> getFluidAboveStalactite(Level level, BlockPos pos, BlockState state) {
        return !IcicleBlock.isIcicleWithDirection(state, Direction.DOWN) ? Optional.empty() : IcicleBlock.findRootBlock(level, pos, state).map(blockPos -> {
            BlockPos above = blockPos.above();
            BlockState blockState = level.getBlockState(above);
            Fluid fluid = level.getFluidState(above).getType();
            return new FluidInfo(above, fluid, blockState);
        });
    }

    private static boolean canGrow(BlockState icicleState, BlockState state) {
        return icicleState.is(SBBlocks.ICICLE.get()) && state.is(Blocks.WATER) && state.getFluidState().isSource();
    }

    private static Optional<BlockPos> findBlockVertical(LevelAccessor level, BlockPos pos, Direction.AxisDirection axis, BiPredicate<BlockPos, BlockState> biPredicate, Predicate<BlockState> predicate, int maxIterations) {
        Direction direction = Direction.get((Direction.AxisDirection)axis, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        for (int i = 1; i < maxIterations; ++i) {
            mutableBlockPos.move(direction);
            BlockState blockstate = level.getBlockState((BlockPos)mutableBlockPos);
            if (predicate.test(blockstate)) {
                return Optional.of(mutableBlockPos.immutable());
            }
            if (!level.isOutsideBuildHeight(mutableBlockPos.getY()) && biPredicate.test((BlockPos)mutableBlockPos, blockstate)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean canDripThrough(BlockGetter level, BlockPos pos, BlockState state) {
        if (state.isAir()) {
            return true;
        }
        if (state.isSolidRender(level, pos) || !state.getFluidState().isEmpty()) {
            return false;
        }
        return !Shapes.joinIsNotEmpty((VoxelShape)DRIP_THROUGH_SPACE, (VoxelShape)state.getCollisionShape(level, pos), (BooleanOp)BooleanOp.AND);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        float f;
        if (IcicleBlock.canDrip(state) && (f = random.nextFloat()) < 0.12f) {
            IcicleBlock.getFluidAboveStalactite(level, pos, state).filter(info -> f < 0.02f || info.fluid == Fluids.WATER).ifPresent(info -> IcicleBlock.spawnDripParticle(level, pos, state));
        }
    }

    private static void spawnDripParticle(Level level, BlockPos pos, BlockState state) {
        Vec3 vec3 = state.getOffset((BlockGetter)level, pos);
        double d1 = (double)pos.getX() + 0.5 + vec3.x;
        double d2 = (double)((float)(pos.getY() + 1) - 0.6875f) - 0.0625;
        double d3 = (double)pos.getZ() + 0.5 + vec3.z;
        level.addParticle((ParticleOptions)ParticleTypes.DRIPPING_DRIPSTONE_WATER, d1, d2, d3, 0.0, 0.0, 0.0);
    }

    record FluidInfo(BlockPos pos, Fluid fluid, BlockState sourceState) {
    }
}

