/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.feature.misc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.invictusslayer.slayersbeasts.data.tags.SBTags;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class StyphiumPatchFeature
extends Feature<Configuration> {
    public StyphiumPatchFeature(Codec<Configuration> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<Configuration> context) {
        WorldGenLevel level = context.level();
        Configuration config = (Configuration)context.config();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        Predicate<BlockState> stateCheck = state -> state.is(SBTags.Blocks.STYPHIUM_REPLACEABLE);
        Set<BlockPos> set = this.placeGround(level, config, random, origin, stateCheck);
        this.placeVegetation(context, level, config, random, set);
        return !set.isEmpty();
    }

    private Set<BlockPos> placeGround(WorldGenLevel level, Configuration config, RandomSource random, BlockPos pos, Predicate<BlockState> stoneTest) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        int xRad = config.xzRadius.sample(random) + 1;
        int zRad = config.xzRadius.sample(random) + 1;
        for (int x = -xRad; x <= xRad; ++x) {
            boolean xEdge = x == -xRad || x == xRad;
            for (int z = -zRad; z <= zRad; ++z) {
                boolean zEdge;
                boolean bl = zEdge = z == -zRad || z == zRad;
                if (xEdge && zEdge || (xEdge || zEdge) && (config.edgeColumnChance == 0.0f || !(random.nextFloat() < config.edgeColumnChance))) continue;
                mutableBlockPos.setWithOffset((Vec3i)pos, x, 0, z);
                for (int y = 0; y < config.verticalRange; ++y) {
                    if (level.isStateAtPosition((BlockPos)mutableBlockPos, BlockBehaviour.BlockStateBase::isAir)) {
                        mutableBlockPos.move(Direction.DOWN);
                        continue;
                    }
                    if (!level.isStateAtPosition((BlockPos)mutableBlockPos, stoneTest)) continue;
                    mutableBlockPos.move(Direction.UP);
                    break;
                }
                BlockPos.MutableBlockPos mutableBlockPos1 = mutableBlockPos.offset(0, -1, 0).mutable();
                if (!level.isEmptyBlock((BlockPos)mutableBlockPos) || !level.getBlockState((BlockPos)mutableBlockPos1).isFaceSturdy((BlockGetter)level, (BlockPos)mutableBlockPos1, Direction.UP) || !this.placeStyphium(level, config, mutableBlockPos1)) continue;
                set.add(mutableBlockPos1.immutable());
            }
        }
        return set;
    }

    private boolean placeStyphium(WorldGenLevel level, Configuration config, BlockPos.MutableBlockPos mutableBlockPos) {
        BlockState state = level.getBlockState((BlockPos)mutableBlockPos);
        if (state.is(Blocks.STONE)) {
            level.setBlock((BlockPos)mutableBlockPos, SBBlocks.STYPHIUM.get().defaultBlockState(), 2);
        } else if (state.is(Blocks.DEEPSLATE)) {
            level.setBlock((BlockPos)mutableBlockPos, SBBlocks.DEEPSLATE_STYPHIUM.get().defaultBlockState(), 2);
        } else if (state.is(SBTags.Blocks.STYPHIUM_REPLACEABLE) && config.isNatural) {
            level.setBlock((BlockPos)mutableBlockPos, state.is(BlockTags.BASE_STONE_OVERWORLD) ? SBBlocks.STYPHIUM.get().defaultBlockState() : Blocks.MYCELIUM.defaultBlockState(), 2);
        } else {
            return false;
        }
        return true;
    }

    private void placeVegetation(FeaturePlaceContext<Configuration> context, WorldGenLevel level, Configuration config, RandomSource random, Set<BlockPos> posList) {
        for (BlockPos pos : posList) {
            if (!(config.vegetationChance > 0.0f) || !(random.nextFloat() < config.vegetationChance)) continue;
            this.placeVegetation(level, config, context.chunkGenerator(), random, pos);
        }
    }

    private void placeVegetation(WorldGenLevel level, Configuration config, ChunkGenerator chunkGen, RandomSource random, BlockPos pos) {
        ((PlacedFeature)config.vegetation.value()).place(level, chunkGen, random, pos.above());
    }

    public record Configuration(Holder<PlacedFeature> vegetation, float vegetationChance, int verticalRange, IntProvider xzRadius, float edgeColumnChance, boolean isNatural) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PlacedFeature.CODEC.fieldOf("vegetation").forGetter(Configuration::vegetation), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("vegetation_chance").forGetter(Configuration::vegetationChance), (App)Codec.intRange((int)1, (int)256).fieldOf("vertical_range").forGetter(Configuration::verticalRange), (App)IntProvider.CODEC.fieldOf("xz_radius").forGetter(Configuration::xzRadius), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("edge_column_chance").forGetter(Configuration::edgeColumnChance), (App)Codec.BOOL.fieldOf("isNatural").forGetter(Configuration::isNatural)).apply((Applicative)instance, Configuration::new));
    }
}

