/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.feature.mushroom;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.AbstractHugeMushroomFeature;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;

public class HugeBlackMushroomFeature
extends AbstractHugeMushroomFeature {
    public HugeBlackMushroomFeature(Codec<HugeMushroomFeatureConfiguration> codec) {
        super(codec);
    }

    protected void makeCap(LevelAccessor level, RandomSource random, BlockPos pos, int height, BlockPos.MutableBlockPos mutableBlockPos, HugeMushroomFeatureConfiguration config) {
        for (int y = height - 6; y <= height; ++y) {
            int stage = height - y;
            int radius = stage < 2 ? 1 : 3;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (!HugeBlackMushroomFeature.isBlock(x, z, stage, random)) continue;
                    mutableBlockPos.setWithOffset((Vec3i)pos, x, y, z);
                    if (level.getBlockState((BlockPos)mutableBlockPos).isSolidRender((BlockGetter)level, (BlockPos)mutableBlockPos)) continue;
                    boolean north = z <= 0;
                    boolean south = z >= 0;
                    boolean east = x >= 0;
                    boolean west = x <= 0;
                    BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)config.capProvider.getState(random, pos).setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)HugeMushroomBlock.WEST, (Comparable)Boolean.valueOf(west))).setValue((Property)HugeMushroomBlock.EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)HugeMushroomBlock.NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)HugeMushroomBlock.SOUTH, (Comparable)Boolean.valueOf(south));
                    this.setBlock((LevelWriter)level, (BlockPos)mutableBlockPos, state);
                }
            }
        }
    }

    private static boolean isBlock(int x, int z, int stage, RandomSource random) {
        int xRad = Math.abs(x);
        int zRad = Math.abs(z);
        int sum = xRad + zRad;
        if (stage == 0) {
            return sum < 2;
        }
        if (stage == 1 || stage == 2) {
            return xRad < 2 && zRad < 2;
        }
        if (stage == 3 || stage == 4 && random.nextInt(4) == 0) {
            return xRad == 2 != (zRad == 2) && sum < 4;
        }
        return false;
    }

    protected int getTreeHeight(RandomSource random) {
        int i = random.nextInt(3) + 6;
        if (random.nextInt(12) == 0) {
            i += 6;
        }
        return i;
    }

    protected int getTreeRadiusForHeight(int i, int height, int radius, int y) {
        if (y <= height && y >= height - 5) {
            return radius;
        }
        return 0;
    }
}

