/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.structure.pieces;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;

public class CryptPieces {
    public static Optional<Structure.GenerationStub> addPieces(Structure.GenerationContext context, Holder<StructureTemplatePool> start, BlockPos pos, int maxDistanceFromCenter) {
        RegistryAccess access = context.registryAccess();
        ChunkGenerator chunkGen = context.chunkGenerator();
        StructureTemplateManager manager = context.structureTemplateManager();
        LevelHeightAccessor heightAccessor = context.heightAccessor();
        WorldgenRandom random = context.random();
        Registry registry = access.registryOrThrow(Registries.TEMPLATE_POOL);
        StructureTemplatePool pool = (StructureTemplatePool)start.value();
        StructurePoolElement element = pool.getRandomTemplate((RandomSource)random);
        BlockPos vec3i = pos.subtract((Vec3i)pos);
        BlockPos blockPos = pos.subtract((Vec3i)vec3i);
        PoolElementStructurePiece piece = new PoolElementStructurePiece(manager, element, blockPos, element.getGroundLevelDelta(), Rotation.NONE, element.getBoundingBox(manager, blockPos, Rotation.NONE), LiquidSettings.IGNORE_WATERLOGGING);
        BoundingBox box = piece.getBoundingBox();
        int x = (box.maxX() + box.minX()) / 2;
        int z = (box.maxZ() + box.minZ()) / 2;
        int y = vec3i.getY();
        return Optional.of(new Structure.GenerationStub(new BlockPos(x, y, z), builder -> {
            ArrayList list = Lists.newArrayList();
            list.add(piece);
            AABB aabb = new AABB((double)(x - maxDistanceFromCenter), (double)(y - maxDistanceFromCenter), (double)(z - maxDistanceFromCenter), (double)(x + maxDistanceFromCenter + 1), (double)(y + maxDistanceFromCenter + 1), (double)(z + maxDistanceFromCenter + 1));
            VoxelShape shape = Shapes.join((VoxelShape)Shapes.create((AABB)aabb), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)box)), (BooleanOp)BooleanOp.ONLY_FIRST);
            CryptPieces.addPieces(context.randomState(), chunkGen, manager, heightAccessor, (RandomSource)random, (Registry<StructureTemplatePool>)registry, piece, list, shape);
            list.forEach(arg_0 -> ((StructurePiecesBuilder)builder).addPiece(arg_0));
        }));
    }

    private static void addPieces(RandomState pRandomState, ChunkGenerator pChunkGenerator, StructureTemplateManager pStructureTemplateManager, LevelHeightAccessor pLevel, RandomSource pRandom, Registry<StructureTemplatePool> pPools, PoolElementStructurePiece p_227219_, List<PoolElementStructurePiece> pPieces, VoxelShape p_227221_) {
        Placer placer = new Placer(pPools, 7, pChunkGenerator, pStructureTemplateManager, pPieces, pRandom);
        placer.placing.addLast(new PieceState(p_227219_, (MutableObject<VoxelShape>)new MutableObject((Object)p_227221_), 0));
        while (!placer.placing.isEmpty()) {
            PieceState pieceState = placer.placing.removeFirst();
            placer.tryPlacingChildren(pieceState.piece, pieceState.free, pieceState.depth, pLevel, pRandomState);
        }
    }

    private static final class Placer {
        private final Registry<StructureTemplatePool> pools;
        private final int maxDepth;
        private final ChunkGenerator chunkGen;
        private final StructureTemplateManager manager;
        private final List<? super PoolElementStructurePiece> pieces;
        private final RandomSource random;
        final Deque<PieceState> placing = Queues.newArrayDeque();

        Placer(Registry<StructureTemplatePool> pools, int maxDepth, ChunkGenerator chunkGen, StructureTemplateManager manager, List<? super PoolElementStructurePiece> pieces, RandomSource random) {
            this.pools = pools;
            this.maxDepth = maxDepth;
            this.chunkGen = chunkGen;
            this.manager = manager;
            this.pieces = pieces;
            this.random = random;
        }

        void tryPlacingChildren(PoolElementStructurePiece piece, MutableObject<VoxelShape> free, int depth, LevelHeightAccessor pLevel, RandomState pRandomState) {
            StructurePoolElement element = piece.getElement();
            BlockPos pos = piece.getPosition();
            Rotation rotation = piece.getRotation();
            StructureTemplatePool.Projection projection1 = element.getProjection();
            boolean flag = projection1 == StructureTemplatePool.Projection.RIGID;
            MutableObject<VoxelShape> mutableShape = new MutableObject<VoxelShape>();
            BoundingBox box = piece.getBoundingBox();
            int y = box.minY();
            block0: for (StructureTemplate.StructureBlockInfo info : element.getShuffledJigsawBlocks(this.manager, pos, rotation, this.random)) {
                StructurePoolElement poolElement;
                MutableObject<VoxelShape> mutableObject;
                Holder holder1;
                Holder holder;
                Direction direction = JigsawBlock.getFrontFacing((BlockState)info.state());
                BlockPos blockPos = info.pos();
                BlockPos blockPos1 = blockPos.relative(direction);
                int j = blockPos.getY() - y;
                int k = -1;
                ResourceKey<StructureTemplatePool> poolName = Placer.readPoolName(info);
                Optional optional = this.pools.getHolder(poolName);
                if (optional.isEmpty()) {
                    LogUtils.getLogger().warn("Empty or non-existent pool: {}", (Object)poolName.location());
                }
                if (((StructureTemplatePool)(holder = (Holder)optional.get()).value()).size() == 0 && !holder.is(Pools.EMPTY)) {
                    LogUtils.getLogger().warn("Empty or non-existent pool: {}", (Object)poolName.location());
                }
                if (((StructureTemplatePool)(holder1 = ((StructureTemplatePool)holder.value()).getFallback()).value()).size() == 0 && !holder1.is(Pools.EMPTY)) {
                    LogUtils.getLogger().warn("Empty or non-existent fallback pool: {}", (Object)holder1.unwrapKey().map(p_255599_ -> p_255599_.location().toString()).orElse("<unregistered>"));
                }
                if (box.isInside((Vec3i)blockPos1)) {
                    mutableObject = mutableShape;
                    if (mutableShape.getValue() == null) {
                        mutableShape.setValue((Object)Shapes.create((AABB)AABB.of((BoundingBox)box)));
                    }
                } else {
                    mutableObject = free;
                }
                ArrayList list = Lists.newArrayList();
                if (depth != this.maxDepth) {
                    list.addAll(((StructureTemplatePool)holder.value()).getShuffledTemplates(this.random));
                }
                list.addAll(((StructureTemplatePool)holder1.value()).getShuffledTemplates(this.random));
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && (poolElement = (StructurePoolElement)iterator.next()) != EmptyPoolElement.INSTANCE) {
                    for (Rotation rotation1 : Rotation.getShuffled((RandomSource)this.random)) {
                        List list1 = poolElement.getShuffledJigsawBlocks(this.manager, BlockPos.ZERO, rotation1, this.random);
                        for (StructureTemplate.StructureBlockInfo info1 : list1) {
                            int l2;
                            int l1;
                            if (!JigsawBlock.canAttach((StructureTemplate.StructureBlockInfo)info, (StructureTemplate.StructureBlockInfo)info1)) continue;
                            BlockPos blockPos2 = info1.pos();
                            BlockPos blockPos3 = blockPos1.subtract((Vec3i)blockPos2);
                            BoundingBox boundingBox = poolElement.getBoundingBox(this.manager, blockPos3, rotation1);
                            int i1 = boundingBox.minY();
                            StructureTemplatePool.Projection projection = poolElement.getProjection();
                            boolean flag2 = projection == StructureTemplatePool.Projection.RIGID;
                            int j1 = blockPos2.getY();
                            int k1 = j - j1 + JigsawBlock.getFrontFacing((BlockState)info.state()).getStepY();
                            if (flag && flag2) {
                                l1 = y + k1;
                            } else {
                                if (k == -1) {
                                    k = this.chunkGen.getFirstFreeHeight(blockPos.getX(), blockPos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, pLevel, pRandomState);
                                }
                                l1 = k - j1;
                            }
                            int i2 = l1 - i1;
                            BoundingBox boundingBox1 = boundingBox.moved(0, i2, 0);
                            BlockPos blockPos4 = blockPos3.offset(0, i2, 0);
                            if (Shapes.joinIsNotEmpty((VoxelShape)((VoxelShape)mutableObject.getValue()), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)boundingBox1).deflate(0.25)), (BooleanOp)BooleanOp.ONLY_SECOND)) continue;
                            mutableObject.setValue((Object)Shapes.joinUnoptimized((VoxelShape)((VoxelShape)mutableObject.getValue()), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)boundingBox1)), (BooleanOp)BooleanOp.ONLY_FIRST));
                            int i3 = piece.getGroundLevelDelta();
                            int k2 = flag2 ? i3 - k1 : poolElement.getGroundLevelDelta();
                            PoolElementStructurePiece piece1 = new PoolElementStructurePiece(this.manager, poolElement, blockPos4, k2, rotation1, boundingBox1, LiquidSettings.IGNORE_WATERLOGGING);
                            if (flag) {
                                l2 = y + j;
                            } else if (flag2) {
                                l2 = l1 + j1;
                            } else {
                                if (k == -1) {
                                    k = this.chunkGen.getFirstFreeHeight(blockPos.getX(), blockPos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, pLevel, pRandomState);
                                }
                                l2 = k + k1 / 2;
                            }
                            piece.addJunction(new JigsawJunction(blockPos1.getX(), l2 - j + i3, blockPos1.getZ(), k1, projection));
                            piece1.addJunction(new JigsawJunction(blockPos.getX(), l2 - j1 + k2, blockPos.getZ(), -k1, projection1));
                            this.pieces.add((PoolElementStructurePiece)piece1);
                            if (depth + 1 > this.maxDepth) continue block0;
                            this.placing.addLast(new PieceState(piece1, mutableObject, depth + 1));
                            continue block0;
                        }
                    }
                }
            }
        }

        private static ResourceKey<StructureTemplatePool> readPoolName(StructureTemplate.StructureBlockInfo info) {
            assert (info.nbt() != null);
            return ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.parse((String)info.nbt().getString("pool")));
        }
    }

    record PieceState(PoolElementStructurePiece piece, MutableObject<VoxelShape> free, int depth) {
    }
}

