/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.client.model;

import net.invictusslayer.slayersbeasts.client.animation.AntQueenAnimation;
import net.invictusslayer.slayersbeasts.world.entity.AntQueen;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public class AntQueenModel<T extends AntQueen>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("slayersbeasts", "ant_queen_model"), "main");
    private final ModelPart root;

    public AntQueenModel(ModelPart root) {
        this.root = root;
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.getAllParts().forEach(ModelPart::resetPose);
        this.animateWalk(AntQueenAnimation.WALK, limbSwing, limbSwingAmount, 15.0f, 10.0f);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cube_r1 = body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(47, 44).addBox(-2.0f, -2.5f, -12.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-2.5f, -5.0f, -10.0f, 5.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 23).addBox(-3.5f, -7.5f, -9.0f, 7.0f, 8.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = body.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(32, 33).addBox(-2.0f, 0.0f, -4.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-11.0f, (float)3.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = body.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(33, 0).addBox(-4.0f, -1.0f, 0.0f, 8.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-5.0f, -2.0f, 1.0f, 10.0f, 10.0f, 13.0f, new CubeDeformation(0.0f)).texOffs(32, 23).addBox(-4.0f, -0.5f, 14.0f, 8.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-11.0f, (float)3.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 40).addBox(-3.0f, 0.0f, -2.75f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(33, 44).addBox(-2.0f, 3.0f, -2.75f, 4.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)-10.0f, (float)-0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = head.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(0, 10).addBox(0.0f, 0.0f, -0.25f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)5.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition cube_r5 = head.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(6, 10).addBox(-1.0f, 0.0f, -0.25f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)5.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition cube_r6 = head.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(4, 23).addBox(-0.5448f, -4.6513f, -1.0582f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-4.0f, (float)-4.0f, (float)1.7017f, (float)0.0f, (float)-0.1309f));
        PartDefinition cube_r7 = head.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(27, 23).addBox(0.0f, -5.0f, -0.75f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-1.0f, (float)0.7854f, (float)-0.4363f, (float)0.0f));
        PartDefinition cube_r8 = head.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(0, 23).addBox(-0.4552f, -4.6513f, -1.0582f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-4.0f, (float)-4.0f, (float)1.7017f, (float)0.0f, (float)0.1309f));
        PartDefinition cube_r9 = head.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(23, 23).addBox(-1.0f, -5.0f, -0.75f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-1.0f, (float)0.7854f, (float)0.4363f, (float)0.0f));
        PartDefinition leg_left_front = body.addOrReplaceChild("leg_left_front", CubeListBuilder.create().texOffs(48, 35).addBox(-0.5f, 0.0f, -0.5f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(49, 39).addBox(2.25f, -3.0f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(44, 33).addBox(2.25f, -4.0f, 0.0f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-6.0f, (float)-8.0f, (float)0.6981f, (float)0.4363f, (float)1.0908f));
        PartDefinition leg_left_mid = body.addOrReplaceChild("leg_left_mid", CubeListBuilder.create().texOffs(46, 17).addBox(-0.5f, 0.0f, -0.5f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(36, 49).addBox(3.25f, -3.0f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(18, 44).addBox(3.25f, -4.0f, 0.0f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-5.75f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.829f));
        PartDefinition leg_left_hind = body.addOrReplaceChild("leg_left_hind", CubeListBuilder.create().texOffs(14, 46).addBox(-0.5f, 0.0f, -0.5f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(46, 48).addBox(3.25f, -4.0f, 0.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(33, 11).addBox(3.25f, -5.0f, 0.0f, 10.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-5.75f, (float)-2.0f, (float)-0.48f, (float)-0.6109f, (float)1.0036f));
        PartDefinition leg_right_front = body.addOrReplaceChild("leg_right_front", CubeListBuilder.create().texOffs(0, 6).addBox(-3.5f, 0.0f, -0.5f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(32, 49).addBox(-3.25f, -3.0f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(32, 42).addBox(-10.25f, -4.0f, 0.0f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-6.0f, (float)-8.0f, (float)0.6981f, (float)-0.4363f, (float)-1.0908f));
        PartDefinition leg_right_mid = body.addOrReplaceChild("leg_right_mid", CubeListBuilder.create().texOffs(46, 13).addBox(-4.5f, 0.0f, -0.5f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(32, 33).addBox(-4.25f, -3.0f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(15, 41).addBox(-11.25f, -4.0f, 0.0f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-5.75f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)-0.829f));
        PartDefinition leg_right_hind = body.addOrReplaceChild("leg_right_hind", CubeListBuilder.create().texOffs(0, 46).addBox(-4.5f, 0.0f, -0.5f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(28, 46).addBox(-4.25f, -4.0f, 0.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(33, 9).addBox(-13.25f, -5.0f, 0.0f, 10.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-5.75f, (float)-2.0f, (float)-0.48f, (float)0.6109f, (float)-1.0036f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

