/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.data;

import java.util.Objects;
import java.util.function.Supplier;
import net.invictusslayer.scabbard.world.level.WoodFamily;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.invictusslayer.slayersbeasts.world.level.block.DepletedCryptalithBlock;
import net.invictusslayer.slayersbeasts.world.level.block.InfusedCryptalithBlock;
import net.invictusslayer.slayersbeasts.world.level.block.SBBlockFamily;
import net.invictusslayer.slayersbeasts.world.level.block.SBWoodFamily;
import net.minecraft.core.Direction;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.Tilt;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class SBBlockStateProvider
extends BlockStateProvider {
    public SBBlockStateProvider(PackOutput output, ExistingFileHelper helper) {
        super(output, "slayersbeasts", helper);
    }

    protected void registerStatesAndModels() {
        this.generateBlockFamilies();
        this.generateWoodFamilies();
        this.horizontalPortal(SBBlocks.CRYPT_PORTAL.get());
        this.cubeRandomWithItem(SBBlocks.CRYPTALITH.get(), false);
        this.infusedCryptalith();
        this.depletedCryptalith();
        this.simpleCubeWithItem(SBBlocks.JADE_BLOCK.get());
        this.simpleCubeWithItem(SBBlocks.EXOSKELETON_ORE.get());
        this.simpleCubeWithItem(SBBlocks.DEEPSLATE_EXOSKELETON_ORE.get());
        this.simpleCubeBottomTopWithItem(SBBlocks.STYPHIUM.get());
        this.simpleCubeBottomTopWithItem(SBBlocks.DEEPSLATE_STYPHIUM.get());
        this.cubeRandomWithItem(SBBlocks.RUDOSOL.get(), true);
        this.cubeRandomWithItem(SBBlocks.ARIDISOL.get(), true);
        this.simpleCubeBottomTopWithItem(SBBlocks.ANTHILL.get());
        this.simpleCubeBottomTopWithItem(SBBlocks.ANTHILL_HATCHERY.get());
        this.simpleCubeBottomTopWithItem(SBBlocks.OOTHECA.get());
        this.simpleCubeWithItem(SBBlocks.GLEAMING_ICE.get());
        this.dripstone(SBBlocks.ICICLE.get());
        this.dripstone(SBBlocks.OBSIDIAN_SPIKE.get());
        this.doubleCrossBlock(SBBlocks.TALL_DEAD_BUSH.get());
        this.tiltCubeWithItem(SBBlocks.CRACKED_MUD.get());
        this.simpleCubeWithItem(SBBlocks.PEAT.get());
        this.flatRandomBlock(SBBlocks.ALGAE.get());
        this.cubeRandomWithItem(SBBlocks.BLACK_SAND.get(), true);
        this.cubeBottomTopWithItem(SBBlocks.BLACK_SANDSTONE.get(), this.extend(this.blockTexture(SBBlocks.BLACK_SANDSTONE.get()), "_side"), this.extend(this.blockTexture(SBBlocks.BLACK_SANDSTONE.get()), "_bottom"), this.extend(this.blockTexture(SBBlocks.BLACK_SANDSTONE.get()), "_top"));
        this.slabWithItem(SBBlocks.BLACK_SANDSTONE_SLAB.get(), this.blockTexture(SBBlocks.BLACK_SANDSTONE.get()), this.extend(this.blockTexture(SBBlocks.BLACK_SANDSTONE.get()), "_side"), this.extend(this.blockTexture(SBBlocks.BLACK_SANDSTONE.get()), "_bottom"), this.extend(this.blockTexture(SBBlocks.BLACK_SANDSTONE.get()), "_top"));
        this.stairWithItem(SBBlocks.BLACK_SANDSTONE_STAIRS.get(), this.extend(this.blockTexture(SBBlocks.BLACK_SANDSTONE.get()), "_side"), this.extend(this.blockTexture(SBBlocks.BLACK_SANDSTONE.get()), "_bottom"), this.extend(this.blockTexture(SBBlocks.BLACK_SANDSTONE.get()), "_top"));
        this.wallWithItem(SBBlocks.BLACK_SANDSTONE_WALL.get(), this.extend(this.blockTexture(SBBlocks.BLACK_SANDSTONE.get()), "_side"));
        this.cubeWithItem(SBBlocks.SMOOTH_BLACK_SANDSTONE.get(), this.extend(this.blockTexture(SBBlocks.BLACK_SANDSTONE.get()), "_top"));
        this.slabWithItem(SBBlocks.SMOOTH_BLACK_SANDSTONE_SLAB.get(), this.blockTexture(SBBlocks.BLACK_SANDSTONE.get()), this.extend(this.blockTexture(SBBlocks.BLACK_SANDSTONE.get()), "_top"), this.extend(this.blockTexture(SBBlocks.BLACK_SANDSTONE.get()), "_top"), this.extend(this.blockTexture(SBBlocks.BLACK_SANDSTONE.get()), "_top"));
        this.stairWithItem(SBBlocks.SMOOTH_BLACK_SANDSTONE_STAIRS.get(), this.extend(this.blockTexture(SBBlocks.BLACK_SANDSTONE.get()), "_top"), this.extend(this.blockTexture(SBBlocks.BLACK_SANDSTONE.get()), "_top"), this.extend(this.blockTexture(SBBlocks.BLACK_SANDSTONE.get()), "_top"));
        this.columnWithItem(SBBlocks.CUT_BLACK_SANDSTONE.get(), this.blockTexture(SBBlocks.CUT_BLACK_SANDSTONE.get()), this.extend(this.blockTexture(SBBlocks.BLACK_SANDSTONE.get()), "_top"));
        this.slabWithItem(SBBlocks.CUT_BLACK_SANDSTONE_SLAB.get(), this.blockTexture(SBBlocks.CUT_BLACK_SANDSTONE.get()), this.extend(this.blockTexture(SBBlocks.BLACK_SANDSTONE.get()), "_top"), this.blockTexture(SBBlocks.CUT_BLACK_SANDSTONE.get()), this.extend(this.blockTexture(SBBlocks.BLACK_SANDSTONE.get()), "_top"));
        this.columnWithItem(SBBlocks.CHISELED_BLACK_SANDSTONE.get(), this.blockTexture(SBBlocks.CHISELED_BLACK_SANDSTONE.get()), this.extend(this.blockTexture(SBBlocks.BLACK_SANDSTONE.get()), "_top"));
        this.doubleCrossBlock(SBBlocks.TALL_BROWN_MUSHROOM.get());
        this.doubleCrossBlock(SBBlocks.TALL_RED_MUSHROOM.get());
        this.mushroomBlockWithItem(SBBlocks.BLACK_MUSHROOM_BLOCK.get(), "mushroom_block_dark_inside");
        this.cross(SBBlocks.BLACK_MUSHROOM.get());
        this.pottedCross(SBBlocks.POTTED_BLACK_MUSHROOM.get(), SBBlocks.BLACK_MUSHROOM.get());
        this.doubleCrossBlock(SBBlocks.TALL_BLACK_MUSHROOM.get());
        this.mushroomBlockWithItem(SBBlocks.WHITE_MUSHROOM_BLOCK.get(), null);
        this.cross(SBBlocks.WHITE_MUSHROOM.get());
        this.pottedCross(SBBlocks.POTTED_WHITE_MUSHROOM.get(), SBBlocks.WHITE_MUSHROOM.get());
        this.doubleCrossBlock(SBBlocks.TALL_WHITE_MUSHROOM.get());
        this.simpleCubeWithItem(SBBlocks.ALBINO_REDWOOD_LEAVES.get());
        this.cross(SBBlocks.ALBINO_REDWOOD_SAPLING.get());
        this.pottedCross(SBBlocks.POTTED_ALBINO_REDWOOD_SAPLING.get(), SBBlocks.ALBINO_REDWOOD_SAPLING.get());
        this.cross(SBBlocks.WILLOW_BRANCH.get());
        this.cross(SBBlocks.WILLOW_BRANCH_PLANT.get());
    }

    private void generateWoodFamilies() {
        SBWoodFamily.getAllFamilies().forEach(family -> {
            Supplier planks = family.get(WoodFamily.Variant.PLANKS);
            Supplier stripped = family.get(WoodFamily.Variant.STRIPPED_LOG);
            if (planks != null) {
                this.simpleCubeWithItem((Block)planks.get());
            }
            family.getVariants().forEach((arg_0, arg_1) -> this.lambda$generateWoodFamilies$0((Supplier)planks, family, (Supplier)stripped, arg_0, arg_1));
        });
    }

    private void generateBlockFamilies() {
        SBBlockFamily.getAllFamilies().filter(BlockFamily::shouldGenerateModel).forEach(family -> {
            Block base = family.getBaseBlock();
            this.simpleCubeWithItem(base);
            family.getVariants().forEach((variant, block) -> {
                switch (variant) {
                    case CHISELED: 
                    case CRACKED: {
                        this.simpleCubeWithItem((Block)block);
                        break;
                    }
                    case SLAB: {
                        this.simpleSlabWithItem((Block)block, base);
                        break;
                    }
                    case STAIRS: {
                        this.simpleStairWithItem((Block)block, base);
                        break;
                    }
                    case FENCE: {
                        this.fenceWithItem((Block)block, base);
                        break;
                    }
                    case FENCE_GATE: {
                        this.fenceGateWithItem((Block)block, base);
                        break;
                    }
                    case BUTTON: {
                        this.buttonWithItem((Block)block, base);
                        break;
                    }
                    case PRESSURE_PLATE: {
                        this.pressurePlateWithItem((Block)block, base);
                        break;
                    }
                    case DOOR: {
                        this.doorBlockWithRenderType((DoorBlock)block, this.extend((Block)block, "_bottom"), this.extend((Block)block, "_top"), "cutout");
                        break;
                    }
                    case TRAPDOOR: {
                        this.trapdoorWithItem((Block)block);
                        break;
                    }
                    case WALL: {
                        this.wallWithItem((Block)block, this.blockTexture(base));
                    }
                }
            });
        });
    }

    private void horizontalPortal(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(block))).texture("portal", this.blockTexture(block))).texture("particle", this.blockTexture(block))).element().from(0.0f, 6.0f, 0.0f).to(16.0f, 12.0f, 16.0f).face(Direction.UP).texture("#portal").end().face(Direction.DOWN).texture("#portal").end().end()).renderType("solid")).build());
    }

    private void verticalPortal(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            boolean isX = state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS) == Direction.Axis.X;
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(block) + (isX ? "_ns" : "_ew"))).texture("portal", this.blockTexture(block))).texture("particle", this.blockTexture(block))).element().from(isX ? 0.0f : 6.0f, 0.0f, isX ? 6.0f : 0.0f).to(isX ? 16.0f : 10.0f, 16.0f, isX ? 10.0f : 16.0f).face(isX ? Direction.NORTH : Direction.EAST).texture("#portal").end().face(isX ? Direction.SOUTH : Direction.WEST).texture("#portal").end().end()).renderType("translucent")).build();
        });
    }

    private void doubleCrossBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            String suffix = state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER ? "_bottom" : "_top";
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(this.name(block) + suffix, this.extend(block, suffix))).renderType("cutout")).build();
        });
    }

    private void infusedCryptalith() {
        Block block = SBBlocks.INFUSED_CRYPTALITH.get();
        this.getVariantBuilder(block).forAllStates(state -> {
            String suffix = (Boolean)state.getValue((Property)BlockStateProperties.EYE) != false ? "_active" : "";
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeBottomTop(this.name(block) + suffix, this.extend(block, "_side"), this.blockTexture(SBBlocks.CRYPTALITH.get()), this.extend(block, "_top" + suffix))).rotationY((int)((Direction)state.getValue((Property)InfusedCryptalithBlock.FACING)).toYRot()).build();
        });
        this.simpleBlockItem(block, (ModelFile)this.models().withExistingParent(this.name(block), "minecraft:block/cube_bottom_top"));
    }

    private void depletedCryptalith() {
        Block block = SBBlocks.DEPLETED_CRYPTALITH.get();
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeBottomTop(this.name(block), this.extend(block, "_side"), this.blockTexture(SBBlocks.CRYPTALITH.get()), this.extend(block, "_top"))).rotationY((int)((Direction)state.getValue((Property)DepletedCryptalithBlock.FACING)).toYRot()).build());
        this.simpleBlockItem(block, (ModelFile)this.models().withExistingParent(this.name(block), "minecraft:block/cube_bottom_top"));
    }

    private void dripstone(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            String suffix = "_" + ((DripstoneThickness)state.getValue((Property)BlockStateProperties.DRIPSTONE_THICKNESS)).getSerializedName() + "_" + ((Direction)state.getValue((Property)BlockStateProperties.VERTICAL_DIRECTION)).getSerializedName();
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(this.name(block) + suffix, this.extend(block, suffix))).renderType("cutout")).build();
        });
    }

    private void thinMushroomStemWithItem(Block block, ResourceLocation top, ResourceLocation side) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(block))).texture("top", top)).texture("side", side)).element().from(4.0f, 0.0f, 4.0f).to(12.0f, 16.0f, 12.0f).allFaces((direction, builder) -> builder.texture(direction.getAxis() == Direction.Axis.Y ? "#top" : "#side")).end();
        this.getVariantBuilder(block).forAllStates(arg_0 -> SBBlockStateProvider.lambda$thinMushroomStemWithItem$11((ModelFile)model, arg_0));
        this.simpleBlockItem(block, (ModelFile)model);
    }

    private void pottedCross(Block potted, Block plant) {
        this.simpleBlock(potted, (ModelFile)((BlockModelBuilder)this.models().singleTexture(this.name(potted), ResourceLocation.withDefaultNamespace((String)"flower_pot_cross"), "plant", this.blockTexture(plant))).renderType("cutout"));
    }

    private void mushroomBlockWithItem(Block block, String inside) {
        ModelBuilder outsideModel = ((BlockModelBuilder)this.models().withExistingParent(this.name(block), "minecraft:block/template_single_face")).texture("texture", this.blockTexture(block));
        ModelFile.ExistingModelFile insideModel = inside != null ? ((BlockModelBuilder)this.models().withExistingParent(inside, "minecraft:block/template_single_face")).texture("texture", ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)("block/" + inside))) : this.models().getExistingFile(ResourceLocation.withDefaultNamespace((String)"block/mushroom_block_inside"));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile((ModelFile)outsideModel).addModel()).condition((Property)BlockStateProperties.NORTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)outsideModel).rotationY(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.EAST, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)outsideModel).rotationY(180).uvLock(true).addModel()).condition((Property)BlockStateProperties.SOUTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)outsideModel).rotationY(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.WEST, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)outsideModel).rotationX(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.UP, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)outsideModel).rotationX(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.DOWN, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)insideModel).addModel()).condition((Property)BlockStateProperties.NORTH, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)insideModel).rotationY(90).uvLock(false).addModel()).condition((Property)BlockStateProperties.EAST, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)insideModel).rotationY(180).uvLock(false).addModel()).condition((Property)BlockStateProperties.SOUTH, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)insideModel).rotationY(270).uvLock(false).addModel()).condition((Property)BlockStateProperties.WEST, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)insideModel).rotationX(270).uvLock(false).addModel()).condition((Property)BlockStateProperties.UP, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)insideModel).rotationX(90).uvLock(false).addModel()).condition((Property)BlockStateProperties.DOWN, (Comparable[])new Boolean[]{false});
        this.simpleBlockItem(block, (ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_inventory", "minecraft:block/cube_all")).texture("all", this.blockTexture(block)));
    }

    private void logWithItem(Block block) {
        this.logBlock((RotatedPillarBlock)block);
        this.simpleBlockItem(block, (ModelFile)this.models().withExistingParent(this.name(block), "minecraft:block/cube_column"));
    }

    private void woodWithItem(Block block, Block texture) {
        this.axisBlock((RotatedPillarBlock)block, this.blockTexture(texture), this.blockTexture(texture));
        this.simpleBlockItem(block, (ModelFile)this.models().withExistingParent(this.name(block), "minecraft:block/cube_column"));
    }

    private void cross(Block block) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(this.name(block), this.blockTexture(block))).renderType("cutout"));
    }

    private void simpleSlabWithItem(Block block, Block texture) {
        this.slabBlock((SlabBlock)block, this.blockTexture(texture), this.blockTexture(texture));
        this.simpleBlockItem(block, (ModelFile)this.models().withExistingParent(this.name(block), "minecraft:block/slab"));
    }

    private void slabWithItem(Block block, ResourceLocation full, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.slabBlock((SlabBlock)block, full, side, bottom, top);
        this.simpleBlockItem(block, (ModelFile)this.models().withExistingParent(this.name(block), "minecraft:block/slab"));
    }

    private void simpleStairWithItem(Block block, Block texture) {
        this.stairsBlock((StairBlock)block, this.blockTexture(texture));
        this.simpleBlockItem(block, (ModelFile)this.models().withExistingParent(this.name(block), "minecraft:block/stairs"));
    }

    private void stairWithItem(Block block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.stairsBlock((StairBlock)block, side, bottom, top);
        this.simpleBlockItem(block, (ModelFile)this.models().withExistingParent(this.name(block), "minecraft:block/stairs"));
    }

    private void fenceWithItem(Block block, Block texture) {
        this.fenceBlock((FenceBlock)block, this.blockTexture(texture));
        this.simpleBlockItem(block, (ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name(block), "minecraft:block/fence_inventory")).texture("texture", this.blockTexture(texture)));
    }

    private void fenceGateWithItem(Block block, Block texture) {
        this.fenceGateBlock((FenceGateBlock)block, this.blockTexture(texture));
        this.simpleBlockItem(block, (ModelFile)this.models().withExistingParent(this.name(block), "minecraft:block/template_fence_gate"));
    }

    private void wallWithItem(Block block, ResourceLocation texture) {
        this.wallBlock((WallBlock)block, texture);
        this.simpleBlockItem(block, (ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name(block), "minecraft:block/wall_inventory")).texture("wall", texture));
    }

    private void buttonWithItem(Block block, Block texture) {
        this.buttonBlock((ButtonBlock)block, this.blockTexture(texture));
        this.simpleBlockItem(block, (ModelFile)this.models().withExistingParent(this.name(block), "minecraft:block/button_inventory"));
    }

    private void pressurePlateWithItem(Block block, Block texture) {
        this.pressurePlateBlock((PressurePlateBlock)block, this.blockTexture(texture));
        this.simpleBlockItem(block, (ModelFile)this.models().withExistingParent(this.name(block), "minecraft:block/pressure_plate_up"));
    }

    private void trapdoorWithItem(Block block) {
        this.trapdoorBlockWithRenderType((TrapDoorBlock)block, this.blockTexture(block), true, "cutout");
        this.simpleBlockItem(block, (ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name(block), "minecraft:block/template_trapdoor_bottom")).texture("texture", this.blockTexture(block)));
    }

    private void hangingSign(Block sign, Block wallSign, ResourceLocation texture) {
        ModelBuilder model = this.models().sign(this.name(sign), texture);
        this.simpleBlock(sign, (ModelFile)model);
        this.simpleBlock(wallSign, (ModelFile)model);
    }

    private void cubeRandomWithItem(Block block, boolean onlyTop) {
        ModelBuilder model = this.models().cubeAll(this.name(block), this.blockTexture(block));
        this.getVariantBuilder(block).forAllStates(arg_0 -> SBBlockStateProvider.lambda$cubeRandomWithItem$12(onlyTop, (ModelFile)model, arg_0));
        this.simpleBlockItem(block, (ModelFile)this.models().withExistingParent(this.name(block), "minecraft:block/cube_all"));
    }

    private void simpleCubeWithItem(Block block) {
        this.cubeWithItem(block, this.blockTexture(block));
    }

    private void cubeWithItem(Block block, ResourceLocation texture) {
        this.simpleBlock(block, (ModelFile)this.models().cubeAll(this.name(block), texture));
        this.simpleBlockItem(block, (ModelFile)this.models().withExistingParent(this.name(block), "minecraft:block/cube_all"));
    }

    private void columnWithItem(Block block, ResourceLocation side, ResourceLocation end) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeColumn(this.name(block), side, end)).build());
        this.simpleBlockItem(block, (ModelFile)this.models().withExistingParent(this.name(block), "minecraft:block/cube_column"));
    }

    private void tiltCubeWithItem(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            String tilt = "_" + ((Tilt)state.getValue((Property)BlockStateProperties.TILT)).getSerializedName();
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeAll(this.name(block) + tilt, this.extend(block, tilt))).build();
        });
        this.simpleBlockItem(block, (ModelFile)this.models().withExistingParent(this.name(block) + "_none", "minecraft:block/cube_all"));
    }

    private void flatRandomBlock(Block block) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(block))).ao(false)).texture("texture", this.blockTexture(block))).texture("particle", this.blockTexture(block))).element().from(0.0f, 0.25f, 0.0f).to(16.0f, 0.25f, 16.0f).face(Direction.UP).texture("#texture").end().face(Direction.DOWN).texture("#texture").end().end()).renderType("cutout");
        this.getVariantBuilder(block).forAllStates(arg_0 -> SBBlockStateProvider.lambda$flatRandomBlock$15((ModelFile)model, arg_0));
    }

    private void simpleCubeBottomTopWithItem(Block block) {
        this.cubeBottomTopWithItem(block, this.extend(block, "_side"), this.extend(block, "_bottom"), this.extend(block, "_top"));
    }

    private void cubeBottomTopWithItem(Block block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeBottomTop(this.name(block), side, bottom, top)).build());
        this.simpleBlockItem(block, (ModelFile)this.models().withExistingParent(this.name(block), "minecraft:block/cube_bottom_top"));
    }

    private String name(Block block) {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).getPath();
    }

    private ResourceLocation extend(Block block, String suffix) {
        return this.extend(this.blockTexture(block), suffix);
    }

    private ResourceLocation extend(ResourceLocation loc, String suffix) {
        return ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)(loc.getPath() + suffix));
    }

    private static /* synthetic */ ConfiguredModel[] lambda$flatRandomBlock$15(ModelFile model, BlockState state) {
        return ConfiguredModel.allYRotations((ModelFile)model, (int)0, (boolean)false);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$cubeRandomWithItem$12(boolean onlyTop, ModelFile model, BlockState state) {
        return onlyTop ? ConfiguredModel.allYRotations((ModelFile)model, (int)0, (boolean)false) : ConfiguredModel.allRotations((ModelFile)model, (boolean)false);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$thinMushroomStemWithItem$11(ModelFile model, BlockState state) {
        return ConfiguredModel.builder().modelFile(model).build();
    }

    private /* synthetic */ void lambda$generateWoodFamilies$0(Supplier planks, WoodFamily family, Supplier stripped, WoodFamily.Variant variant, Supplier supplier) {
        Object patt6342$temp = supplier.get();
        if (!(patt6342$temp instanceof Block)) {
            return;
        }
        Block block = (Block)patt6342$temp;
        switch (variant) {
            case BUTTON: {
                this.buttonWithItem(block, (Block)planks.get());
                break;
            }
            case DOOR: {
                this.doorBlockWithRenderType((DoorBlock)block, this.extend(block, "_bottom"), this.extend(block, "_top"), "cutout");
                break;
            }
            case FENCE: {
                this.fenceWithItem(block, (Block)planks.get());
                break;
            }
            case FENCE_GATE: {
                this.fenceGateWithItem(block, (Block)planks.get());
                break;
            }
            case HANGING_SIGN: {
                this.hangingSign(block, (Block)family.get(WoodFamily.Variant.WALL_HANGING_SIGN).get(), this.blockTexture((Block)stripped.get()));
                break;
            }
            case LEAVES: {
                this.simpleCubeWithItem(block);
                break;
            }
            case LOG: {
                this.logWithItem(block);
                break;
            }
            case SAPLING: {
                this.cross(block);
                break;
            }
            case SIGN: {
                this.signBlock((StandingSignBlock)block, (WallSignBlock)family.get(WoodFamily.Variant.WALL_SIGN).get(), this.blockTexture((Block)planks.get()));
                break;
            }
            case SLAB: {
                this.simpleSlabWithItem(block, (Block)planks.get());
                break;
            }
            case STAIRS: {
                this.simpleStairWithItem(block, (Block)planks.get());
                break;
            }
            case STRIPPED_LOG: {
                this.logWithItem((Block)stripped.get());
                break;
            }
            case STRIPPED_WOOD: {
                this.woodWithItem(block, (Block)stripped.get());
                break;
            }
            case POTTED_SAPLING: {
                this.pottedCross(block, (Block)family.get(WoodFamily.Variant.SAPLING).get());
                break;
            }
            case PRESSURE_PLATE: {
                this.pressurePlateWithItem(block, (Block)planks.get());
                break;
            }
            case TRAPDOOR: {
                this.trapdoorWithItem(block);
                break;
            }
            case WOOD: {
                this.woodWithItem(block, (Block)family.get(WoodFamily.Variant.LOG).get());
            }
        }
    }
}

