/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.data;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.invictusslayer.scabbard.world.biome.BiomeModifierHandler;
import net.invictusslayer.scabbard.world.biome.ForgeBiomeModifications;
import net.invictusslayer.slayersbeasts.data.SBBlockStateProvider;
import net.invictusslayer.slayersbeasts.data.SBItemModelProvider;
import net.invictusslayer.slayersbeasts.data.SBRecipeProvider;
import net.invictusslayer.slayersbeasts.data.SBSoundDefinitionsProvider;
import net.invictusslayer.slayersbeasts.data.lang.EnUsLangProvider;
import net.invictusslayer.slayersbeasts.data.loot.SBBlockLoot;
import net.invictusslayer.slayersbeasts.data.loot.SBChestLoot;
import net.invictusslayer.slayersbeasts.data.loot.SBEntityLoot;
import net.invictusslayer.slayersbeasts.data.loot.SBLootTables;
import net.invictusslayer.slayersbeasts.data.tags.SBBiomeTagsProvider;
import net.invictusslayer.slayersbeasts.data.tags.SBBlockTagsProvider;
import net.invictusslayer.slayersbeasts.data.tags.SBEntityTagsProvider;
import net.invictusslayer.slayersbeasts.data.tags.SBItemTagsProvider;
import net.invictusslayer.slayersbeasts.data.tags.SBPoiTagsProvider;
import net.invictusslayer.slayersbeasts.world.level.biome.SBBiomeModifications;
import net.invictusslayer.slayersbeasts.world.level.biome.SBBiomes;
import net.invictusslayer.slayersbeasts.world.level.dimension.SBDimensions;
import net.invictusslayer.slayersbeasts.world.level.gen.SBNoises;
import net.invictusslayer.slayersbeasts.world.level.gen.feature.SBConfiguredFeatures;
import net.invictusslayer.slayersbeasts.world.level.gen.feature.SBPlacedFeatures;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.SBProcessorLists;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.SBStructureSets;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.SBStructures;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.pools.SBPools;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SBForgeDataGen {
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.CONFIGURED_FEATURE, SBConfiguredFeatures::bootstrap).add(Registries.PLACED_FEATURE, SBPlacedFeatures::bootstrap).add(Registries.BIOME, SBBiomes::bootstrap).add(Registries.DIMENSION_TYPE, SBDimensions::bootstrap).add(Registries.STRUCTURE, SBStructures::bootstrap).add(Registries.STRUCTURE_SET, SBStructureSets::bootstrap).add(Registries.TEMPLATE_POOL, SBPools::bootstrap).add(Registries.PROCESSOR_LIST, SBProcessorLists::bootstrap).add(Registries.NOISE, SBNoises::bootstrap).add(ForgeRegistries.Keys.BIOME_MODIFIERS, context -> ForgeBiomeModifications.bootstrap((BootstapContext)context, (BiomeModifierHandler)SBBiomeModifications.HANDLER));

    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean hasServer = event.includeServer();
        gen.addProvider(hasServer, (DataProvider)new DatapackBuiltinEntriesProvider(output, provider, BUILDER, Collections.singleton("slayersbeasts")));
        SBBlockTagsProvider blockTags = (SBBlockTagsProvider)gen.addProvider(hasServer, (DataProvider)new SBBlockTagsProvider(output, provider, helper));
        gen.addProvider(hasServer, (DataProvider)new SBItemTagsProvider(output, provider, (TagsProvider<Block>)blockTags, helper));
        gen.addProvider(hasServer, (DataProvider)new SBBiomeTagsProvider(output, (CompletableFuture<HolderLookup.Provider>)provider.thenApply(SBForgeDataGen::patchRegistry), helper));
        gen.addProvider(hasServer, (DataProvider)new SBEntityTagsProvider(output, provider, helper));
        gen.addProvider(hasServer, (DataProvider)new SBPoiTagsProvider(output, provider, helper));
        gen.addProvider(hasServer, (DataProvider)new EnUsLangProvider(output));
        gen.addProvider(hasServer, (DataProvider)new SBRecipeProvider(output));
        gen.addProvider(hasServer, (DataProvider)new SBBlockStateProvider(output, helper));
        gen.addProvider(hasServer, (DataProvider)new SBItemModelProvider(output, helper));
        gen.addProvider(hasServer, (DataProvider)new SBSoundDefinitionsProvider(output, helper));
        gen.addProvider(hasServer, (DataProvider)new LootTableProvider(output, SBLootTables.all(), List.of(new LootTableProvider.SubProviderEntry(SBBlockLoot::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(SBEntityLoot::new, LootContextParamSets.ENTITY), new LootTableProvider.SubProviderEntry(SBChestLoot::new, LootContextParamSets.CHEST))));
    }

    private static HolderLookup.Provider patchRegistry(HolderLookup.Provider provider) {
        return BUILDER.buildPatch((RegistryAccess)RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY), provider);
    }
}

