/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.data.loot;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class SBLootTables {
    private static final Set<ResourceLocation> LOCATIONS = Sets.newHashSet();
    private static final Set<ResourceLocation> IMMUTABLE_LOCATIONS = Collections.unmodifiableSet(LOCATIONS);
    public static final ResourceLocation CRYPT_COMMON = SBLootTables.register("chests/crypt_common");
    public static final ResourceLocation CRYPT_RARE = SBLootTables.register("chests/crypt_rare");
    public static final ResourceLocation REDWOOD_LOGS = SBLootTables.register("chests/redwood_logs");
    public static final ResourceLocation REDWOOD_TOOLS = SBLootTables.register("chests/redwood_tools");

    private static ResourceLocation register(String path) {
        ResourceLocation id = new ResourceLocation("slayersbeasts", path);
        if (LOCATIONS.add(id)) {
            return id;
        }
        throw new IllegalArgumentException(String.valueOf(id) + " is already a registered loot table");
    }

    public static Set<ResourceLocation> all() {
        return IMMUTABLE_LOCATIONS;
    }
}

