/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.entity;

import java.util.UUID;
import net.invictusslayer.slayersbeasts.world.entity.AbstractAnt;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.Nullable;

public class AntSoldier
extends AbstractAnt
implements NeutralMob {
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.defineId(AntSoldier.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private UUID target;

    public AntSoldier(EntityType<AntSoldier> type, Level level) {
        super(type, level);
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, false, false, arg_0 -> ((AntSoldier)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, false, true, arg_0 -> ((AntSoldier)this).isAngryAt(arg_0)));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AntSoldier.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.22).add(Attributes.MAX_HEALTH, 15.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5);
    }

    public static boolean canSpawn(EntityType<AntSoldier> entity, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return AntSoldier.checkMobSpawnRules(entity, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, (Object)time);
    }

    public UUID getPersistentAngerTarget() {
        return this.target;
    }

    public void setPersistentAngerTarget(@Nullable UUID target) {
        this.target = target;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(TimeUtil.rangeOfSeconds((int)30, (int)60).sample(this.random));
    }
}

