/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.biome.region;

import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.invictusslayer.slayersbeasts.world.level.biome.SBBiomes;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import terrablender.api.ParameterUtils;
import terrablender.api.Region;
import terrablender.api.RegionType;

public class SBOverworldRegion
extends Region {
    private final ParameterUtils.Temperature[] TEMPERATURE = new ParameterUtils.Temperature[]{ParameterUtils.Temperature.ICY, ParameterUtils.Temperature.COOL, ParameterUtils.Temperature.NEUTRAL, ParameterUtils.Temperature.WARM, ParameterUtils.Temperature.HOT};
    private final ParameterUtils.Humidity[] HUMIDITY = new ParameterUtils.Humidity[]{ParameterUtils.Humidity.ARID, ParameterUtils.Humidity.DRY, ParameterUtils.Humidity.NEUTRAL, ParameterUtils.Humidity.WET, ParameterUtils.Humidity.HUMID};
    private final ParameterUtils.Continentalness[] INLANDNESS = new ParameterUtils.Continentalness[]{ParameterUtils.Continentalness.COAST, ParameterUtils.Continentalness.NEAR_INLAND, ParameterUtils.Continentalness.MID_INLAND, ParameterUtils.Continentalness.FAR_INLAND};
    private final ParameterUtils.Erosion[] EROSION = new ParameterUtils.Erosion[]{ParameterUtils.Erosion.EROSION_0, ParameterUtils.Erosion.EROSION_1, ParameterUtils.Erosion.EROSION_2, ParameterUtils.Erosion.EROSION_3, ParameterUtils.Erosion.EROSION_4, ParameterUtils.Erosion.EROSION_5, ParameterUtils.Erosion.EROSION_6};
    private final ResourceKey<Biome>[] RIVERS = new ResourceKey[]{Biomes.FROZEN_RIVER, Biomes.RIVER, Biomes.RIVER, Biomes.RIVER, Biomes.RIVER};
    private final ResourceKey<Biome>[] BEACHES = new ResourceKey[]{Biomes.SNOWY_BEACH, Biomes.BEACH, Biomes.BEACH, Biomes.BEACH, Biomes.DESERT};
    private final ResourceKey<Biome>[] SWAMPS = new ResourceKey[]{SBBiomes.GLACIATE_SWAMP, SBBiomes.INKY_MOOR, SBBiomes.INKY_MOOR, SBBiomes.BAYOU, SBBiomes.BAYOU};
    private final ResourceKey<Biome>[] SLOPES = new ResourceKey[]{Biomes.SNOWY_SLOPES, Biomes.SNOWY_SLOPES, Biomes.GROVE, Biomes.GROVE, Biomes.GROVE};
    private final ResourceKey<Biome>[][] MIDDLE_NORMAL = new ResourceKey[][]{{SBBiomes.FROZEN_THICKET, SBBiomes.ASPEN_FOREST, SBBiomes.CHAPARRAL, SBBiomes.CHAPARRAL, SBBiomes.DEAD_SANDS}, {SBBiomes.FROZEN_THICKET, SBBiomes.ASPEN_FOREST, SBBiomes.CHAPARRAL, SBBiomes.CHAPARRAL, SBBiomes.DEAD_SANDS}, {SBBiomes.FROZEN_THICKET, SBBiomes.ASPEN_FOREST, SBBiomes.OLD_GROWTH_REDWOOD_GROVE, SBBiomes.ANCIENT_GROVE, SBBiomes.DEAD_SANDS}, {SBBiomes.FROZEN_THICKET, SBBiomes.ASPEN_FOREST, SBBiomes.REDWOOD_GROVE, SBBiomes.RAINFOREST, SBBiomes.DEAD_SANDS}, {SBBiomes.FROZEN_THICKET, SBBiomes.ASPEN_FOREST, SBBiomes.REDWOOD_GROVE, SBBiomes.RAINFOREST, SBBiomes.DEAD_SANDS}};
    private final ResourceKey<Biome>[][] MIDDLE_VARIANT = new ResourceKey[][]{{SBBiomes.PETRIFIED_WOODS, SBBiomes.ASPEN_FOREST, SBBiomes.CHAPARRAL, SBBiomes.CHAPARRAL, SBBiomes.OUTBACK}, {SBBiomes.FROZEN_THICKET, SBBiomes.ASPEN_FOREST, SBBiomes.CHAPARRAL, SBBiomes.CHAPARRAL, SBBiomes.OUTBACK}, {SBBiomes.FROZEN_THICKET, SBBiomes.ASPEN_FOREST, SBBiomes.OLD_GROWTH_REDWOOD_GROVE, SBBiomes.ANCIENT_GROVE, SBBiomes.OUTBACK}, {SBBiomes.FROZEN_THICKET, SBBiomes.ASPEN_FOREST, SBBiomes.REDWOOD_GROVE, SBBiomes.EUCALYPT_WOODLAND, SBBiomes.OUTBACK}, {SBBiomes.FROZEN_THICKET, SBBiomes.ASPEN_FOREST, SBBiomes.REDWOOD_GROVE, SBBiomes.EUCALYPT_WOODLAND, SBBiomes.OUTBACK}};
    private final ResourceKey<Biome>[][] PLATEAU_NORMAL = new ResourceKey[][]{{SBBiomes.FROZEN_THICKET, SBBiomes.CHAPARRAL, SBBiomes.CHAPARRAL, SBBiomes.BLACK_DUNES, SBBiomes.BRUSHLAND}, {SBBiomes.FROZEN_THICKET, SBBiomes.CHAPARRAL, SBBiomes.CHAPARRAL, SBBiomes.BLACK_DUNES, SBBiomes.BRUSHLAND}, {SBBiomes.FROZEN_THICKET, SBBiomes.CHAPARRAL, SBBiomes.CHAPARRAL, SBBiomes.BLACK_DUNES, SBBiomes.BRUSHLAND}, {SBBiomes.FROZEN_THICKET, SBBiomes.CHAPARRAL, SBBiomes.CHAPARRAL, SBBiomes.BLACK_DUNES, SBBiomes.WOODED_BRUSHLAND}, {SBBiomes.FROZEN_THICKET, SBBiomes.ASPEN_FOREST, SBBiomes.EUCALYPT_WOODLAND, SBBiomes.BLACK_DUNES, SBBiomes.WOODED_BRUSHLAND}};
    private final ResourceKey<Biome>[][] PLATEAU_VARIANT = new ResourceKey[][]{{SBBiomes.PETRIFIED_WOODS, SBBiomes.ASPEN_FOREST, SBBiomes.OLD_GROWTH_REDWOOD_GROVE, SBBiomes.BLACK_DUNES, SBBiomes.ROCKY_BRUSHLAND}, {SBBiomes.FROZEN_THICKET, SBBiomes.ASPEN_FOREST, SBBiomes.REDWOOD_GROVE, SBBiomes.BLACK_DUNES, SBBiomes.ROCKY_BRUSHLAND}, {SBBiomes.FROZEN_THICKET, SBBiomes.ASPEN_FOREST, SBBiomes.REDWOOD_GROVE, SBBiomes.BLACK_DUNES, SBBiomes.BRUSHLAND}, {SBBiomes.FROZEN_THICKET, SBBiomes.ASPEN_FOREST, SBBiomes.EUCALYPT_WOODLAND, SBBiomes.BLACK_DUNES, SBBiomes.WOODED_BRUSHLAND}, {SBBiomes.FROZEN_THICKET, SBBiomes.ASPEN_FOREST, SBBiomes.EUCALYPT_WOODLAND, SBBiomes.BLACK_DUNES, SBBiomes.WOODED_BRUSHLAND}};
    private final ResourceKey<Biome>[][] SHATTERED_NORMAL = new ResourceKey[][]{{Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_HILLS, SBBiomes.CHAPARRAL, SBBiomes.BLACK_DUNES}, {Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_HILLS, SBBiomes.CHAPARRAL, SBBiomes.BLACK_DUNES}, {Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_HILLS, SBBiomes.CHAPARRAL, SBBiomes.BLACK_DUNES}, {Biomes.WINDSWEPT_FOREST, Biomes.WINDSWEPT_FOREST, Biomes.WINDSWEPT_FOREST, SBBiomes.RAINFOREST, SBBiomes.BLACK_DUNES}, {Biomes.WINDSWEPT_FOREST, Biomes.WINDSWEPT_FOREST, Biomes.WINDSWEPT_FOREST, SBBiomes.RAINFOREST, SBBiomes.BLACK_DUNES}};
    private final ResourceKey<Biome>[][] SHATTERED_VARIANT = new ResourceKey[][]{{Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_HILLS, SBBiomes.CHAPARRAL, SBBiomes.BLACK_DUNES}, {Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_HILLS, SBBiomes.CHAPARRAL, SBBiomes.BLACK_DUNES}, {Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_HILLS, SBBiomes.CHAPARRAL, SBBiomes.BLACK_DUNES}, {Biomes.WINDSWEPT_FOREST, Biomes.WINDSWEPT_FOREST, Biomes.WINDSWEPT_FOREST, SBBiomes.EUCALYPT_WOODLAND, SBBiomes.BLACK_DUNES}, {Biomes.WINDSWEPT_FOREST, Biomes.WINDSWEPT_FOREST, Biomes.WINDSWEPT_FOREST, SBBiomes.EUCALYPT_WOODLAND, SBBiomes.BLACK_DUNES}};
    private final ResourceKey<Biome>[][] PEAKS_NORMAL = new ResourceKey[][]{{Biomes.JAGGED_PEAKS, Biomes.JAGGED_PEAKS, SBBiomes.VOLCANIC_PEAKS, SBBiomes.VOLCANIC_PEAKS, SBBiomes.BRUSHLAND}, {Biomes.JAGGED_PEAKS, Biomes.JAGGED_PEAKS, SBBiomes.VOLCANIC_PEAKS, SBBiomes.VOLCANIC_PEAKS, SBBiomes.BRUSHLAND}, {Biomes.JAGGED_PEAKS, Biomes.JAGGED_PEAKS, SBBiomes.VOLCANIC_PEAKS, SBBiomes.VOLCANIC_PEAKS, SBBiomes.BRUSHLAND}, {Biomes.JAGGED_PEAKS, Biomes.JAGGED_PEAKS, SBBiomes.VOLCANIC_PEAKS, SBBiomes.VOLCANIC_PEAKS, SBBiomes.WOODED_BRUSHLAND}, {Biomes.JAGGED_PEAKS, Biomes.JAGGED_PEAKS, SBBiomes.VOLCANIC_PEAKS, SBBiomes.VOLCANIC_PEAKS, SBBiomes.WOODED_BRUSHLAND}};
    private final ResourceKey<Biome>[][] PEAKS_VARIANT = new ResourceKey[][]{{Biomes.FROZEN_PEAKS, Biomes.FROZEN_PEAKS, SBBiomes.VOLCANIC_PEAKS, SBBiomes.VOLCANIC_PEAKS, SBBiomes.ROCKY_BRUSHLAND}, {Biomes.FROZEN_PEAKS, Biomes.FROZEN_PEAKS, SBBiomes.VOLCANIC_PEAKS, SBBiomes.VOLCANIC_PEAKS, SBBiomes.ROCKY_BRUSHLAND}, {Biomes.FROZEN_PEAKS, Biomes.FROZEN_PEAKS, SBBiomes.VOLCANIC_PEAKS, SBBiomes.VOLCANIC_PEAKS, SBBiomes.BRUSHLAND}, {Biomes.FROZEN_PEAKS, Biomes.FROZEN_PEAKS, SBBiomes.VOLCANIC_PEAKS, SBBiomes.VOLCANIC_PEAKS, SBBiomes.WOODED_BRUSHLAND}, {Biomes.FROZEN_PEAKS, Biomes.FROZEN_PEAKS, SBBiomes.VOLCANIC_PEAKS, SBBiomes.VOLCANIC_PEAKS, SBBiomes.WOODED_BRUSHLAND}};
    private final ResourceKey<Biome>[][] MIDDLE_PLATEAU_NORMAL = new ResourceKey[][]{{this.MIDDLE_NORMAL[0][0], this.MIDDLE_NORMAL[0][1], this.MIDDLE_NORMAL[0][2], this.MIDDLE_NORMAL[0][3], this.PLATEAU_NORMAL[0][4]}, {this.MIDDLE_NORMAL[1][0], this.MIDDLE_NORMAL[1][1], this.MIDDLE_NORMAL[1][2], this.MIDDLE_NORMAL[1][3], this.PLATEAU_NORMAL[1][4]}, {this.MIDDLE_NORMAL[2][0], this.MIDDLE_NORMAL[2][1], this.MIDDLE_NORMAL[2][2], this.MIDDLE_NORMAL[2][3], this.PLATEAU_NORMAL[2][4]}, {this.MIDDLE_NORMAL[3][0], this.MIDDLE_NORMAL[3][1], this.MIDDLE_NORMAL[3][2], this.MIDDLE_NORMAL[3][3], this.PLATEAU_NORMAL[3][4]}, {this.MIDDLE_NORMAL[4][0], this.MIDDLE_NORMAL[4][1], this.MIDDLE_NORMAL[4][2], this.MIDDLE_NORMAL[4][3], this.PLATEAU_NORMAL[4][4]}};
    private final ResourceKey<Biome>[][] MIDDLE_PLATEAU_VARIANT = new ResourceKey[][]{{this.MIDDLE_VARIANT[0][0], this.MIDDLE_VARIANT[0][1], this.MIDDLE_VARIANT[0][2], this.MIDDLE_VARIANT[0][3], this.PLATEAU_VARIANT[0][4]}, {this.MIDDLE_VARIANT[1][0], this.MIDDLE_VARIANT[1][1], this.MIDDLE_VARIANT[1][2], this.MIDDLE_VARIANT[1][3], this.PLATEAU_VARIANT[1][4]}, {this.MIDDLE_VARIANT[2][0], this.MIDDLE_VARIANT[2][1], this.MIDDLE_VARIANT[2][2], this.MIDDLE_VARIANT[2][3], this.PLATEAU_VARIANT[2][4]}, {this.MIDDLE_VARIANT[3][0], this.MIDDLE_VARIANT[3][1], this.MIDDLE_VARIANT[3][2], this.MIDDLE_VARIANT[3][3], this.PLATEAU_VARIANT[3][4]}, {this.MIDDLE_VARIANT[4][0], this.MIDDLE_VARIANT[4][1], this.MIDDLE_VARIANT[4][2], this.MIDDLE_VARIANT[4][3], this.PLATEAU_VARIANT[4][4]}};
    private final ResourceKey<Biome> WINDSWEPT = Biomes.WINDSWEPT_SAVANNA;
    private final ResourceKey<Biome>[][] MIDDLE_WINDSWEPT = new ResourceKey[][]{{this.MIDDLE_VARIANT[0][0], this.MIDDLE_VARIANT[0][1], this.WINDSWEPT, this.WINDSWEPT, this.WINDSWEPT}, {this.MIDDLE_VARIANT[1][0], this.MIDDLE_VARIANT[1][1], this.WINDSWEPT, this.WINDSWEPT, this.WINDSWEPT}, {this.MIDDLE_VARIANT[2][0], this.MIDDLE_VARIANT[2][1], this.WINDSWEPT, this.WINDSWEPT, this.WINDSWEPT}, {this.MIDDLE_VARIANT[3][0], this.MIDDLE_VARIANT[3][1], this.WINDSWEPT, this.WINDSWEPT, this.WINDSWEPT}, {this.MIDDLE_VARIANT[4][0], this.MIDDLE_VARIANT[4][1], this.MIDDLE_VARIANT[4][2], this.MIDDLE_VARIANT[4][3], this.MIDDLE_VARIANT[4][4]}};
    private final ResourceKey<Biome>[][] SHATTERED_WINDSWEPT = new ResourceKey[][]{{this.SHATTERED_VARIANT[0][0], this.SHATTERED_VARIANT[0][1], this.WINDSWEPT, this.WINDSWEPT, this.WINDSWEPT}, {this.SHATTERED_VARIANT[1][0], this.SHATTERED_VARIANT[1][1], this.WINDSWEPT, this.WINDSWEPT, this.WINDSWEPT}, {this.SHATTERED_VARIANT[2][0], this.SHATTERED_VARIANT[2][1], this.WINDSWEPT, this.WINDSWEPT, this.WINDSWEPT}, {this.SHATTERED_VARIANT[3][0], this.SHATTERED_VARIANT[3][1], this.WINDSWEPT, this.WINDSWEPT, this.WINDSWEPT}, {this.SHATTERED_VARIANT[4][0], this.SHATTERED_VARIANT[4][1], this.SHATTERED_VARIANT[4][2], this.SHATTERED_VARIANT[4][3], this.SHATTERED_VARIANT[4][4]}};
    private final ResourceKey<Biome>[][] OCEANS = new ResourceKey[][]{{Biomes.FROZEN_OCEAN, SBBiomes.MURKY_OCEAN, SBBiomes.MURKY_OCEAN, SBBiomes.MURKY_OCEAN, Biomes.WARM_OCEAN}, {Biomes.DEEP_FROZEN_OCEAN, SBBiomes.DEEP_MURKY_OCEAN, SBBiomes.DEEP_MURKY_OCEAN, SBBiomes.DEEP_MURKY_OCEAN, Biomes.WARM_OCEAN}};
    private final ResourceKey<Biome>[][] ISLANDS = new ResourceKey[][]{{SBBiomes.MUSHROOM_FOREST, SBBiomes.MUSHROOM_FOREST, SBBiomes.MUSHROOM_FOREST, SBBiomes.MUSHROOM_FOREST, SBBiomes.MUSHROOM_FOREST}, {SBBiomes.MUSHROOM_FOREST, SBBiomes.MUSHROOM_FOREST, SBBiomes.MUSHROOM_FOREST, SBBiomes.MUSHROOM_FOREST, SBBiomes.MUSHROOM_FOREST}, {SBBiomes.MUSHROOM_FOREST, SBBiomes.MUSHROOM_FOREST, SBBiomes.MUSHROOM_FOREST, SBBiomes.MUSHROOM_FOREST, SBBiomes.MUSHROOM_FOREST}, {SBBiomes.MUSHROOM_FOREST, SBBiomes.MUSHROOM_FOREST, SBBiomes.MUSHROOM_FOREST, SBBiomes.MUSHROOM_FOREST, SBBiomes.MUSHROOM_FOREST}, {SBBiomes.MUSHROOM_FOREST, SBBiomes.MUSHROOM_FOREST, SBBiomes.MUSHROOM_FOREST, SBBiomes.MUSHROOM_FOREST, SBBiomes.MUSHROOM_FOREST}};

    private ResourceKey<Biome> getMiddle(int h, int t, boolean variant) {
        return variant ? this.MIDDLE_VARIANT[h][t] : this.MIDDLE_NORMAL[h][t];
    }

    private ResourceKey<Biome> getPlateau(int h, int t, boolean variant) {
        return variant ? this.PLATEAU_VARIANT[h][t] : this.PLATEAU_NORMAL[h][t];
    }

    private ResourceKey<Biome> getShattered(int h, int t, boolean variant) {
        return variant ? this.SHATTERED_VARIANT[h][t] : this.SHATTERED_NORMAL[h][t];
    }

    private ResourceKey<Biome> getPeaks(int h, int t, boolean variant) {
        return variant ? this.PEAKS_VARIANT[h][t] : this.PEAKS_NORMAL[h][t];
    }

    private ResourceKey<Biome> getMiddlePlateau(int h, int t, boolean variant) {
        return variant ? this.MIDDLE_PLATEAU_VARIANT[h][t] : this.MIDDLE_PLATEAU_NORMAL[h][t];
    }

    private ResourceKey<Biome> getWindswept(int h, int t, boolean variant) {
        return variant ? this.MIDDLE_WINDSWEPT[h][t] : this.MIDDLE_NORMAL[h][t];
    }

    public SBOverworldRegion(int weight) {
        super(new ResourceLocation("slayersbeasts", "overworld"), RegionType.OVERWORLD, weight);
    }

    public void addBiomes(Registry<Biome> registry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        for (int t = 0; t < this.TEMPERATURE.length; ++t) {
            this.surfaceBiome(mapper, this.OCEANS[0][t], this.TEMPERATURE[t], ParameterUtils.Humidity.FULL_RANGE, ParameterUtils.Continentalness.OCEAN, ParameterUtils.Erosion.FULL_RANGE, ParameterUtils.Weirdness.FULL_RANGE);
            this.surfaceBiome(mapper, this.OCEANS[1][t], this.TEMPERATURE[t], ParameterUtils.Humidity.FULL_RANGE, ParameterUtils.Continentalness.DEEP_OCEAN, ParameterUtils.Erosion.FULL_RANGE, ParameterUtils.Weirdness.FULL_RANGE);
            for (int h = 0; h < this.HUMIDITY.length; ++h) {
                this.surfaceBiome(mapper, this.ISLANDS[h][t], this.TEMPERATURE[t], this.HUMIDITY[h], ParameterUtils.Continentalness.MUSHROOM_FIELDS, ParameterUtils.Erosion.FULL_RANGE, ParameterUtils.Weirdness.FULL_RANGE);
            }
        }
        this.addMidSlice(mapper, ParameterUtils.Weirdness.MID_SLICE_NORMAL_ASCENDING, false);
        this.addHighSlice(mapper, ParameterUtils.Weirdness.HIGH_SLICE_NORMAL_ASCENDING, false);
        this.addPeaks(mapper, ParameterUtils.Weirdness.PEAK_NORMAL, false);
        this.addHighSlice(mapper, ParameterUtils.Weirdness.HIGH_SLICE_NORMAL_DESCENDING, false);
        this.addMidSlice(mapper, ParameterUtils.Weirdness.MID_SLICE_NORMAL_DESCENDING, false);
        this.addLowSlice(mapper, ParameterUtils.Weirdness.LOW_SLICE_NORMAL_DESCENDING, false);
        this.addValleys(mapper);
        this.addLowSlice(mapper, ParameterUtils.Weirdness.LOW_SLICE_VARIANT_ASCENDING, true);
        this.addMidSlice(mapper, ParameterUtils.Weirdness.MID_SLICE_VARIANT_ASCENDING, true);
        this.addHighSlice(mapper, ParameterUtils.Weirdness.HIGH_SLICE_VARIANT_ASCENDING, true);
        this.addPeaks(mapper, ParameterUtils.Weirdness.PEAK_VARIANT, true);
        this.addHighSlice(mapper, ParameterUtils.Weirdness.HIGH_SLICE_VARIANT_DESCENDING, true);
        this.addMidSlice(mapper, ParameterUtils.Weirdness.MID_SLICE_VARIANT_DESCENDING, true);
        this.caveBiome(mapper, SBBiomes.DUSTY_CAVERNS, ParameterUtils.Temperature.FULL_RANGE, ParameterUtils.Humidity.ARID, ParameterUtils.Continentalness.INLAND);
        this.caveBiome(mapper, SBBiomes.FUNGAL_DEPTHS, ParameterUtils.Temperature.FULL_RANGE, ParameterUtils.Humidity.WET, ParameterUtils.Continentalness.FULL_RANGE);
        this.caveBiome(mapper, SBBiomes.ICE_CAVES, ParameterUtils.Temperature.ICY, ParameterUtils.Humidity.FULL_RANGE, ParameterUtils.Continentalness.INLAND);
        this.caveBiome(mapper, SBBiomes.SLIME_CAVERNS, ParameterUtils.Temperature.NEUTRAL, ParameterUtils.Humidity.NEUTRAL, ParameterUtils.Continentalness.FULL_RANGE);
    }

    private void addPeaks(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, ParameterUtils.Weirdness weirdness, boolean variant) {
        for (int t = 0; t < this.TEMPERATURE.length; ++t) {
            ParameterUtils.Temperature temperature = this.TEMPERATURE[t];
            for (int h = 0; h < this.HUMIDITY.length; ++h) {
                int c;
                ParameterUtils.Humidity humidity = this.HUMIDITY[h];
                for (c = 0; c < 2; ++c) {
                    this.surfaceBiome(mapper, this.getPeaks(h, t, variant), temperature, humidity, this.INLANDNESS[c], ParameterUtils.Erosion.EROSION_0, weirdness);
                    this.surfaceBiome(mapper, t == 0 ? this.SLOPES[h] : this.getMiddlePlateau(h, t, variant), ParameterUtils.Temperature.ICY, this.HUMIDITY[h], this.INLANDNESS[c], ParameterUtils.Erosion.EROSION_1, weirdness);
                    for (int e = 2; e < 5; ++e) {
                        this.surfaceBiome(mapper, this.getMiddle(h, t, variant), temperature, humidity, this.INLANDNESS[c], this.EROSION[e], weirdness);
                    }
                    this.surfaceBiome(mapper, variant ? this.SHATTERED_WINDSWEPT[h][t] : this.SHATTERED_NORMAL[h][t], temperature, humidity, this.INLANDNESS[c], ParameterUtils.Erosion.EROSION_5, weirdness);
                }
                for (ParameterUtils.Continentalness continentalness : this.INLANDNESS) {
                    this.surfaceBiome(mapper, this.getMiddle(h, t, variant), temperature, humidity, continentalness, ParameterUtils.Erosion.EROSION_6, weirdness);
                }
                for (c = 2; c < this.INLANDNESS.length; ++c) {
                    this.surfaceBiome(mapper, this.getPeaks(h, t, variant), temperature, humidity, this.INLANDNESS[c], ParameterUtils.Erosion.EROSION_0, weirdness);
                    this.surfaceBiome(mapper, this.getPeaks(h, t, variant), temperature, humidity, this.INLANDNESS[c], ParameterUtils.Erosion.EROSION_1, weirdness);
                    this.surfaceBiome(mapper, this.getMiddle(h, t, variant), temperature, humidity, this.INLANDNESS[c], ParameterUtils.Erosion.EROSION_4, weirdness);
                    this.surfaceBiome(mapper, this.getShattered(h, t, variant), temperature, humidity, this.INLANDNESS[c], ParameterUtils.Erosion.EROSION_5, weirdness);
                }
                this.surfaceBiome(mapper, this.getPlateau(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.MID_INLAND, ParameterUtils.Erosion.EROSION_2, weirdness);
                this.surfaceBiome(mapper, this.getMiddlePlateau(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.MID_INLAND, ParameterUtils.Erosion.EROSION_3, weirdness);
                this.surfaceBiome(mapper, this.getPlateau(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.FAR_INLAND, ParameterUtils.Erosion.EROSION_2, weirdness);
                this.surfaceBiome(mapper, this.getPlateau(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.FAR_INLAND, ParameterUtils.Erosion.EROSION_3, weirdness);
            }
        }
    }

    private void addHighSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, ParameterUtils.Weirdness weirdness, boolean variant) {
        for (int t = 0; t < this.TEMPERATURE.length; ++t) {
            ParameterUtils.Temperature temperature = this.TEMPERATURE[t];
            for (int h = 0; h < this.HUMIDITY.length; ++h) {
                int e;
                ParameterUtils.Humidity humidity = this.HUMIDITY[h];
                for (e = 0; e < 5; ++e) {
                    this.surfaceBiome(mapper, this.getMiddle(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.COAST, this.EROSION[e], weirdness);
                }
                this.surfaceBiome(mapper, this.getWindswept(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.NEAR_INLAND, ParameterUtils.Erosion.EROSION_5, weirdness);
                for (ParameterUtils.Continentalness continentalness : this.INLANDNESS) {
                    this.surfaceBiome(mapper, this.getMiddle(h, t, variant), temperature, humidity, continentalness, ParameterUtils.Erosion.EROSION_6, weirdness);
                }
                this.surfaceBiome(mapper, t < 3 ? this.SLOPES[h] : this.getPlateau(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.NEAR_INLAND, ParameterUtils.Erosion.EROSION_0, weirdness);
                this.surfaceBiome(mapper, t == 0 ? this.SLOPES[h] : this.getMiddlePlateau(h, t, variant), ParameterUtils.Temperature.ICY, this.HUMIDITY[h], ParameterUtils.Continentalness.NEAR_INLAND, ParameterUtils.Erosion.EROSION_1, weirdness);
                for (e = 2; e < 5; ++e) {
                    this.surfaceBiome(mapper, this.getMiddle(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.NEAR_INLAND, this.EROSION[e], weirdness);
                }
                this.surfaceBiome(mapper, this.getWindswept(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.NEAR_INLAND, ParameterUtils.Erosion.EROSION_5, weirdness);
                for (int c = 2; c < this.INLANDNESS.length; ++c) {
                    this.surfaceBiome(mapper, this.getPeaks(h, t, variant), temperature, humidity, this.INLANDNESS[c], ParameterUtils.Erosion.EROSION_0, weirdness);
                    this.surfaceBiome(mapper, t < 3 ? this.SLOPES[h] : this.getPlateau(h, t, variant), temperature, humidity, this.INLANDNESS[c], ParameterUtils.Erosion.EROSION_1, weirdness);
                    this.surfaceBiome(mapper, this.getMiddle(h, t, variant), temperature, humidity, this.INLANDNESS[c], ParameterUtils.Erosion.EROSION_4, weirdness);
                    this.surfaceBiome(mapper, this.getShattered(h, t, variant), temperature, humidity, this.INLANDNESS[c], ParameterUtils.Erosion.EROSION_5, weirdness);
                }
                this.surfaceBiome(mapper, this.getPlateau(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.MID_INLAND, ParameterUtils.Erosion.EROSION_2, weirdness);
                this.surfaceBiome(mapper, this.getMiddlePlateau(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.MID_INLAND, ParameterUtils.Erosion.EROSION_3, weirdness);
                this.surfaceBiome(mapper, this.getPlateau(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.FAR_INLAND, ParameterUtils.Erosion.EROSION_2, weirdness);
                this.surfaceBiome(mapper, this.getPlateau(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.FAR_INLAND, ParameterUtils.Erosion.EROSION_3, weirdness);
            }
        }
    }

    private void addMidSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, ParameterUtils.Weirdness weirdness, boolean variant) {
        for (int t = 0; t < this.TEMPERATURE.length; ++t) {
            ParameterUtils.Temperature temperature = this.TEMPERATURE[t];
            for (int h = 0; h < this.HUMIDITY.length; ++h) {
                int c;
                int e;
                ParameterUtils.Humidity humidity = this.HUMIDITY[h];
                for (e = 0; e < 3; ++e) {
                    this.surfaceBiome(mapper, (ResourceKey<Biome>)Biomes.STONY_SHORE, temperature, humidity, ParameterUtils.Continentalness.COAST, this.EROSION[e], weirdness);
                }
                this.surfaceBiome(mapper, this.getMiddle(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.COAST, ParameterUtils.Erosion.EROSION_3, weirdness);
                if (variant) {
                    this.surfaceBiome(mapper, this.MIDDLE_VARIANT[h][t], temperature, humidity, ParameterUtils.Continentalness.COAST, ParameterUtils.Erosion.EROSION_4, weirdness);
                    this.surfaceBiome(mapper, this.MIDDLE_WINDSWEPT[h][t], temperature, humidity, ParameterUtils.Continentalness.COAST, ParameterUtils.Erosion.EROSION_5, weirdness);
                    this.surfaceBiome(mapper, this.MIDDLE_VARIANT[h][t], temperature, humidity, ParameterUtils.Continentalness.COAST, ParameterUtils.Erosion.EROSION_6, weirdness);
                } else {
                    for (e = 4; e < this.EROSION.length; ++e) {
                        this.surfaceBiome(mapper, this.BEACHES[t], temperature, humidity, ParameterUtils.Continentalness.COAST, this.EROSION[e], weirdness);
                    }
                }
                for (c = 1; c < this.INLANDNESS.length; ++c) {
                    this.surfaceBiome(mapper, t < 3 ? this.SLOPES[h] : this.getPlateau(h, t, variant), temperature, humidity, this.INLANDNESS[c], ParameterUtils.Erosion.EROSION_0, weirdness);
                    if (t != 0) continue;
                    this.surfaceBiome(mapper, this.SLOPES[h], ParameterUtils.Temperature.ICY, this.HUMIDITY[h], this.INLANDNESS[c], ParameterUtils.Erosion.EROSION_1, weirdness);
                }
                if (t > 0) {
                    this.surfaceBiome(mapper, this.getMiddlePlateau(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.NEAR_INLAND, ParameterUtils.Erosion.EROSION_1, weirdness);
                    this.surfaceBiome(mapper, this.getMiddlePlateau(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.MID_INLAND, ParameterUtils.Erosion.EROSION_1, weirdness);
                    this.surfaceBiome(mapper, this.getPlateau(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.FAR_INLAND, ParameterUtils.Erosion.EROSION_1, weirdness);
                }
                for (e = 2; e < 5; ++e) {
                    this.surfaceBiome(mapper, this.getMiddle(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.NEAR_INLAND, this.EROSION[e], weirdness);
                }
                this.surfaceBiome(mapper, this.getWindswept(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.NEAR_INLAND, ParameterUtils.Erosion.EROSION_5, weirdness);
                for (c = 1; c < this.INLANDNESS.length; ++c) {
                    this.surfaceBiome(mapper, this.SWAMPS[t], temperature, humidity, this.INLANDNESS[c], ParameterUtils.Erosion.EROSION_6, weirdness);
                }
                this.surfaceBiome(mapper, this.getMiddlePlateau(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.MID_INLAND, ParameterUtils.Erosion.EROSION_2, weirdness);
                this.surfaceBiome(mapper, this.getMiddlePlateau(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.MID_INLAND, ParameterUtils.Erosion.EROSION_3, weirdness);
                this.surfaceBiome(mapper, this.getMiddle(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.MID_INLAND, ParameterUtils.Erosion.EROSION_4, weirdness);
                this.surfaceBiome(mapper, this.getShattered(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.MID_INLAND, ParameterUtils.Erosion.EROSION_5, weirdness);
                this.surfaceBiome(mapper, this.getPlateau(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.FAR_INLAND, ParameterUtils.Erosion.EROSION_2, weirdness);
                this.surfaceBiome(mapper, this.getMiddlePlateau(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.MID_INLAND, ParameterUtils.Erosion.EROSION_3, weirdness);
                this.surfaceBiome(mapper, this.getMiddle(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.FAR_INLAND, ParameterUtils.Erosion.EROSION_4, weirdness);
                this.surfaceBiome(mapper, this.getShattered(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.FAR_INLAND, ParameterUtils.Erosion.EROSION_5, weirdness);
            }
        }
    }

    private void addLowSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, ParameterUtils.Weirdness weirdness, boolean variant) {
        for (int t = 0; t < this.TEMPERATURE.length; ++t) {
            ParameterUtils.Temperature temperature = this.TEMPERATURE[t];
            for (int h = 0; h < this.HUMIDITY.length; ++h) {
                int e;
                ParameterUtils.Humidity humidity = this.HUMIDITY[h];
                for (e = 0; e < 3; ++e) {
                    this.surfaceBiome(mapper, (ResourceKey<Biome>)Biomes.STONY_SHORE, temperature, humidity, ParameterUtils.Continentalness.COAST, this.EROSION[e], weirdness);
                }
                for (e = 3; e < 5; ++e) {
                    this.surfaceBiome(mapper, this.BEACHES[t], temperature, humidity, ParameterUtils.Continentalness.COAST, this.EROSION[e], weirdness);
                }
                this.surfaceBiome(mapper, variant ? this.MIDDLE_WINDSWEPT[h][t] : this.BEACHES[t], temperature, humidity, ParameterUtils.Continentalness.COAST, ParameterUtils.Erosion.EROSION_5, weirdness);
                this.surfaceBiome(mapper, this.BEACHES[t], temperature, humidity, ParameterUtils.Continentalness.COAST, ParameterUtils.Erosion.EROSION_6, weirdness);
                this.surfaceBiome(mapper, this.getWindswept(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.NEAR_INLAND, ParameterUtils.Erosion.EROSION_5, weirdness);
                for (e = 0; e < 2; ++e) {
                    this.surfaceBiome(mapper, this.getMiddlePlateau(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.NEAR_INLAND, this.EROSION[e], weirdness);
                }
                for (e = 2; e < 5; ++e) {
                    this.surfaceBiome(mapper, this.getMiddle(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.NEAR_INLAND, this.EROSION[e], weirdness);
                }
                for (int c = 1; c < this.INLANDNESS.length; ++c) {
                    this.surfaceBiome(mapper, this.SWAMPS[t], temperature, humidity, this.INLANDNESS[c], ParameterUtils.Erosion.EROSION_6, weirdness);
                }
                for (e = 0; e < 4; ++e) {
                    this.surfaceBiome(mapper, this.getMiddlePlateau(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.MID_INLAND, this.EROSION[e], weirdness);
                    this.surfaceBiome(mapper, this.getMiddlePlateau(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.FAR_INLAND, this.EROSION[e], weirdness);
                }
                for (e = 4; e < 6; ++e) {
                    this.surfaceBiome(mapper, this.getMiddle(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.MID_INLAND, this.EROSION[e], weirdness);
                    this.surfaceBiome(mapper, this.getMiddle(h, t, variant), temperature, humidity, ParameterUtils.Continentalness.FAR_INLAND, this.EROSION[e], weirdness);
                }
            }
        }
    }

    private void addValleys(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        for (int t = 0; t < this.TEMPERATURE.length; ++t) {
            ParameterUtils.Temperature temperature = this.TEMPERATURE[t];
            for (int h = 0; h < this.HUMIDITY.length; ++h) {
                int e;
                ParameterUtils.Humidity humidity = this.HUMIDITY[h];
                for (ParameterUtils.Erosion erosion : this.EROSION) {
                    this.surfaceBiome(mapper, this.RIVERS[t], temperature, humidity, ParameterUtils.Continentalness.COAST, erosion, ParameterUtils.Weirdness.VALLEY);
                }
                for (e = 0; e < 6; ++e) {
                    this.surfaceBiome(mapper, this.RIVERS[t], temperature, humidity, ParameterUtils.Continentalness.NEAR_INLAND, this.EROSION[e], ParameterUtils.Weirdness.VALLEY);
                }
                for (int c = 1; c < this.INLANDNESS.length; ++c) {
                    this.surfaceBiome(mapper, this.SWAMPS[t], temperature, humidity, this.INLANDNESS[c], ParameterUtils.Erosion.EROSION_6, ParameterUtils.Weirdness.VALLEY);
                }
                for (e = 2; e < 6; ++e) {
                    this.surfaceBiome(mapper, this.RIVERS[t], temperature, humidity, ParameterUtils.Continentalness.MID_INLAND, this.EROSION[e], ParameterUtils.Weirdness.VALLEY);
                    this.surfaceBiome(mapper, this.RIVERS[t], temperature, humidity, ParameterUtils.Continentalness.FAR_INLAND, this.EROSION[e], ParameterUtils.Weirdness.VALLEY);
                }
                for (e = 0; e < 2; ++e) {
                    this.surfaceBiome(mapper, this.MIDDLE_PLATEAU_NORMAL[h][t], temperature, humidity, ParameterUtils.Continentalness.MID_INLAND, this.EROSION[e], ParameterUtils.Weirdness.VALLEY);
                    this.surfaceBiome(mapper, this.MIDDLE_PLATEAU_NORMAL[h][t], temperature, humidity, ParameterUtils.Continentalness.FAR_INLAND, this.EROSION[e], ParameterUtils.Weirdness.VALLEY);
                }
            }
        }
    }

    private void surfaceBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, ResourceKey<Biome> biome, ParameterUtils.Temperature temperature, ParameterUtils.Humidity humidity, ParameterUtils.Continentalness continentalness, ParameterUtils.Erosion erosion, ParameterUtils.Weirdness weirdness) {
        mapper.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)temperature.parameter(), (Climate.Parameter)humidity.parameter(), (Climate.Parameter)continentalness.parameter(), (Climate.Parameter)erosion.parameter(), (Climate.Parameter)ParameterUtils.Depth.FLOOR.parameter(), (Climate.Parameter)weirdness.parameter(), (float)0.0f), biome));
        mapper.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)temperature.parameter(), (Climate.Parameter)humidity.parameter(), (Climate.Parameter)continentalness.parameter(), (Climate.Parameter)erosion.parameter(), (Climate.Parameter)ParameterUtils.Depth.SURFACE.parameter(), (Climate.Parameter)weirdness.parameter(), (float)0.0f), biome));
    }

    private void caveBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, ResourceKey<Biome> biome, ParameterUtils.Temperature temperature, ParameterUtils.Humidity humidity, ParameterUtils.Continentalness continentalness) {
        mapper.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)temperature.parameter(), (Climate.Parameter)humidity.parameter(), (Climate.Parameter)continentalness.parameter(), (Climate.Parameter)ParameterUtils.Erosion.FULL_RANGE.parameter(), (Climate.Parameter)ParameterUtils.Depth.UNDERGROUND.parameter(), (Climate.Parameter)ParameterUtils.Weirdness.FULL_RANGE.parameter(), (float)0.0f), biome));
    }
}

