/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.invictusslayer.slayersbeasts.registries.SBFeatures;
import net.invictusslayer.slayersbeasts.world.level.dimension.SBDimensions;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.SBStructures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CryptPortalBlock
extends Block {
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);

    public CryptPortalBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        List<BlockPos> posList = List.of(currentPos.north(), currentPos.east(), currentPos.south(), currentPos.west());
        for (BlockPos pos : posList) {
            Block block = level.getBlockState(pos).getBlock();
            if (block == this || block == SBBlocks.INFUSED_CRYPTALITH.get() || block == SBBlocks.DEPLETED_CRYPTALITH.get()) continue;
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public ItemStack getCloneItemStack(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return ItemStack.EMPTY;
    }

    public boolean canBeReplaced(BlockState state, Fluid fluid) {
        return false;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        ServerPlayer player;
        if (entity instanceof ServerPlayer && (player = (ServerPlayer)entity).canChangeDimensions()) {
            MinecraftServer server = level.getServer();
            if (server == null) {
                return;
            }
            ResourceKey<Level> destination = player.level().dimension() == SBDimensions.CRYPT ? Level.OVERWORLD : SBDimensions.CRYPT;
            ServerLevel serverLevel = server.getLevel(destination);
            if (serverLevel == null) {
                return;
            }
            if (destination == SBDimensions.CRYPT) {
                if (serverLevel.players().isEmpty()) {
                    this.resetCrypt(serverLevel);
                }
                player.teleportTo(serverLevel, 3.5, 61.0, 3.0, Set.of(), player.getYRot(), player.getXRot());
            } else {
                BlockPos spawn;
                BlockPos blockPos = spawn = player.getRespawnDimension() == destination ? player.getRespawnPosition() : level.getSharedSpawnPos();
                if (spawn == null) {
                    spawn = level.getSharedSpawnPos();
                }
                player.teleportTo(serverLevel, (double)spawn.getX(), (double)spawn.getY(), (double)spawn.getZ(), Set.of(), player.getYRot(), player.getXRot());
            }
        }
    }

    private void resetCrypt(ServerLevel level) {
        ChunkGenerator chunkGen = level.getChunkSource().getGenerator();
        if (!SBFeatures.CRYPT_FOUNDATION.get().place((FeatureConfiguration)new NoneFeatureConfiguration(), (WorldGenLevel)level, chunkGen, level.getRandom(), BlockPos.ZERO)) {
            return;
        }
        Structure crypt = (Structure)((Holder.Reference)level.registryAccess().registryOrThrow(Registries.STRUCTURE).getHolder(SBStructures.CRYPT).orElseThrow()).value();
        StructureStart start = crypt.generate(level.registryAccess(), chunkGen, chunkGen.getBiomeSource(), level.getChunkSource().randomState(), level.getStructureManager(), (long)level.getRandom().nextInt(1000000000), new ChunkPos(0, 0), 0, (LevelHeightAccessor)level, biome -> true);
        if (!start.isValid()) {
            return;
        }
        BoundingBox boundingBox = start.getBoundingBox();
        ChunkPos chunkMin = new ChunkPos(SectionPos.blockToSectionCoord((int)boundingBox.minX()), SectionPos.blockToSectionCoord((int)boundingBox.minZ()));
        ChunkPos chunkMax = new ChunkPos(SectionPos.blockToSectionCoord((int)boundingBox.maxX()), SectionPos.blockToSectionCoord((int)boundingBox.maxZ()));
        ChunkPos.rangeClosed((ChunkPos)chunkMin, (ChunkPos)chunkMax).forEach(chunk -> start.placeInChunk((WorldGenLevel)level, level.structureManager(), chunkGen, level.getRandom(), new BoundingBox(chunk.getMinBlockX(), level.getMinBuildHeight(), chunk.getMinBlockZ(), chunk.getMaxBlockX(), level.getMaxBuildHeight(), chunk.getMaxBlockZ()), chunkMin));
        ArrayList entities = new ArrayList();
        level.getAllEntities().forEach(entity -> {
            if (entity instanceof ItemEntity) {
                entities.add(entity);
            }
        });
        for (Entity entity2 : entities) {
            entity2.kill();
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        double d0 = (double)pos.getX() + random.nextDouble();
        double d1 = (double)pos.getY() + 0.8;
        double d2 = (double)pos.getZ() + random.nextDouble();
        level.addParticle((ParticleOptions)ParticleTypes.WHITE_ASH, d0, d1, d2, 0.0, 0.0, 0.0);
    }
}

