/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.block;

import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WillowBranchBlock
extends GrowingPlantHeadBlock {
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public WillowBranchBlock(BlockBehaviour.Properties properties) {
        super(properties, Direction.DOWN, SHAPE, false, 0.1);
    }

    public BlockState getStateForPlacement(LevelAccessor level) {
        return (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(level.getRandom().nextInt(10)));
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource random) {
        return 1;
    }

    protected boolean canGrowInto(BlockState state) {
        return state.isAir();
    }

    protected Block getBodyBlock() {
        return SBBlocks.WILLOW_BRANCH_PLANT.get();
    }

    public BlockState getMaxAgeState(BlockState state) {
        return (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(10));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.getValue((Property)AGE) == 10;
    }
}

