/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.block.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.invictusslayer.slayersbeasts.data.tags.SBTags;
import net.invictusslayer.slayersbeasts.registries.SBBlockEntities;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.invictusslayer.slayersbeasts.world.entity.AbstractAnt;
import net.invictusslayer.slayersbeasts.world.entity.AntQueen;
import net.invictusslayer.slayersbeasts.world.entity.AntSoldier;
import net.invictusslayer.slayersbeasts.world.level.block.AnthillBlock;
import net.invictusslayer.slayersbeasts.world.level.block.entity.AnthillHatcheryBlockEntity;
import net.invictusslayer.slayersbeasts.world.level.block.entity.BaseAnthillBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class AnthillBlockEntity
extends BlockEntity {
    private static final List<String> IGNORED_ANT_TAGS = Arrays.asList("Air", "ArmorDropChances", "ArmorItems", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "OnGround", "PortalCooldown", "Pos", "Rotation", "CooldownToEnterNest", "CooldownToLocateNest", "FailedForagingTime", "NestPos", "Passengers", "Leash", "UUID");
    private final List<AntData> storedAnts = new ArrayList<AntData>();
    private final Map<BlockPos, UpgradeData> nestUpgrades = new HashMap<BlockPos, UpgradeData>();
    private AbstractAnt.Variant inhabitantVariant = null;
    private boolean hasQueen;

    public AnthillBlockEntity(BlockPos pos, BlockState state) {
        super(SBBlockEntities.ANTHILL.get(), pos, state);
    }

    protected void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("Ants", (Tag)this.writeAnts());
        tag.put("Upgrades", (Tag)this.writeUpgrades());
        if (this.getInhabitantVariant() != null) {
            tag.putInt("InhabitantType", this.getInhabitantVariant().getId());
        }
        tag.putBoolean("HasQueen", this.hasQueen);
    }

    public ListTag writeAnts() {
        ListTag tags = new ListTag();
        for (AntData data : this.storedAnts) {
            CompoundTag dataTag = data.entityData.copy();
            dataTag.remove("UUID");
            CompoundTag tag = new CompoundTag();
            tag.put("EntityData", (Tag)dataTag);
            tag.putInt("TicksInNest", data.ticksInNest);
            tag.putInt("MinOccupationTicks", data.minOccupationTicks);
            tag.putBoolean("IsQueen", data.isQueen);
            tags.add((Object)tag);
        }
        return tags;
    }

    public ListTag writeUpgrades() {
        ListTag listTag = new ListTag();
        for (UpgradeData data : this.nestUpgrades.values()) {
            CompoundTag tag = new CompoundTag();
            tag.putInt("UpgradeType", data.upgradeType);
            tag.put("BlockPos", (Tag)NbtUtils.writeBlockPos((BlockPos)data.pos));
            listTag.add((Object)tag);
        }
        return listTag;
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.storedAnts.clear();
        this.nestUpgrades.clear();
        ListTag antList = tag.getList("Ants", 10);
        ListTag upgradeList = tag.getList("Upgrades", 10);
        for (int i = 0; i < antList.size(); ++i) {
            CompoundTag antTag = antList.getCompound(i);
            AntData data = new AntData(antTag.getCompound("EntityData"), antTag.getInt("TicksInNest"), antTag.getInt("MinOccupationTicks"), antTag.getBoolean("IsQueen"));
            this.storedAnts.add(data);
        }
        for (int j = 0; j < upgradeList.size(); ++j) {
            CompoundTag tag1 = upgradeList.getCompound(j);
            BlockPos pos = NbtUtils.readBlockPos((CompoundTag)tag1.getCompound("BlockPos"));
            UpgradeData data = new UpgradeData(tag1.getInt("UpgradeType"), pos);
            this.nestUpgrades.put(pos, data);
        }
        this.setInhabitantVariant(tag.contains("InhabitantType") ? AbstractAnt.Variant.byId(tag.getInt("InhabitantType")) : null);
        this.hasQueen = tag.getBoolean("HasQueen");
    }

    public static int getFungusLevel(BlockState state) {
        return (Integer)state.getValue((Property)AnthillBlock.FUNGUS_LEVEL);
    }

    public static int getSupplyLevel(BlockState state) {
        return (Integer)state.getValue((Property)AnthillBlock.SUPPLY_LEVEL);
    }

    public boolean isEmpty() {
        return this.storedAnts.isEmpty();
    }

    public boolean isFull() {
        return this.storedAnts.size() == 10;
    }

    public AbstractAnt.Variant getInhabitantVariant() {
        return this.inhabitantVariant;
    }

    public void setInhabitantVariant(AbstractAnt.Variant variant) {
        this.inhabitantVariant = variant;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState blockState, AnthillBlockEntity entity) {
        AnthillBlockEntity.tickOccupants(level, pos, blockState, entity.storedAnts);
        AnthillBlockEntity.tickExpansionsAndUpgrades(level, pos, blockState, entity);
    }

    private static void tickOccupants(Level level, BlockPos pos, BlockState blockState, List<AntData> dataList) {
        boolean flag = false;
        Iterator<AntData> iterator = dataList.iterator();
        while (iterator.hasNext()) {
            AntData antData = iterator.next();
            if (!antData.isQueen && antData.ticksInNest > antData.minOccupationTicks) {
                AntReleaseStatus releaseStatus;
                AntReleaseStatus antReleaseStatus = releaseStatus = antData.entityData.getBoolean("HasCargo") ? AntReleaseStatus.CARGO_DELIVERED : AntReleaseStatus.ANT_RELEASED;
                if (AnthillBlockEntity.releaseOccupant(level, pos, blockState, antData, null, releaseStatus)) {
                    flag = true;
                    iterator.remove();
                }
            }
            ++antData.ticksInNest;
        }
        if (flag) {
            AnthillBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)blockState);
        }
    }

    private static void tickExpansionsAndUpgrades(Level level, BlockPos pos, BlockState blockState, AnthillBlockEntity blockEntity) {
        if (level.getGameTime() % 200L == 0L) {
            int blockType = 1;
            List<BlockPos> list = blockEntity.scanNest(level, pos, null, SBTags.Blocks.ANTHILLS);
            Set<BlockPos> set = blockEntity.nestUpgrades.keySet();
            for (BlockPos pos1 : list) {
                set.remove(pos1);
            }
            for (BlockPos pos1 : set) {
                blockEntity.nestUpgrades.remove(pos1);
            }
            if (!set.isEmpty()) {
                blockEntity.emptyAntsFromNest(null, blockState, AntReleaseStatus.PATROLLING);
            }
            for (UpgradeData data : blockEntity.nestUpgrades.values()) {
                BlockEntity blockEntity1 = level.getBlockEntity(data.pos);
                if (data.upgradeType != 1 || !(blockEntity1 instanceof AnthillHatcheryBlockEntity)) continue;
                AnthillHatcheryBlockEntity hatchery = (AnthillHatcheryBlockEntity)blockEntity1;
                if (!blockEntity.hasQueen) continue;
                hatchery.storeEgg(level, data.pos);
            }
            int i = AnthillBlockEntity.getSupplyLevel(blockState);
            if (i >= 5) {
                blockEntity.upgradeNest(level, pos, blockState, blockType);
            } else if (i >= 3) {
                blockEntity.expandNest(level, pos, blockState);
            }
        }
    }

    private void upgradeNest(Level level, BlockPos nestPos, BlockState blockState, int upgradeType) {
        List<BlockPos> posList = this.scanNest(level, nestPos, SBBlocks.ARIDISOL.get(), null);
        if (posList.isEmpty() || this.nestUpgrades.size() > 5) {
            return;
        }
        BlockPos blockPos = posList.get(level.random.nextInt(posList.size()));
        Block block = upgradeType == 1 ? SBBlocks.ANTHILL_HATCHERY.get() : SBBlocks.ARIDISOL.get();
        this.nestUpgrades.put(blockPos, new UpgradeData(upgradeType, blockPos));
        level.setBlock(nestPos, (BlockState)blockState.setValue((Property)AnthillBlock.SUPPLY_LEVEL, (Comparable)Integer.valueOf(AnthillBlockEntity.getSupplyLevel(blockState) - 5)), 3);
        level.setBlockAndUpdate(blockPos, block.defaultBlockState());
        AnthillBlockEntity.setChanged((Level)level, (BlockPos)nestPos, (BlockState)blockState);
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof BaseAnthillBlockEntity) {
            BaseAnthillBlockEntity blockEntity2 = (BaseAnthillBlockEntity)blockEntity;
            blockEntity2.setParentNestPos(nestPos);
        }
    }

    private void expandNest(Level level, BlockPos nestPos, BlockState blockState) {
        List<BlockPos> posList = this.scanNest(level, nestPos, null, SBTags.Blocks.ANTHILL_REPLACEABLE);
        if (posList.isEmpty()) {
            return;
        }
        BlockPos blockPos = posList.get(level.random.nextInt(posList.size()));
        level.setBlockAndUpdate(blockPos, SBBlocks.ARIDISOL.get().defaultBlockState());
        level.setBlock(nestPos, (BlockState)blockState.setValue((Property)AnthillBlock.SUPPLY_LEVEL, (Comparable)Integer.valueOf(AnthillBlockEntity.getSupplyLevel(blockState) - 3)), 3);
        AnthillBlockEntity.setChanged((Level)level, (BlockPos)nestPos, (BlockState)blockState);
    }

    private List<BlockPos> scanNest(Level level, BlockPos nestPos, Block block, TagKey<Block> blocks) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (int y = 0; y > -4; --y) {
            int radius = y + 5;
            if (nestPos.getY() + y < level.getMinBuildHeight()) break;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos tempBlockPos = this.getBlockPos().offset(x, y, z);
                    if (x * x + z * z > radius * radius || nestPos.equals((Object)tempBlockPos) || !level.getBlockState(tempBlockPos).is(block) && !level.getBlockState(tempBlockPos).is(blocks)) continue;
                    posList.add(tempBlockPos);
                }
            }
        }
        return posList;
    }

    public void emptyAntsFromNest(Player player, BlockState blockState, AntReleaseStatus releaseStatus) {
        List<Entity> entities = this.releaseAllOccupants(blockState, releaseStatus);
        if (player != null) {
            for (Entity entity : entities) {
                if (!(entity instanceof AbstractAnt)) continue;
                AbstractAnt ant = (AbstractAnt)entity;
                ant.setCooldownToEnterNest(400);
            }
        }
        if (this.isEmpty()) {
            this.setInhabitantVariant(null);
        }
    }

    private List<Entity> releaseAllOccupants(BlockState state, AntReleaseStatus releaseStatus) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        if (this.level != null) {
            this.storedAnts.removeIf(data -> AnthillBlockEntity.releaseOccupant(this.level, this.worldPosition, state, data, list, releaseStatus));
        }
        if (!list.isEmpty()) {
            super.setChanged();
        }
        return list;
    }

    private static boolean releaseOccupant(Level level, BlockPos pos, BlockState state, AntData data, List<Entity> storedInNest, AntReleaseStatus releaseStatus) {
        if (level.isRaining() && releaseStatus != AntReleaseStatus.EMERGENCY) {
            return false;
        }
        BlockPos above = pos.above();
        boolean flag = level.getBlockState(above).getCollisionShape((BlockGetter)level, above).isEmpty();
        if (!flag && releaseStatus != AntReleaseStatus.EMERGENCY) {
            return false;
        }
        CompoundTag compoundTag = data.entityData.copy();
        AnthillBlockEntity.removeIgnoredAntTags(compoundTag);
        compoundTag.put("NestPos", (Tag)NbtUtils.writeBlockPos((BlockPos)pos));
        Entity entity = EntityType.loadEntityRecursive((CompoundTag)compoundTag, (Level)level, entity1 -> entity1);
        if (entity == null) {
            return false;
        }
        if (!entity.getType().is(SBTags.EntityTypes.ANTHILL_INHABITANTS)) {
            return false;
        }
        if (releaseStatus == AntReleaseStatus.PATROLLING && !(entity instanceof AntSoldier)) {
            return false;
        }
        if (entity instanceof AbstractAnt) {
            AbstractAnt ant = (AbstractAnt)entity;
            if (releaseStatus == AntReleaseStatus.CARGO_DELIVERED) {
                int i;
                int cargo = ant.getCargoType();
                ant.setCargoType(99);
                if (cargo == 1) {
                    int i2;
                    if (state.is(SBTags.Blocks.ANTHILLS, stateBase -> stateBase.hasProperty((Property)AnthillBlock.FUNGUS_LEVEL)) && (i2 = AnthillBlockEntity.getFungusLevel(state)) < 8) {
                        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AnthillBlock.FUNGUS_LEVEL, (Comparable)Integer.valueOf(i2 + 1)));
                    }
                } else if (cargo == 2 && state.is(SBTags.Blocks.ANTHILLS, stateBase -> stateBase.hasProperty((Property)AnthillBlock.SUPPLY_LEVEL)) && (i = AnthillBlockEntity.getSupplyLevel(state)) < 15) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AnthillBlock.SUPPLY_LEVEL, (Comparable)Integer.valueOf(i + 1)));
                }
            }
            if (storedInNest != null) {
                storedInNest.add((Entity)ant);
            }
            double width = flag ? 0.0 : 0.55 + (double)ant.getBbWidth() * 0.5;
            ant.moveTo((double)pos.getX() + 0.5 + width, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5 + width, ant.getYRot(), ant.getXRot());
        }
        level.gameEvent(GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)level.getBlockState(pos)));
        return level.addFreshEntity(entity);
    }

    public void addOccupant(Entity entity, AbstractAnt.Variant variant, boolean hasCargo) {
        this.setInhabitantVariant(variant);
        this.addOccupantWithPresetTicks(entity, hasCargo, 0);
    }

    public void addOccupantWithPresetTicks(Entity entity, boolean hasCargo, int timeInNest) {
        if (this.storedAnts.size() >= 10) {
            return;
        }
        entity.stopRiding();
        entity.ejectPassengers();
        CompoundTag tag = new CompoundTag();
        entity.save(tag);
        this.storeAnt(tag, timeInNest, hasCargo, entity);
        if (this.level != null) {
            this.level.gameEvent(GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.Context.of((Entity)entity, (BlockState)this.getBlockState()));
        }
        entity.discard();
        super.setChanged();
    }

    public void storeAnt(CompoundTag data, int ticksInNest, boolean hasCargo, Entity entity) {
        boolean isQueen = entity instanceof AntQueen;
        this.storedAnts.add(new AntData(data, ticksInNest, hasCargo ? 2400 : 600, isQueen));
    }

    static void removeIgnoredAntTags(CompoundTag tag) {
        for (String s : IGNORED_ANT_TAGS) {
            tag.remove(s);
        }
    }

    static class AntData {
        final CompoundTag entityData;
        int ticksInNest;
        final int minOccupationTicks;
        final boolean isQueen;

        AntData(CompoundTag entityData, int ticksInNest, int minOccupationTicks, boolean isQueen) {
            AnthillBlockEntity.removeIgnoredAntTags(entityData);
            this.entityData = entityData;
            this.ticksInNest = ticksInNest;
            this.minOccupationTicks = minOccupationTicks;
            this.isQueen = isQueen;
        }
    }

    record UpgradeData(int upgradeType, BlockPos pos) {
    }

    public static enum AntReleaseStatus {
        CARGO_DELIVERED,
        ANT_RELEASED,
        PATROLLING,
        EMERGENCY;

    }
}

