/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.feature.icicle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.invictusslayer.slayersbeasts.world.level.gen.feature.icicle.IcicleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class IcicleSmallFeature
extends Feature<Configuration> {
    public IcicleSmallFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Configuration> context) {
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        Configuration config = (Configuration)context.config();
        Optional<Direction> optional = IcicleSmallFeature.getTipDirection((LevelAccessor)level, origin, random);
        if (optional.isEmpty()) {
            return false;
        }
        BlockPos blockPos = origin.relative(optional.get().getOpposite());
        IcicleSmallFeature.createPatchOfIcicleBlocks((LevelAccessor)level, random, blockPos, config);
        int i = random.nextFloat() < config.tallerIcicleChance && IcicleUtils.isEmptyOrWater(level.getBlockState(origin.relative(optional.get()))) ? 2 : 1;
        IcicleUtils.growIcicle((LevelAccessor)level, origin, optional.get(), i, false);
        return true;
    }

    private static Optional<Direction> getTipDirection(LevelAccessor level, BlockPos pos, RandomSource random) {
        boolean isDown = IcicleUtils.isIcicleBase(level.getBlockState(pos.above()));
        boolean isUp = IcicleUtils.isIcicleBase(level.getBlockState(pos.below()));
        if (isDown && isUp) {
            return Optional.of(random.nextBoolean() ? Direction.DOWN : Direction.UP);
        }
        if (isDown) {
            return Optional.of(Direction.DOWN);
        }
        if (isUp) {
            return Optional.of(Direction.UP);
        }
        return Optional.empty();
    }

    private static void createPatchOfIcicleBlocks(LevelAccessor level, RandomSource random, BlockPos pos, Configuration config) {
        IcicleUtils.placeIceIfPossible(level, pos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!(random.nextFloat() < config.radialSpreadChance)) continue;
            BlockPos blockPos = pos.relative(direction);
            IcicleUtils.placeIceIfPossible(level, blockPos);
            if (!(random.nextFloat() < config.radialSpreadChance2)) continue;
            BlockPos blockPos1 = blockPos.relative(Direction.getRandom((RandomSource)random));
            IcicleUtils.placeIceIfPossible(level, blockPos1);
            if (!(random.nextFloat() < config.radialSpreadChance3)) continue;
            BlockPos blockPos2 = blockPos1.relative(Direction.getRandom((RandomSource)random));
            IcicleUtils.placeIceIfPossible(level, blockPos2);
        }
    }

    public record Configuration(float tallerIcicleChance, float radialSpreadChance, float radialSpreadChance2, float radialSpreadChance3) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("taller_icicle_chance").forGetter(Configuration::tallerIcicleChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("radial_spread_chance").forGetter(Configuration::radialSpreadChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("radial_spread_chance2").forGetter(Configuration::radialSpreadChance2), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("radial_spread_chance3").forGetter(Configuration::radialSpreadChance3)).apply((Applicative)instance, Configuration::new));
    }
}

