/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.feature.tree.decorator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import net.invictusslayer.slayersbeasts.registries.SBTreeDecorators;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class ButtressRootDecorator
extends TreeDecorator {
    public static final Codec<ButtressRootDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("log_provider").forGetter(decorator -> decorator.logProvider), (App)BlockStateProvider.CODEC.fieldOf("dirt_provider").forGetter(decorator -> decorator.dirtProvider)).apply((Applicative)instance, ButtressRootDecorator::new));
    private final BlockStateProvider logProvider;
    private final BlockStateProvider dirtProvider;

    public ButtressRootDecorator(BlockStateProvider logProvider, BlockStateProvider dirtProvider) {
        this.logProvider = logProvider;
        this.dirtProvider = dirtProvider;
    }

    protected TreeDecoratorType<?> type() {
        return SBTreeDecorators.BUTTRESS_ROOT.get();
    }

    public void place(TreeDecorator.Context pContext) {
        ObjectArrayList list = pContext.logs();
        BlockPos basePos = (BlockPos)list.get(0);
        for (BlockPos pPos : list.stream().toList()) {
            if (basePos.getX() > pPos.getX()) {
                basePos = new BlockPos(pPos.getX(), basePos.getY(), basePos.getZ());
            }
            if (basePos.getY() > pPos.getY()) {
                basePos = new BlockPos(basePos.getX(), pPos.getY(), basePos.getZ());
            }
            if (basePos.getZ() <= pPos.getZ()) continue;
            basePos = new BlockPos(basePos.getX(), basePos.getY(), pPos.getZ());
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        this.placeRoot(pContext, pContext.random(), mutablePos, basePos, Direction.NORTH);
        this.placeRoot(pContext, pContext.random(), mutablePos, basePos, Direction.SOUTH);
        this.placeRoot(pContext, pContext.random(), mutablePos, basePos, Direction.WEST);
        this.placeRoot(pContext, pContext.random(), mutablePos, basePos, Direction.EAST);
    }

    private void placeRoot(TreeDecorator.Context pContext, RandomSource pRandom, BlockPos.MutableBlockPos pMutablePos, BlockPos pBasePos, Direction pDirection) {
        block12: {
            ArrayList<BlockPos> posList;
            block14: {
                block13: {
                    block11: {
                        posList = new ArrayList<BlockPos>();
                        posList.add(new BlockPos(-1, 0, -1));
                        posList.add(new BlockPos(-1, 1, -1));
                        posList.add(new BlockPos(-2, 0, -2));
                        int x = pRandom.nextBoolean() ? 0 : 1;
                        for (int z = -1; z >= -5; --z) {
                            int h;
                            if (z == -1) {
                                h = 4;
                            } else if (z > -4) {
                                h = z + 4;
                                if (pRandom.nextBoolean()) {
                                    posList.add(new BlockPos(pRandom.nextBoolean() ? x + 1 : x - 1, 0, z));
                                }
                            } else {
                                h = 0;
                            }
                            for (int y = 0; y <= h; ++y) {
                                posList.add(new BlockPos(x, y, z));
                            }
                            x = pRandom.nextBoolean() ? x : (pRandom.nextBoolean() ? x + 1 : x - 1);
                        }
                        if (pDirection != Direction.NORTH) break block11;
                        for (BlockPos pos : posList) {
                            this.placeLog(pContext, (BlockPos)pMutablePos.setWithOffset((Vec3i)pBasePos, (Vec3i)pos));
                            this.placeDirt(pContext, (BlockPos)pMutablePos.setWithOffset((Vec3i)pBasePos, pos.getX(), -1, pos.getZ()));
                        }
                        break block12;
                    }
                    if (pDirection != Direction.SOUTH) break block13;
                    for (BlockPos pos : posList) {
                        this.placeLog(pContext, (BlockPos)pMutablePos.setWithOffset((Vec3i)pBasePos, -pos.getX() + 1, pos.getY(), -pos.getZ() + 1));
                        this.placeDirt(pContext, (BlockPos)pMutablePos.setWithOffset((Vec3i)pBasePos, -pos.getX() + 1, -1, -pos.getZ() + 1));
                    }
                    break block12;
                }
                if (pDirection != Direction.WEST) break block14;
                for (BlockPos pos : posList) {
                    this.placeLog(pContext, (BlockPos)pMutablePos.setWithOffset((Vec3i)pBasePos, pos.getZ(), pos.getY(), -pos.getX() + 1));
                    this.placeDirt(pContext, (BlockPos)pMutablePos.setWithOffset((Vec3i)pBasePos, pos.getZ(), -1, -pos.getX() + 1));
                }
                break block12;
            }
            if (pDirection != Direction.EAST) break block12;
            for (BlockPos pos : posList) {
                this.placeLog(pContext, (BlockPos)pMutablePos.setWithOffset((Vec3i)pBasePos, -pos.getZ() + 1, pos.getY(), pos.getX()));
                this.placeDirt(pContext, (BlockPos)pMutablePos.setWithOffset((Vec3i)pBasePos, -pos.getZ() + 1, -1, pos.getX()));
            }
        }
    }

    private void placeLog(TreeDecorator.Context pContext, BlockPos pPos) {
        if (TreeFeature.validTreePos((LevelSimulatedReader)pContext.level(), (BlockPos)pPos)) {
            pContext.setBlock(pPos, this.logProvider.getState(pContext.random(), pPos));
        }
    }

    private void placeDirt(TreeDecorator.Context pContext, BlockPos pPos) {
        if (TreeFeature.validTreePos((LevelSimulatedReader)pContext.level(), (BlockPos)pPos)) {
            pContext.setBlock(pPos, this.dirtProvider.getState(pContext.random(), pPos));
        }
    }
}

