/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.structure.pools;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.SBProcessorLists;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.pools.SBPools;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class RedwoodLodgePools
extends SBPools {
    public static final ResourceKey<StructureTemplatePool> START = RedwoodLodgePools.createKey("cabin");
    private static final ResourceKey<StructureTemplatePool> PATHS = RedwoodLodgePools.createKey("paths");
    private static final ResourceKey<StructureTemplatePool> CAMP = RedwoodLodgePools.createKey("camp");
    private static final ResourceKey<StructureTemplatePool> DECOR = RedwoodLodgePools.createKey("decor");

    public static void bootstrap(BootstapContext<StructureTemplatePool> context) {
        HolderGetter pools = context.lookup(Registries.TEMPLATE_POOL);
        HolderGetter processors = context.lookup(Registries.PROCESSOR_LIST);
        RedwoodLodgePools.register(context, START, (Holder<StructureTemplatePool>)pools.getOrThrow(Pools.EMPTY), StructureTemplatePool.Projection.RIGID, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(RedwoodLodgePools.element("cabin", 1)));
        RedwoodLodgePools.register(context, PATHS, (Holder<StructureTemplatePool>)pools.getOrThrow(DECOR), StructureTemplatePool.Projection.TERRAIN_MATCHING, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(RedwoodLodgePools.element("path_straight", 3, (Holder<StructureProcessorList>)processors.getOrThrow(SBProcessorLists.REDWOOD_PATH)), RedwoodLodgePools.element("path_corner", 2, (Holder<StructureProcessorList>)processors.getOrThrow(SBProcessorLists.REDWOOD_PATH)), RedwoodLodgePools.element("path_cross", 1, (Holder<StructureProcessorList>)processors.getOrThrow(SBProcessorLists.REDWOOD_PATH))));
        RedwoodLodgePools.register(context, CAMP, (Holder<StructureTemplatePool>)pools.getOrThrow(Pools.EMPTY), StructureTemplatePool.Projection.RIGID, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(RedwoodLodgePools.element("campfire", 3), RedwoodLodgePools.element("shed_1", 1), RedwoodLodgePools.element("shed_2", 1), RedwoodLodgePools.element("storage", 4)));
        RedwoodLodgePools.register(context, DECOR, (Holder<StructureTemplatePool>)pools.getOrThrow(Pools.EMPTY), StructureTemplatePool.Projection.RIGID, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(RedwoodLodgePools.element("logs_1", 1), RedwoodLodgePools.element("logs_2", 1), RedwoodLodgePools.element("well", 1)));
    }

    private static Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> element(String name, int weight) {
        return RedwoodLodgePools.parentElement("lodge/redwood", name, weight);
    }

    private static Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> element(String name, int weight, Holder<StructureProcessorList> processor) {
        return RedwoodLodgePools.parentElement("lodge/redwood", name, weight, processor);
    }

    private static ResourceKey<StructureTemplatePool> createKey(String name) {
        return RedwoodLodgePools.createParentKey("lodge/redwood", name);
    }
}

