/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.invictusslayer.slayersbeasts.client.model.AntSoldierModel;
import net.invictusslayer.slayersbeasts.client.state.AntSoldierRenderState;
import net.invictusslayer.slayersbeasts.world.entity.AbstractAnt;
import net.invictusslayer.slayersbeasts.world.entity.AntSoldier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class AntSoldierRenderer
extends MobRenderer<AntSoldier, AntSoldierRenderState, AntSoldierModel> {
    private static final ResourceLocation WOOD = ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"textures/entity/ant/wood_soldier.png");
    private static final ResourceLocation LEAFCUTTER = ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"textures/entity/ant/leafcutter_soldier.png");
    private static final ResourceLocation MEADOW = ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"textures/entity/ant/meadow_soldier.png");

    public AntSoldierRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AntSoldierModel(context.bakeLayer(AntSoldierModel.LAYER_LOCATION)), 0.3f);
    }

    protected void scale(AntSoldierRenderState state, PoseStack poseStack) {
        float f = 1.5f;
        poseStack.scale(f, f, f);
    }

    public ResourceLocation getTextureLocation(AntSoldierRenderState state) {
        return switch (state.variant) {
            default -> throw new MatchException(null, null);
            case AbstractAnt.Variant.WOOD -> WOOD;
            case AbstractAnt.Variant.LEAFCUTTER -> LEAFCUTTER;
            case AbstractAnt.Variant.MEADOW -> MEADOW;
        };
    }

    public AntSoldierRenderState createRenderState() {
        return new AntSoldierRenderState();
    }

    public void extractRenderState(AntSoldier entity, AntSoldierRenderState state, float f) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)state, f);
        state.variant = entity.getVariant();
    }
}

