/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.invictusslayer.slayersbeasts.client.model.AntWorkerModel;
import net.invictusslayer.slayersbeasts.client.renderer.layer.AntCargoLayer;
import net.invictusslayer.slayersbeasts.client.state.AntWorkerRenderState;
import net.invictusslayer.slayersbeasts.world.entity.AbstractAnt;
import net.invictusslayer.slayersbeasts.world.entity.AntWorker;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class AntWorkerRenderer
extends MobRenderer<AntWorker, AntWorkerRenderState, AntWorkerModel> {
    private static final ResourceLocation WOOD = ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"textures/entity/ant/wood_worker.png");
    private static final ResourceLocation LEAFCUTTER = ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"textures/entity/ant/leafcutter_worker.png");
    private static final ResourceLocation MEADOW = ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)"textures/entity/ant/meadow_worker.png");

    public AntWorkerRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AntWorkerModel(context.bakeLayer(AntWorkerModel.LAYER_LOCATION)), 0.3f);
        this.addLayer(new AntCargoLayer((RenderLayerParent<AntWorkerRenderState, AntWorkerModel>)this, context.getModelSet()));
    }

    protected void scale(AntWorkerRenderState state, PoseStack poseStack) {
        float f = 1.2f;
        poseStack.scale(f, f, f);
    }

    public ResourceLocation getTextureLocation(AntWorkerRenderState state) {
        return switch (state.variant) {
            default -> throw new MatchException(null, null);
            case AbstractAnt.Variant.WOOD -> WOOD;
            case AbstractAnt.Variant.LEAFCUTTER -> LEAFCUTTER;
            case AbstractAnt.Variant.MEADOW -> MEADOW;
        };
    }

    public AntWorkerRenderState createRenderState() {
        return new AntWorkerRenderState();
    }

    public void extractRenderState(AntWorker entity, AntWorkerRenderState state, float f) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)state, f);
        state.variant = entity.getVariant();
        state.cargo = entity.getCargoType();
    }
}

