/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.data;

import java.util.concurrent.CompletableFuture;
import net.invictusslayer.scabbard.world.level.WoodFamily;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.invictusslayer.slayersbeasts.registries.SBItems;
import net.invictusslayer.slayersbeasts.world.level.block.SBBlockFamily;
import net.invictusslayer.slayersbeasts.world.level.block.SBWoodFamily;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class SBRecipeProvider
extends RecipeProvider {
    private final HolderGetter<Item> items;

    public SBRecipeProvider(HolderLookup.Provider provider, RecipeOutput output) {
        super(provider, output);
        this.items = provider.lookupOrThrow(Registries.ITEM);
    }

    public void buildRecipes() {
        this.generateBlockFamilies();
        this.generateWoodFamilies(this.output);
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike)((ItemLike)SBItems.TIED_LEATHER.get())), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)SBItems.TANNED_LEATHER.get()), (float)0.5f, (int)200).unlockedBy("has_tied_leather", this.has((ItemLike)SBItems.TIED_LEATHER.get())).save(this.output);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)SBItems.TIED_LEATHER.get())).define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).define(Character.valueOf('M'), (ItemLike)SBItems.MUD_BALL.get()).pattern("MSM").pattern("LSL").pattern("MSM").unlockedBy("has_leather", this.has((ItemLike)Items.LEATHER)).save(this.output);
        this.twoByTwoPacker(this.output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.PACKED_MUD, (ItemLike)SBItems.MUD_BALL.get());
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)Blocks.PACKED_MUD), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SBBlocks.CRACKED_MUD.get()), (float)0.1f, (int)200).unlockedBy("has_packed_mud", this.has((ItemLike)Blocks.PACKED_MUD)).save(this.output);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)SBBlocks.PEAT.get()), (int)4).define(Character.valueOf('M'), (ItemLike)Blocks.MOSS_BLOCK).define(Character.valueOf('U'), (ItemLike)Blocks.MUD).pattern("MU").pattern("UM").unlockedBy("has_moss", this.has((ItemLike)Blocks.MOSS_BLOCK)).save(this.output);
        this.nineBlockStorageRecipes(this.output, RecipeCategory.MISC, (ItemLike)SBItems.JADE.get(), RecipeCategory.BUILDING_BLOCKS, (ItemLike)SBBlocks.JADE_BLOCK.get());
        this.twoByTwoPacker(this.output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)SBBlocks.BLACK_SANDSTONE.get(), (ItemLike)SBBlocks.BLACK_SAND.get());
        this.slabBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)SBBlocks.BLACK_SANDSTONE_SLAB.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)SBBlocks.BLACK_SANDSTONE.get(), (ItemLike)SBBlocks.CHISELED_BLACK_SANDSTONE.get()})).unlockedBy("has_black_sandstone", this.has((ItemLike)SBBlocks.BLACK_SANDSTONE.get())).unlockedBy("has_chiseled_black_sandstone", this.has((ItemLike)SBBlocks.CHISELED_BLACK_SANDSTONE.get())).save(this.output);
        this.stairBuilder((ItemLike)SBBlocks.BLACK_SANDSTONE_STAIRS.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)SBBlocks.BLACK_SANDSTONE.get(), (ItemLike)SBBlocks.CHISELED_BLACK_SANDSTONE.get(), (ItemLike)SBBlocks.CUT_BLACK_SANDSTONE.get()})).unlockedBy("has_black_sandstone", this.has((ItemLike)SBBlocks.BLACK_SANDSTONE.get())).unlockedBy("has_chiseled_black_sandstone", this.has((ItemLike)SBBlocks.CHISELED_BLACK_SANDSTONE.get())).unlockedBy("has_cut_black_sandstone", this.has((ItemLike)SBBlocks.CUT_BLACK_SANDSTONE.get())).save(this.output);
        this.wall(RecipeCategory.DECORATIONS, (ItemLike)SBBlocks.BLACK_SANDSTONE_WALL.get(), (ItemLike)SBBlocks.BLACK_SANDSTONE.get());
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)((ItemLike)SBBlocks.BLACK_SANDSTONE.get())), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)SBBlocks.SMOOTH_BLACK_SANDSTONE.get().asItem(), (float)0.1f, (int)200).unlockedBy("has_black_sandstone", this.has((ItemLike)SBBlocks.BLACK_SANDSTONE.get())).save(this.output);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)SBBlocks.BLACK_SANDSTONE_SLAB.get(), (ItemLike)SBBlocks.BLACK_SANDSTONE.get(), 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)SBBlocks.BLACK_SANDSTONE_STAIRS.get(), (ItemLike)SBBlocks.BLACK_SANDSTONE.get());
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, (ItemLike)SBBlocks.BLACK_SANDSTONE_WALL.get(), (ItemLike)SBBlocks.BLACK_SANDSTONE.get());
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)SBBlocks.SMOOTH_BLACK_SANDSTONE_SLAB.get(), (ItemLike)SBBlocks.SMOOTH_BLACK_SANDSTONE.get(), 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)SBBlocks.SMOOTH_BLACK_SANDSTONE_STAIRS.get(), (ItemLike)SBBlocks.SMOOTH_BLACK_SANDSTONE.get());
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)SBBlocks.CUT_BLACK_SANDSTONE.get(), (ItemLike)SBBlocks.BLACK_SANDSTONE.get());
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)SBBlocks.CUT_BLACK_SANDSTONE_SLAB.get(), (ItemLike)SBBlocks.BLACK_SANDSTONE.get(), 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)SBBlocks.CUT_BLACK_SANDSTONE_SLAB.get(), (ItemLike)SBBlocks.CUT_BLACK_SANDSTONE.get(), 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)SBBlocks.CHISELED_BLACK_SANDSTONE.get(), (ItemLike)SBBlocks.BLACK_SANDSTONE.get());
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)SBBlocks.PEGMATITE_SLAB.get(), (ItemLike)SBBlocks.PEGMATITE.get(), 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)SBBlocks.PEGMATITE_STAIRS.get(), (ItemLike)SBBlocks.PEGMATITE.get());
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, (ItemLike)SBBlocks.PEGMATITE_WALL.get(), (ItemLike)SBBlocks.PEGMATITE.get());
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)SBBlocks.POLISHED_PEGMATITE.get(), (ItemLike)SBBlocks.PEGMATITE.get());
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)SBBlocks.POLISHED_PEGMATITE_SLAB.get(), (ItemLike)SBBlocks.PEGMATITE.get(), 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)SBBlocks.POLISHED_PEGMATITE_SLAB.get(), (ItemLike)SBBlocks.POLISHED_PEGMATITE.get(), 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)SBBlocks.POLISHED_PEGMATITE_STAIRS.get(), (ItemLike)SBBlocks.PEGMATITE.get());
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)SBBlocks.POLISHED_PEGMATITE_STAIRS.get(), (ItemLike)SBBlocks.POLISHED_PEGMATITE.get());
    }

    private void generateWoodFamilies(RecipeOutput output) {
        SBWoodFamily.getAllFamilies().forEach(family -> {
            Block planks = (Block)family.get(WoodFamily.Variant.PLANKS).get();
            Ingredient ingredient = Ingredient.of((ItemLike)planks);
            family.getVariants().forEach((variant, supplier) -> {
                Object patt0$temp = supplier.get();
                if (!(patt0$temp instanceof ItemLike)) {
                    return;
                }
                ItemLike item = (ItemLike)patt0$temp;
                switch (variant) {
                    case BOAT: {
                        this.woodenBoat(item, (ItemLike)planks);
                        break;
                    }
                    case BUTTON: {
                        this.woodenRecipe(output, this.buttonBuilder(item, ingredient), planks, "button");
                        break;
                    }
                    case CHEST_BOAT: {
                        this.chestBoat(item, (ItemLike)((Item)family.get(WoodFamily.Variant.BOAT).get()));
                        break;
                    }
                    case DOOR: {
                        this.woodenRecipe(output, this.doorBuilder(item, ingredient), planks, "door");
                        break;
                    }
                    case FENCE: {
                        this.woodenRecipe(output, this.fenceBuilder(item, ingredient), planks, "fence");
                        break;
                    }
                    case FENCE_GATE: {
                        this.woodenRecipe(output, this.fenceGateBuilder(item, ingredient), planks, "fence_gate");
                        break;
                    }
                    case HANGING_SIGN_ITEM: {
                        this.hangingSign(item, (ItemLike)((Block)family.get(WoodFamily.Variant.STRIPPED_LOG).get()));
                        break;
                    }
                    case PLANKS: {
                        this.planksFromLog(item, family.getLogItems(), 4);
                        break;
                    }
                    case PRESSURE_PLATE: {
                        this.woodenRecipe(output, this.pressurePlateBuilder(RecipeCategory.REDSTONE, item, ingredient), planks, "pressure_plate");
                        break;
                    }
                    case SIGN_ITEM: {
                        this.woodenRecipe(output, this.signBuilder(item, ingredient), planks, "sign");
                        break;
                    }
                    case SLAB: {
                        this.woodenRecipe(output, this.slabBuilder(RecipeCategory.BUILDING_BLOCKS, item, ingredient), planks, "slab");
                        break;
                    }
                    case STAIRS: {
                        this.woodenRecipe(output, this.stairBuilder(item, ingredient), planks, "stairs");
                        break;
                    }
                    case STRIPPED_WOOD: {
                        this.woodFromLogs(item, (ItemLike)((Block)family.get(WoodFamily.Variant.STRIPPED_LOG).get()));
                        break;
                    }
                    case TRAPDOOR: {
                        this.woodenRecipe(output, this.trapdoorBuilder(item, ingredient), planks, "trapdoor");
                        break;
                    }
                    case WOOD: {
                        this.woodFromLogs(item, (ItemLike)((Block)family.get(WoodFamily.Variant.LOG).get()));
                    }
                }
            });
        });
    }

    private void woodenRecipe(RecipeOutput output, RecipeBuilder builder, Block planks, String group) {
        builder.unlockedBy("has_planks", this.has((ItemLike)planks)).group("wooden_" + group).save(output);
    }

    private void generateBlockFamilies() {
        SBBlockFamily.getAllFamilies().filter(BlockFamily::shouldGenerateRecipe).forEach(family -> this.generateRecipes((BlockFamily)family, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA)));
    }

    public void twoByTwoPacker(RecipeOutput output, RecipeCategory category, ItemLike pPacked, ItemLike pUnpacked) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)category, (ItemLike)pPacked, (int)1).define(Character.valueOf('#'), pUnpacked).pattern("##").pattern("##").unlockedBy(SBRecipeProvider.getHasName((ItemLike)pUnpacked), this.has(pUnpacked)).save(output, this.createRecipeKey(SBRecipeProvider.getSimpleRecipeName((ItemLike)pUnpacked)));
    }

    public void nineBlockStorageRecipes(RecipeOutput output, RecipeCategory unpackedCategory, ItemLike unpacked, RecipeCategory packedCategory, ItemLike packed) {
        this.nineBlockStorageRecipes(output, unpackedCategory, unpacked, packedCategory, packed, SBRecipeProvider.getSimpleRecipeName((ItemLike)packed), SBRecipeProvider.getSimpleRecipeName((ItemLike)unpacked));
    }

    public void nineBlockStorageRecipes(RecipeOutput output, RecipeCategory unpackedCategory, ItemLike unpacked, RecipeCategory packedCategory, ItemLike packed, String packedName, String unpackedName) {
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)unpackedCategory, (ItemLike)unpacked, (int)9).requires(packed).group(null).unlockedBy(SBRecipeProvider.getHasName((ItemLike)packed), this.has(packed)).save(output, this.createRecipeKey(unpackedName));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)packedCategory, (ItemLike)packed).define(Character.valueOf('#'), unpacked).pattern("###").pattern("###").pattern("###").group(null).unlockedBy(SBRecipeProvider.getHasName((ItemLike)unpacked), this.has(unpacked)).save(output, this.createRecipeKey(packedName));
    }

    private ResourceKey<Recipe<?>> createRecipeKey(String path) {
        return ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)path));
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
            super(output, provider);
        }

        public String getName() {
            return "SBRecipeProvider";
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput output) {
            return new SBRecipeProvider(provider, output);
        }
    }
}

