/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.data.lang;

import java.util.function.Supplier;
import net.invictusslayer.scabbard.data.LangProvider;
import net.invictusslayer.scabbard.world.level.WoodFamily;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.invictusslayer.slayersbeasts.registries.SBEffects;
import net.invictusslayer.slayersbeasts.registries.SBEntities;
import net.invictusslayer.slayersbeasts.registries.SBItems;
import net.invictusslayer.slayersbeasts.registries.SBSounds;
import net.invictusslayer.slayersbeasts.world.level.block.SBBlockFamily;
import net.invictusslayer.slayersbeasts.world.level.block.SBWoodFamily;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;

public class EnUsLangProvider
extends LangProvider {
    public EnUsLangProvider(PackOutput output) {
        super(output, "slayersbeasts", "en_us");
    }

    protected void addTranslations() {
        this.addItem(SBItems.MUSIC_DISC_INKISH, "Music Disc");
        this.addItemDesc(SBItems.MUSIC_DISC_INKISH, "Sam Newham - inkish");
        this.addItem(SBItems.JADE, "Jade");
        this.addItem(SBItems.JADE_SHARD, "Jade Shard");
        this.addItem(SBItems.CRYSTALLINE_WING, "Crystalline Wing");
        this.addItem(SBItems.CRYSTALLINE_CLAW, "Crystalline Claw");
        this.addItem(SBItems.CRYSTALLINE_CARAPACE, "Crystalline Carapace");
        this.addItem(SBItems.INSECT_WING, "Insect Wing");
        this.addItem(SBItems.INSECT_CLAW, "Insect Claw");
        this.addItem(SBItems.INSECT_EYE, "Insect Eye");
        this.addItem(SBItems.INSECT_LEG, "Insect Leg");
        this.addItem(SBItems.WITHERBONE, "Witherbone");
        this.addItem(SBItems.TIED_LEATHER, "Tied Leather");
        this.addItem(SBItems.TANNED_LEATHER, "Tanned Leather");
        this.addItem(SBItems.MUD_BALL, "Mud Ball");
        this.addItem(SBItems.MANTIS_SPAWN_EGG, "Mantis Spawn Egg");
        this.addItem(SBItems.ANT_WORKER_SPAWN_EGG, "Worker Ant Spawn Egg");
        this.addItem(SBItems.ANT_SOLDIER_SPAWN_EGG, "Soldier Ant Spawn Egg");
        this.addItem(SBItems.ANT_QUEEN_SPAWN_EGG, "Queen Ant Spawn Egg");
        this.addItem(SBItems.WITHER_SPIDER_SPAWN_EGG, "Wither Spider Spawn Egg");
        this.addItem(SBItems.TYRACHNID_SPAWN_EGG, "Tyrachnid Spawn Egg");
        this.addItem(SBItems.DAMSELFLY_SPAWN_EGG, "Damselfly Spawn Egg");
        this.addItem(SBItems.ENT_SPAWN_EGG, "Ent Spawn Egg");
        this.addItem(SBItems.WUDU_SPAWN_EGG, "Wudu Spawn Egg");
        this.addItem(SBItems.SPORETRAP_SPAWN_EGG, "Sporetrap Spawn Egg");
        this.add("item.minecraft.potion.effect.paralysis_potion", "Potion of Paralysis");
        this.add("item.minecraft.splash_potion.effect.paralysis_potion", "Splash Potion of Paralysis");
        this.add("item.minecraft.lingering_potion.effect.paralysis_potion", "Lingering Potion of Paralysis");
        this.add("item.minecraft.tipped_arrow.effect.paralysis_potion", "Arrow of Paralysis");
        this.add("item.minecraft.potion.effect.wither_potion", "Potion of Decay");
        this.add("item.minecraft.splash_potion.effect.wither_potion", "Splash Potion of Decay");
        this.add("item.minecraft.lingering_potion.effect.wither_potion", "Lingering Potion of Decay");
        this.add("item.minecraft.tipped_arrow.effect.wither_potion", "Arrow of Decay");
        this.addBlock(SBBlocks.CRYPTALITH, "Cryptalith");
        this.addBlock(SBBlocks.INFUSED_CRYPTALITH, "Infused Cryptalith");
        this.addBlock(SBBlocks.DEPLETED_CRYPTALITH, "Depleted Cryptalith");
        this.addBlock(SBBlocks.JADE_BLOCK, "Jade Block");
        this.addBlock(SBBlocks.EXOSKELETON_ORE, "Buried Exoskeleton Ore");
        this.addBlock(SBBlocks.DEEPSLATE_EXOSKELETON_ORE, "Embedded Exoskeleton Ore");
        this.addBlock(SBBlocks.STYPHIUM, "Styphium");
        this.addBlock(SBBlocks.DEEPSLATE_STYPHIUM, "Deepslate Styphium");
        this.addBlock(SBBlocks.BLACK_SAND, "Black Sand");
        this.addBlockFamily(SBBlockFamily.BLACK_SANDSTONE, "Black Sandstone");
        this.addBlockFamily(SBBlockFamily.SMOOTH_BLACK_SANDSTONE, "Smooth Black Sandstone");
        this.addBlockFamily(SBBlockFamily.CUT_BLACK_SANDSTONE, "Cut Black Sandstone");
        this.addBlockFamily(SBBlockFamily.PEGMATITE, "Pegmatite");
        this.addBlockFamily(SBBlockFamily.POLISHED_PEGMATITE, "Polished Pegmatite");
        this.addBlock(SBBlocks.RUDOSOL, "Rudosol");
        this.addBlock(SBBlocks.ARIDISOL, "Aridisol");
        this.addBlock(SBBlocks.ANTHILL, "Anthill");
        this.addBlock(SBBlocks.ANTHILL_HATCHERY, "Anthill Hatchery");
        this.addBlock(SBBlocks.OOTHECA, "Ootheca");
        this.addBlock(SBBlocks.GLEAMING_ICE, "Gleaming Ice");
        this.addBlock(SBBlocks.ICICLE, "Icicle");
        this.addBlock(SBBlocks.OBSIDIAN_SPIKE, "Obsidian Spike");
        this.addBlock(SBBlocks.CRACKED_MUD, "Cracked Mud");
        this.addBlock(SBBlocks.PEAT, "Peat");
        this.addBlock(SBBlocks.ALGAE, "Algae");
        this.addBlock(SBBlocks.TALL_DEAD_BUSH, "Tall Dead Bush");
        this.addBlock(SBBlocks.TALL_BROWN_MUSHROOM, "Tall Brown Mushroom");
        this.addBlock(SBBlocks.TALL_RED_MUSHROOM, "Tall Red Mushroom");
        this.addBlock(SBBlocks.BLACK_MUSHROOM_BLOCK, "Black Mushroom Block");
        this.addBlock(SBBlocks.BLACK_MUSHROOM, "Black Mushroom");
        this.addBlock(SBBlocks.TALL_BLACK_MUSHROOM, "Tall Black Mushroom");
        this.addBlock(SBBlocks.WHITE_MUSHROOM_BLOCK, "White Mushroom Block");
        this.addBlock(SBBlocks.WHITE_MUSHROOM, "White Mushroom");
        this.addBlock(SBBlocks.TALL_WHITE_MUSHROOM, "Tall White Mushroom");
        this.addWoodFamily(SBWoodFamily.ASPEN, "Aspen");
        this.addWoodFamily(SBWoodFamily.BLOODWOOD, "Bloodwood");
        this.addWoodFamily(SBWoodFamily.CAJOLE, "Cajole");
        this.addWoodFamily(SBWoodFamily.CYPRESS, "Cypress");
        this.addWoodFamily(SBWoodFamily.DESERT_OAK, "Desert Oak");
        this.addWoodFamily(SBWoodFamily.EUCALYPTUS, "Eucalyptus");
        this.addWoodFamily(SBWoodFamily.KAPOK, "Kapok");
        this.addWoodFamily(SBWoodFamily.REDWOOD, "Redwood");
        this.addBlock(SBBlocks.ALBINO_REDWOOD_LEAVES, "Albino Redwood Leaves");
        this.addBlock(SBBlocks.ALBINO_REDWOOD_SAPLING, "Albino Redwood Sapling");
        this.addWoodFamily(SBWoodFamily.WILLOW, "Willow");
        this.addBlock(SBBlocks.WILLOW_BRANCH, "Willow Branch");
        this.addBlock(SBBlocks.WILLOW_BRANCH_PLANT, "Willow Branch Plant");
        this.addEntityType(SBEntities.MANTIS, "Mantis");
        this.addEntityType(SBEntities.ANT_WORKER, "Worker Ant");
        this.addEntityType(SBEntities.ANT_SOLDIER, "Soldier Ant");
        this.addEntityType(SBEntities.ANT_QUEEN, "Queen Ant");
        this.addEntityType(SBEntities.WITHER_SPIDER, "Wither Spider");
        this.addEntityType(SBEntities.TYRACHNID, "Tyrachnid");
        this.addEntityType(SBEntities.DAMSELFLY, "Damselfly");
        this.addEntityType(SBEntities.ENT_MEDIUM, "Ent");
        this.addEntityType(SBEntities.WUDU, "Wudu");
        this.addEntityType(SBEntities.SPORETRAP, "Sporetrap");
        this.addEntityType(SBEntities.IRK, "Irk");
        this.add("itemGroup.slayersbeasts.slayers_tab", "Slayer's Beasts");
        this.add("itemGroup.slayersbeasts.slayers_wood", "Slayer's Wood Types");
        this.addEffect(SBEffects.PARALYSIS, "Paralysis");
        this.addSound(SBSounds.MANTIS_AMBIENT, "Mantis chirps");
        this.addSound(SBSounds.MANTIS_DEATH, "Mantis dies");
        this.addSound(SBSounds.MANTIS_HURT, "Mantis hurts");
        this.addConfigTitle("Slayer's Beasts Config");
        this.addConfigOption("worldgen", "World Generation Settings");
        this.addConfigOptionPrefix("worldgen.overworld_biomes", "Overworld Biomes", "Biomes in the Overworld are enabled.");
        this.addConfigOptionPrefix("worldgen.overworld_region_weight", "Overworld Region Weight", "The weighting of biome regions in the Overworld.");
        this.addConfigOptionPrefix("worldgen.nether_biomes", "Nether Biomes", "Biomes in the Nether are enabled.");
        this.addConfigOptionPrefix("worldgen.nether_region_weight", "Nether Region Weight", "The weighting of biome regions in the Nether.");
        this.addConfigOptionPrefix("worldgen.end_biomes", "End Biomes", "Biomes in the End are enabled.");
        this.addConfigOptionPrefix("worldgen.end_region_weight", "End Region Weight", "The weighting of biome regions in the End.");
        this.addConfigOption("worldgen.enabled_biomes", "Enabled Biomes");
        this.addConfigOptionPrefix("worldgen.enabled_biomes.ancient_grove", "Ancient Grove", "Overworld Biomes:");
        this.addConfigOption("worldgen.enabled_biomes.aspen_forest", "Aspen Forest");
        this.addConfigOption("worldgen.enabled_biomes.bayou", "Bayou");
        this.addConfigOption("worldgen.enabled_biomes.black_dunes", "Black Dunes");
        this.addConfigOption("worldgen.enabled_biomes.brushland", "Brushland");
        this.addConfigOption("worldgen.enabled_biomes.rocky_brushland", "Rocky Brushland");
        this.addConfigOption("worldgen.enabled_biomes.wooded_brushland", "Wooded Brushland");
        this.addConfigOption("worldgen.enabled_biomes.chaparral", "Chaparral");
        this.addConfigOption("worldgen.enabled_biomes.dead_sands", "Dead Sands");
        this.addConfigOption("worldgen.enabled_biomes.eucalypt_woodland", "Eucalypt Woodland");
        this.addConfigOption("worldgen.enabled_biomes.frozen_thicket", "Frozen Thicket");
        this.addConfigOption("worldgen.enabled_biomes.glaciate_swamp", "Glaciate Swamp");
        this.addConfigOption("worldgen.enabled_biomes.inky_moor", "Inky Moor");
        this.addConfigOption("worldgen.enabled_biomes.murky_ocean", "Murky Ocean");
        this.addConfigOption("worldgen.enabled_biomes.deep_murky_ocean", "Deep Murky Ocean");
        this.addConfigOption("worldgen.enabled_biomes.mushroom_forest", "Mushroom Forest");
        this.addConfigOption("worldgen.enabled_biomes.outback", "Outback");
        this.addConfigOption("worldgen.enabled_biomes.petrified_woods", "Petrified Woods");
        this.addConfigOption("worldgen.enabled_biomes.rainforest", "Rainforest");
        this.addConfigOption("worldgen.enabled_biomes.redwood_grove", "Redwood Grove");
        this.addConfigOption("worldgen.enabled_biomes.old_growth_redwood_grove", "Old Growth Redwood Grove");
        this.addConfigOption("worldgen.enabled_biomes.volcanic_peaks", "Volcanic Peaks");
        this.addConfigOptionPrefix("worldgen.enabled_biomes.dusty_caverns", "Dusty Caverns", "Underground Biomes:");
        this.addConfigOption("worldgen.enabled_biomes.fungal_depths", "Fungal Depths");
        this.addConfigOption("worldgen.enabled_biomes.ice_caves", "Ice Caves");
        this.addConfigOption("worldgen.enabled_biomes.slime_caverns", "Slime Caverns");
        this.addConfigOptionPrefix("worldgen.enabled_biomes.toxic_jungle", "Toxic Jungle", "Nether Biomes:");
        this.addConfigOptionPrefix("worldgen.enabled_biomes.end_spikes", "End Spikes", "End Biomes:");
    }

    protected void addWoodFamily(WoodFamily family, String name) {
        family.getVariants().forEach((variant, object) -> {
            switch (variant) {
                case BOAT: {
                    this.addEntityType((Supplier)object, name + " Boat");
                    break;
                }
                case BOAT_ITEM: {
                    this.addItem((Supplier)object, name + " Boat");
                    break;
                }
                case BUTTON: {
                    this.addBlock((Supplier)object, name + " Button");
                    break;
                }
                case CHEST_BOAT: {
                    this.addEntityType((Supplier)object, name + " Boat with Chest");
                    break;
                }
                case CHEST_BOAT_ITEM: {
                    this.addItem((Supplier)object, name + " Boat with Chest");
                    break;
                }
                case DOOR: {
                    this.addBlock((Supplier)object, name + " Door");
                    break;
                }
                case FENCE: {
                    this.addBlock((Supplier)object, name + " Fence");
                    break;
                }
                case FENCE_GATE: {
                    this.addBlock((Supplier)object, name + " Fence Gate");
                    break;
                }
                case HANGING_SIGN: {
                    this.addBlock((Supplier)object, name + " Hanging Sign");
                    break;
                }
                case LEAVES: {
                    this.addBlock((Supplier)object, name + " Leaves");
                    break;
                }
                case LOG: {
                    this.addBlock((Supplier)object, name + " Log");
                    break;
                }
                case PLANKS: {
                    this.addBlock((Supplier)object, name + " Planks");
                    break;
                }
                case PRESSURE_PLATE: {
                    this.addBlock((Supplier)object, name + " Pressure Plate");
                    break;
                }
                case SAPLING: {
                    this.addBlock((Supplier)object, name + " Sapling");
                    break;
                }
                case SIGN: {
                    this.addBlock((Supplier)object, name + " Sign");
                    break;
                }
                case STAIRS: {
                    this.addBlock((Supplier)object, name + " Stairs");
                    break;
                }
                case STRIPPED_LOG: {
                    this.addBlock((Supplier)object, "Stripped " + name + " Log");
                    break;
                }
                case STRIPPED_WOOD: {
                    this.addBlock((Supplier)object, "Stripped " + name + " Wood");
                    break;
                }
                case TRAPDOOR: {
                    this.addBlock((Supplier)object, name + " Trapdoor");
                    break;
                }
                case WOOD: {
                    this.addBlock((Supplier)object, name + " Wood");
                }
            }
        });
    }

    protected void addBlockFamily(BlockFamily family, String name) {
        this.addBlockFamily(family, name, false);
    }

    protected void addBlockFamily(BlockFamily family, String name, boolean ignoreBase) {
        if (!ignoreBase) {
            this.addBlock(() -> ((BlockFamily)family).getBaseBlock(), name);
        }
        family.getVariants().forEach((variant, block) -> {
            switch (variant) {
                case BUTTON: {
                    this.addBlock(() -> block, name + " Button");
                    break;
                }
                case CHISELED: {
                    this.addBlock(() -> block, "Chiseled " + name);
                    break;
                }
                case CRACKED: {
                    this.addBlock(() -> block, "Cracked " + name);
                    break;
                }
                case DOOR: {
                    this.addBlock(() -> block, name + " Door");
                    break;
                }
                case FENCE: {
                    this.addBlock(() -> block, name + " Fence");
                    break;
                }
                case FENCE_GATE: {
                    this.addBlock(() -> block, name + " Fence Gate");
                    break;
                }
                case SIGN: {
                    this.addBlock(() -> block, name + " Sign");
                    break;
                }
                case SLAB: {
                    this.addBlock(() -> block, name + " Slab");
                    break;
                }
                case STAIRS: {
                    this.addBlock(() -> block, name + " Stairs");
                    break;
                }
                case PRESSURE_PLATE: {
                    this.addBlock(() -> block, name + " Pressure Plate");
                    break;
                }
                case TRAPDOOR: {
                    this.addBlock(() -> block, name + " Trapdoor");
                    break;
                }
                case WALL: {
                    this.addBlock(() -> block, name + " Wall");
                }
            }
        });
    }
}

