/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.mixin.common;

import java.util.Optional;
import net.invictusslayer.slayersbeasts.world.level.block.IExtendedMushroomBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MushroomBlock.class})
public class MushroomBlockMixin
implements IExtendedMushroomBlock {
    @Unique
    private ResourceKey<ConfiguredFeature<?, ?>> mightyMushroom;

    @Inject(method={"growMushroom"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGrowMushroom(ServerLevel level, BlockPos pos, BlockState state, RandomSource random, CallbackInfoReturnable<Boolean> cir) {
        Optional feature = level.registryAccess().lookupOrThrow(Registries.CONFIGURED_FEATURE).get(this.mightyMushroom);
        if (feature.isEmpty()) {
            cir.setReturnValue((Object)false);
        }
        for (int x = 0; x >= -1; --x) {
            for (int z = 0; z >= -1; --z) {
                if (!this.isTwoByTwoMushroom(state, (BlockGetter)level, pos, x, z)) continue;
                level.removeBlock(pos.offset(x, 0, z), false);
                level.removeBlock(pos.offset(x + 1, 0, z), false);
                level.removeBlock(pos.offset(x, 0, z + 1), false);
                level.removeBlock(pos.offset(x + 1, 0, z + 1), false);
                if (((ConfiguredFeature)((Holder)feature.get()).value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), random, pos.offset(x, 0, z))) {
                    cir.setReturnValue((Object)true);
                    continue;
                }
                level.setBlock(pos.offset(x, 0, z), state, 3);
                level.setBlock(pos.offset(x + 1, 0, z), state, 3);
                level.setBlock(pos.offset(x, 0, z + 1), state, 3);
                level.setBlock(pos.offset(x + 1, 0, z + 1), state, 3);
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Unique
    private boolean isTwoByTwoMushroom(BlockState state, BlockGetter level, BlockPos pos, int x, int z) {
        Block block = state.getBlock();
        return level.getBlockState(pos.offset(x, 0, z)).is(block) && level.getBlockState(pos.offset(x + 1, 0, z)).is(block) && level.getBlockState(pos.offset(x, 0, z + 1)).is(block) && level.getBlockState(pos.offset(x + 1, 0, z + 1)).is(block);
    }

    @Override
    public void setMightyMushroom(ResourceKey<ConfiguredFeature<?, ?>> mightyMushroom) {
        this.mightyMushroom = mightyMushroom;
    }
}

