/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.mixin.common;

import java.util.UUID;
import net.invictusslayer.slayersbeasts.world.entity.SBMushroomCowVariant;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.animal.MushroomCow;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MushroomCow.class})
public abstract class MushroomCowMixin {
    @Shadow
    private UUID lastLightningBoltUUID;

    @Shadow
    public abstract MushroomCow.Variant getVariant();

    @Inject(method={"thunderHit"}, at={@At(value="HEAD")}, cancellable=true)
    private void onThunderHit(ServerLevel level, LightningBolt lightning, CallbackInfo ci) {
        UUID uuid = lightning.getUUID();
        if (!uuid.equals(this.lastLightningBoltUUID)) {
            ((MushroomCow)this).setVariant(MushroomCowMixin.cycleVariant(this.getVariant()));
            this.lastLightningBoltUUID = uuid;
            ((MushroomCow)this).playSound(SoundEvents.MOOSHROOM_CONVERT, 2.0f, 1.0f);
        }
        ci.cancel();
    }

    @Inject(method={"getOffspringVariant"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetOffspringType(MushroomCow mate, CallbackInfoReturnable<MushroomCow.Variant> cir) {
        MushroomCow.Variant mateType;
        MushroomCow.Variant type = this.getVariant();
        if (type == (mateType = mate.getVariant()) && RandomSource.create().nextInt(1024) == 0) {
            cir.setReturnValue((Object)MushroomCowMixin.cycleVariant(type));
        }
        cir.setReturnValue((Object)(RandomSource.create().nextBoolean() ? type : mateType));
    }

    @Unique
    private static MushroomCow.Variant cycleVariant(MushroomCow.Variant type) {
        if (type == MushroomCow.Variant.RED) {
            return MushroomCow.Variant.BROWN;
        }
        if (type == MushroomCow.Variant.BROWN) {
            return SBMushroomCowVariant.WHITE;
        }
        if (type == SBMushroomCowVariant.WHITE) {
            return SBMushroomCowVariant.BLACK;
        }
        return MushroomCow.Variant.RED;
    }
}

