/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.registries;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.invictusslayer.slayersbeasts.SlayersBeasts;
import net.invictusslayer.slayersbeasts.registries.SBItems;
import net.invictusslayer.slayersbeasts.world.entity.AntQueen;
import net.invictusslayer.slayersbeasts.world.entity.AntSoldier;
import net.invictusslayer.slayersbeasts.world.entity.AntWorker;
import net.invictusslayer.slayersbeasts.world.entity.Damselfly;
import net.invictusslayer.slayersbeasts.world.entity.EntMedium;
import net.invictusslayer.slayersbeasts.world.entity.Irk;
import net.invictusslayer.slayersbeasts.world.entity.Mantis;
import net.invictusslayer.slayersbeasts.world.entity.Sporetrap;
import net.invictusslayer.slayersbeasts.world.entity.Tyrachnid;
import net.invictusslayer.slayersbeasts.world.entity.WitherSpider;
import net.invictusslayer.slayersbeasts.world.entity.Wudu;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.levelgen.Heightmap;

public class SBEntities {
    public static final Supplier<EntityType<Mantis>> MANTIS = SBEntities.register("mantis", EntityType.Builder.of(Mantis::new, (MobCategory)MobCategory.MONSTER).sized(1.6f, 1.4f));
    public static final Supplier<EntityType<AntWorker>> ANT_WORKER = SBEntities.register("ant_worker", EntityType.Builder.of(AntWorker::new, (MobCategory)MobCategory.AMBIENT).sized(0.7f, 0.4f));
    public static final Supplier<EntityType<AntSoldier>> ANT_SOLDIER = SBEntities.register("ant_soldier", EntityType.Builder.of(AntSoldier::new, (MobCategory)MobCategory.CREATURE).sized(1.8f, 0.9f));
    public static final Supplier<EntityType<AntQueen>> ANT_QUEEN = SBEntities.register("ant_queen", EntityType.Builder.of(AntQueen::new, (MobCategory)MobCategory.CREATURE).sized(2.2f, 1.2f));
    public static final Supplier<EntityType<WitherSpider>> WITHER_SPIDER = SBEntities.register("wither_spider", EntityType.Builder.of(WitherSpider::new, (MobCategory)MobCategory.MONSTER).sized(1.8f, 0.7f));
    public static final Supplier<EntityType<Tyrachnid>> TYRACHNID = SBEntities.register("tyrachnid", EntityType.Builder.of(Tyrachnid::new, (MobCategory)MobCategory.MONSTER).sized(3.5f, 2.0f));
    public static final Supplier<EntityType<Damselfly>> DAMSELFLY = SBEntities.register("damselfly", EntityType.Builder.of(Damselfly::new, (MobCategory)MobCategory.AMBIENT).sized(0.8f, 0.2f));
    public static final Supplier<EntityType<EntMedium>> ENT_MEDIUM = SBEntities.register("ent_medium", EntityType.Builder.of(EntMedium::new, (MobCategory)MobCategory.MONSTER).sized(1.3f, 5.4f));
    public static final Supplier<EntityType<Wudu>> WUDU = SBEntities.register("wudu", EntityType.Builder.of(Wudu::new, (MobCategory)MobCategory.MONSTER).sized(1.0f, 1.0f));
    public static final Supplier<EntityType<Sporetrap>> SPORETRAP = SBEntities.register("sporetrap", EntityType.Builder.of(Sporetrap::new, (MobCategory)MobCategory.MONSTER).sized(0.8f, 1.8f));
    public static final Supplier<EntityType<Irk>> IRK = SBEntities.register("irk", EntityType.Builder.of(Irk::new, (MobCategory)MobCategory.MONSTER).sized(0.7f, 0.8f));
    public static final Supplier<EntityType<Boat>> ASPEN_BOAT = SBEntities.registerBoat("aspen_boat", SBItems.ASPEN_BOAT);
    public static final Supplier<EntityType<ChestBoat>> ASPEN_CHEST_BOAT = SBEntities.registerChestBoat("aspen_chest_boat", SBItems.ASPEN_CHEST_BOAT);
    public static final Supplier<EntityType<Boat>> BLOODWOOD_BOAT = SBEntities.registerBoat("bloodwood_boat", SBItems.BLOODWOOD_BOAT);
    public static final Supplier<EntityType<ChestBoat>> BLOODWOOD_CHEST_BOAT = SBEntities.registerChestBoat("bloodwood_chest_boat", SBItems.BLOODWOOD_CHEST_BOAT);
    public static final Supplier<EntityType<Boat>> CYPRESS_BOAT = SBEntities.registerBoat("cypress_boat", SBItems.CYPRESS_BOAT);
    public static final Supplier<EntityType<ChestBoat>> CYPRESS_CHEST_BOAT = SBEntities.registerChestBoat("cypress_chest_boat", SBItems.CYPRESS_CHEST_BOAT);
    public static final Supplier<EntityType<Boat>> DESERT_OAK_BOAT = SBEntities.registerBoat("desert_oak_boat", SBItems.DESERT_OAK_BOAT);
    public static final Supplier<EntityType<ChestBoat>> DESERT_OAK_CHEST_BOAT = SBEntities.registerChestBoat("desert_oak_chest_boat", SBItems.DESERT_OAK_CHEST_BOAT);
    public static final Supplier<EntityType<Boat>> EUCALYPTUS_BOAT = SBEntities.registerBoat("eucalyptus_boat", SBItems.EUCALYPTUS_BOAT);
    public static final Supplier<EntityType<ChestBoat>> EUCALYPTUS_CHEST_BOAT = SBEntities.registerChestBoat("eucalyptus_chest_boat", SBItems.EUCALYPTUS_CHEST_BOAT);
    public static final Supplier<EntityType<Boat>> KAPOK_BOAT = SBEntities.registerBoat("kapok_boat", SBItems.KAPOK_BOAT);
    public static final Supplier<EntityType<ChestBoat>> KAPOK_CHEST_BOAT = SBEntities.registerChestBoat("kapok_chest_boat", SBItems.KAPOK_CHEST_BOAT);
    public static final Supplier<EntityType<Boat>> REDWOOD_BOAT = SBEntities.registerBoat("redwood_boat", SBItems.REDWOOD_BOAT);
    public static final Supplier<EntityType<ChestBoat>> REDWOOD_CHEST_BOAT = SBEntities.registerChestBoat("redwood_chest_boat", SBItems.REDWOOD_CHEST_BOAT);
    public static final Supplier<EntityType<Boat>> WILLOW_BOAT = SBEntities.registerBoat("willow_boat", SBItems.WILLOW_BOAT);
    public static final Supplier<EntityType<ChestBoat>> WILLOW_CHEST_BOAT = SBEntities.registerChestBoat("willow_chest_boat", SBItems.WILLOW_CHEST_BOAT);

    public static <T extends Mob> void registerSpawns(Consumer<SpawnPlacement<T>> consumer) {
        consumer.accept(new SpawnPlacement<Mantis>(MANTIS.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.WORLD_SURFACE, Mantis::canSpawn));
        consumer.accept(new SpawnPlacement<AntWorker>(ANT_WORKER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.WORLD_SURFACE, AntWorker::canSpawn));
        consumer.accept(new SpawnPlacement<AntSoldier>(ANT_SOLDIER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.WORLD_SURFACE, AntSoldier::canSpawn));
        consumer.accept(new SpawnPlacement<AntQueen>(ANT_QUEEN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.WORLD_SURFACE, AntQueen::canSpawn));
        consumer.accept(new SpawnPlacement<WitherSpider>(WITHER_SPIDER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.WORLD_SURFACE, WitherSpider::canSpawn));
        consumer.accept(new SpawnPlacement<Damselfly>(DAMSELFLY.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.WORLD_SURFACE, Damselfly::canSpawn));
        consumer.accept(new SpawnPlacement<EntMedium>(ENT_MEDIUM.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.WORLD_SURFACE, EntMedium::canSpawn));
        consumer.accept(new SpawnPlacement<Sporetrap>(SPORETRAP.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.WORLD_SURFACE, Sporetrap::canSpawn));
    }

    public static void registerAttributes(BiConsumer<EntityType<? extends LivingEntity>, AttributeSupplier> consumer) {
        consumer.accept(MANTIS.get(), Mantis.createAttributes().build());
        consumer.accept(ANT_WORKER.get(), AntWorker.createAttributes().build());
        consumer.accept(ANT_SOLDIER.get(), AntSoldier.createAttributes().build());
        consumer.accept(ANT_QUEEN.get(), AntQueen.createAttributes().build());
        consumer.accept(WITHER_SPIDER.get(), WitherSpider.createAttributes().build());
        consumer.accept(TYRACHNID.get(), Tyrachnid.createAttributes().build());
        consumer.accept(DAMSELFLY.get(), Damselfly.createAttributes().build());
        consumer.accept(ENT_MEDIUM.get(), EntMedium.createAttributes().build());
        consumer.accept(WUDU.get(), Wudu.createAttributes().build());
        consumer.accept(SPORETRAP.get(), Sporetrap.createAttributes().build());
        consumer.accept(IRK.get(), Irk.createAttributes().build());
    }

    public static Supplier<EntityType<Boat>> registerBoat(String name, Supplier<Item> item) {
        return SBEntities.register(name, EntityType.Builder.of((type, level) -> new Boat(type, level, item), (MobCategory)MobCategory.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));
    }

    public static Supplier<EntityType<ChestBoat>> registerChestBoat(String name, Supplier<Item> item) {
        return SBEntities.register(name, EntityType.Builder.of((type, level) -> new ChestBoat(type, level, item), (MobCategory)MobCategory.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10));
    }

    public static <T extends Entity> Supplier<EntityType<T>> register(String name, EntityType.Builder<T> builder) {
        return SlayersBeasts.PLATFORM.register((Registry)BuiltInRegistries.ENTITY_TYPE, "slayersbeasts", name, () -> builder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)name))));
    }

    public static void register() {
        SlayersBeasts.LOGGER.info("Registering SBEntities...");
    }

    public record SpawnPlacement<T extends Mob>(EntityType<T> entity, SpawnPlacementType placement, Heightmap.Types heightmap, SpawnPlacements.SpawnPredicate<T> predicate) {
    }
}

