/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.block;

import com.mojang.serialization.MapCodec;
import net.invictusslayer.slayersbeasts.data.tags.SBTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PeatBlock
extends FallingBlock {
    public static final MapCodec<PeatBlock> CODEC = PeatBlock.simpleCodec(PeatBlock::new);

    public PeatBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return CODEC;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!(entity instanceof LivingEntity) || entity.getBlockStateOn().is((Block)this)) {
            entity.makeStuckInBlock(state, new Vec3(0.4, 0.4, 0.4));
            if (level.isClientSide) {
                boolean flag;
                RandomSource random = level.getRandom();
                boolean bl = flag = entity.xOld != entity.getX() || entity.zOld != entity.getZ();
                if (flag && random.nextInt(10) == 0) {
                    level.addParticle((ParticleOptions)ParticleTypes.SQUID_INK, entity.getX(), (double)(pos.getY() + 1), entity.getZ(), (double)(Mth.randomBetween((RandomSource)random, (float)-1.0f, (float)1.0f) / 12.0f), 0.05, (double)(Mth.randomBetween((RandomSource)random, (float)-1.0f, (float)1.0f) / 12.0f));
                }
            }
        }
        entity.setSharedFlagOnFire(false);
    }

    public boolean skipRendering(BlockState state, BlockState adjacentState, Direction direction) {
        return adjacentState.is((Block)this) || super.skipRendering(state, adjacentState, direction);
    }

    public VoxelShape getOcclusionShape(BlockState state) {
        return Shapes.empty();
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entitycollisioncontext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entitycollisioncontext = (EntityCollisionContext)context).getEntity()) != null) {
            if (entity instanceof FallingBlockEntity) {
                return super.getCollisionShape(state, level, pos, context);
            }
            if (entity.fallDistance > 2.5f) {
                return Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.9, (double)1.0);
            }
            if (entity.getType().is(SBTags.EntityTypes.PEAT_WALKABLE_MOBS) && context.isAbove(Shapes.block(), pos, false) && !context.isDescending()) {
                return super.getCollisionShape(state, level, pos, context);
            }
        }
        return Shapes.empty();
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return true;
    }
}

