/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.feature.icicle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.OptionalInt;
import net.invictusslayer.slayersbeasts.data.tags.SBTags;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.invictusslayer.slayersbeasts.world.level.gen.feature.icicle.IcicleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ClampedNormalFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class IcicleClusterFeature
extends Feature<Configuration> {
    public IcicleClusterFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Configuration> context) {
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        Configuration config = (Configuration)context.config();
        RandomSource random = context.random();
        if (!IcicleUtils.isEmptyOrWater((LevelAccessor)level, origin)) {
            return false;
        }
        int height = config.height.sample(random);
        float lightChance = config.lightChance.sample(random);
        float density = config.density.sample(random);
        int xRadius = config.radius.sample(random);
        int zRadius = config.radius.sample(random);
        for (int x = -xRadius; x <= xRadius; ++x) {
            for (int z = -zRadius; z <= zRadius; ++z) {
                BlockPos blockPos = origin.offset(x, 0, z);
                double chance = this.getChanceOfIcicle(xRadius, zRadius, x, z, config);
                this.placeColumn(level, random, blockPos, x, z, lightChance, chance, height, density, config);
            }
        }
        return true;
    }

    private void placeColumn(WorldGenLevel level, RandomSource random, BlockPos pos, int x, int z, float lightChance, double chance, int height, float density, Configuration config) {
        Optional optional = Column.scan((LevelSimulatedReader)level, (BlockPos)pos, (int)config.caveHeightSearchRange, IcicleUtils::isEmptyOrWater, IcicleUtils::isNeitherEmptyNorWater);
        if (optional.isPresent()) {
            OptionalInt ceiling = ((Column)optional.get()).getCeiling();
            OptionalInt floor = ((Column)optional.get()).getFloor();
            if (ceiling.isPresent() || floor.isPresent()) {
                boolean flag3;
                int j1;
                int j3;
                int i3;
                Column column = (Column)optional.get();
                if (random.nextFloat() < lightChance && floor.isPresent() && this.canPlaceLight(level, pos.atY(floor.getAsInt()))) {
                    level.setBlock(pos.atY(floor.getAsInt()), SBBlocks.GLEAMING_ICE.get().defaultBlockState(), 2);
                }
                OptionalInt columnFloor = column.getFloor();
                int j = 0;
                if (ceiling.isPresent() && random.nextDouble() < chance && this.notLava((LevelReader)level, pos.atY(ceiling.getAsInt()))) {
                    int k = config.layerThickness.sample(random);
                    this.replaceBlocksWithIce(level, pos.atY(ceiling.getAsInt()), k, Direction.UP);
                    int l = columnFloor.isPresent() ? Math.min(height, ceiling.getAsInt() - columnFloor.getAsInt()) : height;
                    j = this.getIcicleHeight(random, x, z, density, l, config);
                }
                if (columnFloor.isPresent() && random.nextDouble() < chance && this.notLava((LevelReader)level, pos.atY(columnFloor.getAsInt()))) {
                    int i1 = config.layerThickness.sample(random);
                    this.replaceBlocksWithIce(level, pos.atY(columnFloor.getAsInt()), i1, Direction.DOWN);
                    i3 = ceiling.isPresent() ? Math.max(0, j + Mth.randomBetweenInclusive((RandomSource)random, (int)(-config.maxHeightDifference), (int)config.maxHeightDifference)) : this.getIcicleHeight(random, x, z, density, height, config);
                } else {
                    i3 = 0;
                }
                if (ceiling.isPresent() && columnFloor.isPresent() && ceiling.getAsInt() - j <= columnFloor.getAsInt() + i3) {
                    int k1 = columnFloor.getAsInt();
                    int l1 = ceiling.getAsInt();
                    int i2 = Math.max(l1 - j, k1 + 1);
                    int j2 = Math.min(k1 + i3, l1 - 1);
                    int k2 = Mth.randomBetweenInclusive((RandomSource)random, (int)i2, (int)(j2 + 1));
                    int l2 = k2 - 1;
                    j3 = l1 - k2;
                    j1 = l2 - k1;
                } else {
                    j3 = j;
                    j1 = i3;
                }
                boolean bl = flag3 = random.nextBoolean() && j3 > 0 && j1 > 0 && column.getHeight().isPresent() && j3 + j1 == column.getHeight().getAsInt();
                if (ceiling.isPresent()) {
                    IcicleUtils.growIcicle((LevelAccessor)level, pos.atY(ceiling.getAsInt() - 1), Direction.DOWN, j3, flag3);
                }
                if (columnFloor.isPresent()) {
                    IcicleUtils.growIcicle((LevelAccessor)level, pos.atY(columnFloor.getAsInt() + 1), Direction.UP, j1, flag3);
                }
            }
        }
    }

    private boolean notLava(LevelReader level, BlockPos pos) {
        return !level.getBlockState(pos).is(Blocks.LAVA);
    }

    private int getIcicleHeight(RandomSource random, int x, int z, float chance, int height, Configuration config) {
        if (random.nextFloat() > chance) {
            return 0;
        }
        int i = Math.abs(x) + Math.abs(z);
        float mean = (float)Mth.clampedMap((double)i, (double)0.0, (double)config.maxRadiusAffectingHeightBias, (double)((double)height / 2.0), (double)0.0);
        return (int)ClampedNormalFloat.sample((RandomSource)random, (float)mean, (float)config.heightDeviation, (float)0.0f, (float)height);
    }

    private boolean canPlaceLight(WorldGenLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.is(Blocks.WATER) || state.is(Blocks.PACKED_ICE) || state.is(SBBlocks.ICICLE.get())) {
            return false;
        }
        if (level.getBlockState(pos.above()).getFluidState().is(FluidTags.WATER)) {
            return false;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (this.canBeAdjacentToWater((LevelAccessor)level, pos.relative(direction))) continue;
            return false;
        }
        return this.canBeAdjacentToWater((LevelAccessor)level, pos.below());
    }

    private boolean canBeAdjacentToWater(LevelAccessor level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return state.is(SBTags.Blocks.ICICLE_REPLACEABLE) || state.getFluidState().is(FluidTags.WATER);
    }

    private void replaceBlocksWithIce(WorldGenLevel level, BlockPos pos, int thickness, Direction direction) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        for (int i = 0; i < thickness; ++i) {
            if (!IcicleUtils.placeIceIfPossible((LevelAccessor)level, (BlockPos)mutableBlockPos)) {
                return;
            }
            mutableBlockPos.move(direction);
        }
    }

    private double getChanceOfIcicle(int xRadius, int zRadius, int x, int z, Configuration config) {
        float i = Math.min(xRadius - Math.abs(x), zRadius - Math.abs(z));
        return Mth.clampedMap((float)i, (float)0.0f, (float)config.maxRadiusAffectingColumnChance, (float)config.columnChanceAtMaxRadius, (float)1.0f);
    }

    public record Configuration(int caveHeightSearchRange, IntProvider height, IntProvider radius, int maxHeightDifference, int heightDeviation, IntProvider layerThickness, FloatProvider density, FloatProvider lightChance, float columnChanceAtMaxRadius, int maxRadiusAffectingColumnChance, int maxRadiusAffectingHeightBias) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)1, (int)512).fieldOf("cave_height_search_range").forGetter(Configuration::caveHeightSearchRange), (App)IntProvider.codec((int)1, (int)128).fieldOf("height").forGetter(Configuration::height), (App)IntProvider.codec((int)1, (int)128).fieldOf("radius").forGetter(Configuration::radius), (App)Codec.intRange((int)0, (int)64).fieldOf("max_height_difference").forGetter(Configuration::maxHeightDifference), (App)Codec.intRange((int)1, (int)64).fieldOf("height_deviation").forGetter(Configuration::heightDeviation), (App)IntProvider.codec((int)0, (int)128).fieldOf("layer_thickness").forGetter(Configuration::layerThickness), (App)FloatProvider.codec((float)0.0f, (float)2.0f).fieldOf("density").forGetter(Configuration::density), (App)FloatProvider.codec((float)0.0f, (float)2.0f).fieldOf("light_chance").forGetter(Configuration::lightChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("column_chance_at_max_radius").forGetter(Configuration::columnChanceAtMaxRadius), (App)Codec.intRange((int)1, (int)64).fieldOf("max_radius_affecting_column_chance").forGetter(Configuration::maxRadiusAffectingColumnChance), (App)Codec.intRange((int)1, (int)64).fieldOf("max_radius_affecting_height_bias").forGetter(Configuration::maxRadiusAffectingHeightBias)).apply((Applicative)instance, Configuration::new));
    }
}

