/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.feature.icicle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.invictusslayer.slayersbeasts.data.tags.SBTags;
import net.invictusslayer.slayersbeasts.world.level.gen.feature.icicle.IcicleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.phys.Vec3;

public class IcicleLargeFeature
extends Feature<Configuration> {
    public IcicleLargeFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Configuration> context) {
        Object t;
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        Configuration config = (Configuration)context.config();
        RandomSource random = context.random();
        if (!IcicleUtils.isEmptyOrWater((LevelAccessor)level, origin)) {
            return false;
        }
        Optional optional = Column.scan((LevelSimulatedReader)level, (BlockPos)origin, (int)config.caveHeightSearchRange, IcicleUtils::isEmptyOrWater, IcicleUtils::isIcicleBaseOrLava);
        if (optional.isPresent() && (t = optional.get()) instanceof Column.Range) {
            Column.Range range = (Column.Range)t;
            if (range.height() < 4) {
                return false;
            }
            int max = Mth.clamp((int)((int)((float)range.height() * config.maxRadiusHeightRatio)), (int)config.columnRadius.getMinValue(), (int)config.columnRadius.getMaxValue());
            int radius = Mth.randomBetweenInclusive((RandomSource)random, (int)config.columnRadius.getMinValue(), (int)max);
            LargeIcicle topIcicle = IcicleLargeFeature.makeIcicle(origin.atY(range.ceiling() - 1), false, random, radius, config.topBluntness, config.heightScale);
            LargeIcicle bottomIcicle = IcicleLargeFeature.makeIcicle(origin.atY(range.floor() + 1), true, random, radius, config.bottomBluntness, config.heightScale);
            WindOffsetter offsetter = topIcicle.isSuitableForWind(config) && bottomIcicle.isSuitableForWind(config) ? new WindOffsetter(origin.getY(), random, config.windSpeed) : new WindOffsetter();
            boolean flag = topIcicle.alignBaseAndShrinkRadius(level, offsetter);
            boolean flag1 = bottomIcicle.alignBaseAndShrinkRadius(level, offsetter);
            if (flag) {
                topIcicle.placeBlocks(level, random, offsetter);
            }
            if (flag1) {
                bottomIcicle.placeBlocks(level, random, offsetter);
            }
            return true;
        }
        return false;
    }

    private static LargeIcicle makeIcicle(BlockPos origin, boolean pointingUp, RandomSource random, int radius, FloatProvider baseBluntness, FloatProvider baseScale) {
        return new LargeIcicle(origin, pointingUp, radius, baseBluntness.sample(random), baseScale.sample(random));
    }

    public record Configuration(int caveHeightSearchRange, IntProvider columnRadius, FloatProvider heightScale, float maxRadiusHeightRatio, FloatProvider topBluntness, FloatProvider bottomBluntness, FloatProvider windSpeed, int minWindRadius, float minWindBluntness) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)1, (int)512).fieldOf("cave_height_search_range").forGetter(Configuration::caveHeightSearchRange), (App)IntProvider.codec((int)1, (int)60).fieldOf("column_radius").forGetter(Configuration::columnRadius), (App)FloatProvider.codec((float)0.0f, (float)20.0f).fieldOf("height_scale").forGetter(Configuration::heightScale), (App)Codec.floatRange((float)0.1f, (float)1.0f).fieldOf("max_radius_height_ratio").forGetter(Configuration::maxRadiusHeightRatio), (App)FloatProvider.codec((float)0.1f, (float)10.0f).fieldOf("top_bluntness").forGetter(Configuration::topBluntness), (App)FloatProvider.codec((float)0.1f, (float)10.0f).fieldOf("bottom_bluntness").forGetter(Configuration::bottomBluntness), (App)FloatProvider.codec((float)0.0f, (float)2.0f).fieldOf("wind_speed").forGetter(Configuration::windSpeed), (App)Codec.intRange((int)0, (int)100).fieldOf("min_wind_radius").forGetter(Configuration::minWindRadius), (App)Codec.floatRange((float)0.0f, (float)5.0f).fieldOf("min_wind_bluntness").forGetter(Configuration::minWindBluntness)).apply((Applicative)instance, Configuration::new));
    }

    private static final class LargeIcicle {
        private BlockPos origin;
        private final boolean pointingUp;
        private int radius;
        private final double bluntness;
        private final double scale;

        LargeIcicle(BlockPos origin, boolean pointingUp, int radius, double bluntness, double scale) {
            this.origin = origin;
            this.pointingUp = pointingUp;
            this.radius = radius;
            this.bluntness = bluntness;
            this.scale = scale;
        }

        private boolean alignBaseAndShrinkRadius(WorldGenLevel level, WindOffsetter offsetter) {
            while (this.radius > 1) {
                BlockPos.MutableBlockPos mutableBlockPos = this.origin.mutable();
                int i = Math.min(10, this.getHeightAtRadius(0.0f));
                for (int j = 0; j < i; ++j) {
                    if (level.getBlockState((BlockPos)mutableBlockPos).is(Blocks.LAVA)) {
                        return false;
                    }
                    if (IcicleUtils.isBaseEmbeddedInStone(level, offsetter.offset((BlockPos)mutableBlockPos), this.radius)) {
                        this.origin = mutableBlockPos;
                        return true;
                    }
                    mutableBlockPos.move(this.pointingUp ? Direction.DOWN : Direction.UP);
                }
                this.radius /= 2;
            }
            return false;
        }

        private int getHeightAtRadius(float radius) {
            return (int)IcicleUtils.getIcicleHeight(radius, this.radius, this.scale, this.bluntness);
        }

        private void placeBlocks(WorldGenLevel level, RandomSource random, WindOffsetter offsetter) {
            for (int x = -this.radius; x <= this.radius; ++x) {
                block1: for (int z = -this.radius; z <= this.radius; ++z) {
                    int k;
                    float f = Mth.sqrt((float)(x * x + z * z));
                    if (!(f <= (float)this.radius) || (k = this.getHeightAtRadius(f)) <= 0) continue;
                    if (random.nextDouble() < 0.2) {
                        k = (int)((float)k * Mth.randomBetween((RandomSource)random, (float)0.8f, (float)1.0f));
                    }
                    BlockPos.MutableBlockPos mutableBlockPos = this.origin.offset(x, 0, z).mutable();
                    boolean flag = false;
                    int l = this.pointingUp ? level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, mutableBlockPos.getX(), mutableBlockPos.getZ()) : Integer.MAX_VALUE;
                    for (int i1 = 0; i1 < k && mutableBlockPos.getY() < l; ++i1) {
                        BlockPos blockPos = offsetter.offset((BlockPos)mutableBlockPos);
                        if (IcicleUtils.isEmptyOrWaterOrLava((LevelAccessor)level, blockPos)) {
                            flag = true;
                            level.setBlock(blockPos, Blocks.PACKED_ICE.defaultBlockState(), 2);
                        } else if (flag && level.getBlockState(blockPos).is(SBTags.Blocks.ICICLE_REPLACEABLE)) continue block1;
                        mutableBlockPos.move(this.pointingUp ? Direction.UP : Direction.DOWN);
                    }
                }
            }
        }

        boolean isSuitableForWind(Configuration config) {
            return this.radius >= config.minWindRadius && this.bluntness >= (double)config.minWindBluntness;
        }
    }

    private static final class WindOffsetter {
        private final int originY;
        private final Vec3 windSpeed;

        private WindOffsetter(int originY, RandomSource random, FloatProvider magnitude) {
            this.originY = originY;
            float f = magnitude.sample(random);
            float f1 = Mth.randomBetween((RandomSource)random, (float)0.0f, (float)((float)Math.PI));
            this.windSpeed = new Vec3((double)(Mth.cos((float)f1) * f), 0.0, (double)(Mth.sin((float)f1) * f));
        }

        private WindOffsetter() {
            this.originY = 0;
            this.windSpeed = null;
        }

        BlockPos offset(BlockPos pos) {
            if (this.windSpeed == null) {
                return pos;
            }
            int i = this.originY - pos.getY();
            Vec3 vec3 = this.windSpeed.scale((double)i);
            return pos.offset(Mth.floor((double)vec3.x), 0, Mth.floor((double)vec3.z));
        }
    }
}

