/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.feature.icicle;

import java.util.function.Consumer;
import net.invictusslayer.slayersbeasts.data.tags.SBTags;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.invictusslayer.slayersbeasts.world.level.block.IcicleBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;

public class IcicleUtils {
    protected static double getIcicleHeight(double radius, double maxRadius, double scale, double minRadius) {
        if (radius < minRadius) {
            radius = minRadius;
        }
        double d1 = radius / maxRadius * 0.384;
        double d2 = scale * (0.75 * Math.pow(d1, 1.3333333333333333) - Math.pow(d1, 0.6666666666666666) - Math.log(d1) / 3.0);
        return Math.max(d2, 0.0) / 0.384 * maxRadius;
    }

    protected static boolean isBaseEmbeddedInStone(WorldGenLevel level, BlockPos pos, int radius) {
        if (IcicleUtils.isEmptyOrWaterOrLava((LevelAccessor)level, pos)) {
            return false;
        }
        float i = 6.0f / (float)radius;
        for (float v = 0.0f; v < (float)Math.PI * 2; v += i) {
            int z;
            int x = (int)(Mth.cos((float)v) * (float)radius);
            if (!IcicleUtils.isEmptyOrWaterOrLava((LevelAccessor)level, pos.offset(x, 0, z = (int)(Mth.sin((float)v) * (float)radius)))) continue;
            return false;
        }
        return true;
    }

    protected static boolean isEmptyOrWater(LevelAccessor level, BlockPos pos) {
        return level.isStateAtPosition(pos, IcicleUtils::isEmptyOrWater);
    }

    protected static boolean isEmptyOrWaterOrLava(LevelAccessor level, BlockPos pos) {
        return level.isStateAtPosition(pos, IcicleUtils::isEmptyOrWaterOrLava);
    }

    protected static void buildBaseToTipColumn(Direction direction, int height, boolean mergeTip, Consumer<BlockState> consumer) {
        if (height >= 3) {
            consumer.accept(IcicleUtils.createIcicle(direction, DripstoneThickness.BASE));
            for (int i = 0; i < height - 3; ++i) {
                consumer.accept(IcicleUtils.createIcicle(direction, DripstoneThickness.MIDDLE));
            }
        }
        if (height >= 2) {
            consumer.accept(IcicleUtils.createIcicle(direction, DripstoneThickness.FRUSTUM));
        }
        if (height >= 1) {
            consumer.accept(IcicleUtils.createIcicle(direction, mergeTip ? DripstoneThickness.TIP_MERGE : DripstoneThickness.TIP));
        }
    }

    protected static void growIcicle(LevelAccessor level, BlockPos pos, Direction direction, int height, boolean mergeTip) {
        if (IcicleUtils.isIcicleBase(level.getBlockState(pos.relative(direction.getOpposite())))) {
            BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
            IcicleUtils.buildBaseToTipColumn(direction, height, mergeTip, state -> {
                if (state.is(SBBlocks.ICICLE.get())) {
                    state = (BlockState)state.setValue((Property)IcicleBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.isWaterAt((BlockPos)mutableBlockPos)));
                }
                level.setBlock((BlockPos)mutableBlockPos, state, 2);
                mutableBlockPos.move(direction);
            });
        }
    }

    protected static boolean placeIceIfPossible(LevelAccessor level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos);
        if (blockstate.is(SBTags.Blocks.ICICLE_REPLACEABLE)) {
            level.setBlock(pos, Blocks.PACKED_ICE.defaultBlockState(), 2);
            return true;
        }
        return false;
    }

    private static BlockState createIcicle(Direction direction, DripstoneThickness thickness) {
        return (BlockState)((BlockState)SBBlocks.ICICLE.get().defaultBlockState().setValue(IcicleBlock.TIP_DIRECTION, (Comparable)direction)).setValue(IcicleBlock.THICKNESS, (Comparable)thickness);
    }

    public static boolean isIcicleBaseOrLava(BlockState state) {
        return IcicleUtils.isIcicleBase(state) || state.is(Blocks.LAVA);
    }

    public static boolean isIcicleBase(BlockState state) {
        return state.is(Blocks.PACKED_ICE) || state.is(SBTags.Blocks.ICICLE_REPLACEABLE);
    }

    public static boolean isEmptyOrWater(BlockState state) {
        return state.isAir() || state.is(Blocks.WATER);
    }

    public static boolean isNeitherEmptyNorWater(BlockState state) {
        return !IcicleUtils.isEmptyOrWater(state);
    }

    public static boolean isEmptyOrWaterOrLava(BlockState state) {
        return state.isAir() || state.is(Blocks.WATER) || state.is(Blocks.LAVA);
    }
}

