/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.feature.mushroom;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;

public abstract class AbstractMightyMushroomFeature
extends Feature<HugeMushroomFeatureConfiguration> {
    public AbstractMightyMushroomFeature(Codec<HugeMushroomFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<HugeMushroomFeatureConfiguration> context) {
        BlockPos.MutableBlockPos mutableBlockPos;
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        HugeMushroomFeatureConfiguration config = (HugeMushroomFeatureConfiguration)context.config();
        int height = this.getTreeHeight(random);
        if (!this.isValidPosition((LevelAccessor)level, origin, height, mutableBlockPos = new BlockPos.MutableBlockPos(), config)) {
            return false;
        }
        this.placeCap((LevelAccessor)level, random, origin, config, height, mutableBlockPos);
        this.placeStem((LevelAccessor)level, random, origin, config, height, mutableBlockPos);
        return true;
    }

    protected abstract void placeCap(LevelAccessor var1, RandomSource var2, BlockPos var3, HugeMushroomFeatureConfiguration var4, int var5, BlockPos.MutableBlockPos var6);

    protected void placeStem(LevelAccessor level, RandomSource random, BlockPos pos, HugeMushroomFeatureConfiguration config, int maxHeight, BlockPos.MutableBlockPos mutableBlockPos) {
        for (int i = 0; i < maxHeight - 1; ++i) {
            mutableBlockPos.set((Vec3i)pos).move(Direction.UP, i);
            if (level.getBlockState((BlockPos)mutableBlockPos).isSolidRender()) continue;
            this.setBlock((LevelWriter)level, (BlockPos)mutableBlockPos, config.stemProvider.getState(random, pos));
            this.setBlock((LevelWriter)level, mutableBlockPos.south(), config.stemProvider.getState(random, pos));
            this.setBlock((LevelWriter)level, mutableBlockPos.east(), config.stemProvider.getState(random, pos));
            this.setBlock((LevelWriter)level, mutableBlockPos.south().east(), config.stemProvider.getState(random, pos));
        }
    }

    protected int getTreeHeight(RandomSource random) {
        int i = random.nextInt(8) + 8;
        if (random.nextInt(12) == 0) {
            i *= 2;
        }
        return i;
    }

    protected boolean isValidPosition(LevelAccessor level, BlockPos pos, int maxHeight, BlockPos.MutableBlockPos mutableBlockPos, HugeMushroomFeatureConfiguration config) {
        if (pos.getY() <= level.getMinY() || pos.getY() + maxHeight > level.getMaxY()) {
            return false;
        }
        List<BlockPos> posList = List.of(pos.below(), pos.below().south(), pos.below().east(), pos.below().south().east());
        for (BlockPos blockPos : posList) {
            BlockState state = level.getBlockState(blockPos);
            if (AbstractMightyMushroomFeature.isDirt((BlockState)state) || state.is(BlockTags.MUSHROOM_GROW_BLOCK)) continue;
            return false;
        }
        for (int y = 0; y <= maxHeight; ++y) {
            int radius = this.getTreeRadiusForHeight(config.foliageRadius, maxHeight - y);
            for (int x = -radius; x <= radius + 1; ++x) {
                for (int z = -radius; z <= radius + 1; ++z) {
                    BlockState state = level.getBlockState((BlockPos)mutableBlockPos.setWithOffset((Vec3i)pos, x, y, z));
                    if (state.isAir() || state.is(BlockTags.LEAVES)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected abstract int getTreeRadiusForHeight(int var1, int var2);
}

