/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.structure;

import java.util.List;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.SBStructures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public class SBStructureSets {
    public static final ResourceKey<StructureSet> CRYPT_PORTALS = SBStructureSets.createKey("crypt_portals");
    public static final ResourceKey<StructureSet> LODGES = SBStructureSets.createKey("lodges");

    public static void bootstrap(BootstrapContext<StructureSet> context) {
        HolderGetter structures = context.lookup(Registries.STRUCTURE);
        SBStructureSets.register(context, CRYPT_PORTALS, (Holder<Structure>)structures.getOrThrow(SBStructures.CRYPT_PORTAL), (StructurePlacement)new RandomSpreadStructurePlacement(12, 6, RandomSpreadType.LINEAR, 987654002));
        SBStructureSets.register(context, LODGES, List.of(StructureSet.entry((Holder)structures.getOrThrow(SBStructures.REDWOOD_LODGE))), (StructurePlacement)new RandomSpreadStructurePlacement(24, 10, RandomSpreadType.LINEAR, 987654003));
    }

    private static ResourceKey<StructureSet> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"slayersbeasts", (String)name));
    }

    private static void register(BootstrapContext<StructureSet> context, ResourceKey<StructureSet> key, List<StructureSet.StructureSelectionEntry> config, StructurePlacement placement) {
        context.register(key, (Object)new StructureSet(config, placement));
    }

    private static void register(BootstrapContext<StructureSet> context, ResourceKey<StructureSet> key, Holder<Structure> config, StructurePlacement placement) {
        context.register(key, (Object)new StructureSet(config, placement));
    }
}

