/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.slayersbeasts.world.level.gen.structure.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.invictusslayer.slayersbeasts.registries.SBStructureTypes;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.pieces.CryptPieces;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public class CryptStructure
extends Structure {
    public static final MapCodec<CryptStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CryptStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(structure -> structure.startHeight)).apply((Applicative)instance, CryptStructure::new));
    private final Holder<StructureTemplatePool> startPool;
    private final HeightProvider startHeight;

    public CryptStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, HeightProvider startHeight) {
        super(settings);
        this.startPool = startPool;
        this.startHeight = startHeight;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.chunkPos();
        int i = this.startHeight.sample((RandomSource)context.random(), new WorldGenerationContext(context.chunkGenerator(), context.heightAccessor()));
        BlockPos pos = new BlockPos(chunkPos.getMinBlockX(), i, chunkPos.getMinBlockZ());
        return CryptPieces.addPieces(context, this.startPool, pos, 128, PoolAliasLookup.EMPTY, LiquidSettings.APPLY_WATERLOGGING);
    }

    public StructureType<?> type() {
        return SBStructureTypes.CRYPT.get();
    }
}

