package net.invictusslayer.slayersbeasts;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.invictusslayer.slayersbeasts.registries.SBEntities;
import net.invictusslayer.slayersbeasts.world.level.biome.SBBiomeModifications;
import net.minecraft.class_1317;

public class SBFabric implements ModInitializer {
	private static boolean INITIALISED = false;

	public void onInitialize() {
		fabricInit();
	}

	public static void fabricInit() {
		if (INITIALISED) {
			SlayersBeasts.LOGGER.info("SBFabric has already been initialised, skipping...");
			return;
		}
		INITIALISED = true;

		SlayersBeasts.init();
		SBBiomeModifications.register();
		SlayersBeasts.commonSetup();
		SBEntities.registerAttributes(FabricDefaultAttributeRegistry::register);
		SBEntities.registerSpawns(placement -> class_1317.method_20637(placement.entity(), placement.placement(), placement.heightmap(), placement.predicate()));
	}
}
