package net.invictusslayer.slayersbeasts;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.invictusslayer.scabbard.platform.IPlatformHandler;
import net.invictusslayer.slayersbeasts.world.level.block.IExtendedMushroomBlock;
import net.invictusslayer.slayersbeasts.world.level.block.SBFlammableBlocks;
import net.invictusslayer.slayersbeasts.world.level.block.SBStrippableBlocks;
import net.invictusslayer.slayersbeasts.world.level.block.SBWoodType;
import net.invictusslayer.slayersbeasts.config.SBConfig;
import net.invictusslayer.slayersbeasts.registries.*;
import net.invictusslayer.slayersbeasts.world.item.SBDispensableItems;
import net.invictusslayer.slayersbeasts.world.level.biome.SBSurfaceRuleData;
import net.invictusslayer.slayersbeasts.world.level.biome.region.SBNetherRegion;
import net.invictusslayer.slayersbeasts.world.level.biome.region.SBOverworldRegion;
import net.invictusslayer.slayersbeasts.world.level.gen.feature.SBConfiguredFeatures;
import net.minecraft.class_1438;
import net.minecraft.class_2246;
import net.minecraft.class_4019;
import net.minecraft.class_4722;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;

import java.util.Arrays;
import java.util.ServiceLoader;

public class SlayersBeasts {
	public static final String MOD_ID = "slayersbeasts";
	public static final Logger LOGGER = LogManager.getLogger(MOD_ID);
	public static SBConfig CONFIG = null;
	public static IPlatformHandler PLATFORM = null;

	public static void init() {
		loadPlatform(IPlatformHandler.class);
		loadConfig();

		SBItems.register();
		SBBlocks.register();
		SBEntities.register();
		SBCreativeModeTabs.register();
		SBVillagerType.register();
		SBBlockEntities.register();
		SBEffects.register();
		SBPotions.register();
		SBSounds.register();
		SBDataComponents.register();
		SBPois.register();
		SBFeatures.register();
		SBTreeDecorators.register();
		SBFoliagePlacers.register();
		SBTrunkPlacers.register();
		SBStructurePieces.register();
		SBStructureTypes.register();

		LOGGER.info(PLATFORM.configPath(SlayersBeasts.MOD_ID).toAbsolutePath().normalize().toString());
	}

	public static void loadConfig() {
		if (CONFIG != null) return;
		AutoConfig.register(SBConfig.class, Toml4jConfigSerializer::new);
		CONFIG = AutoConfig.getConfigHolder(SBConfig.class).getConfig();
	}

	public static <T extends IPlatformHandler> void loadPlatform(Class<T> clazz) {
		if (PLATFORM != null) return;
		final T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
		LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
		PLATFORM = loadedService;
	}

	public static void commonSetup() {
		LOGGER.info("Extended MushroomCow$Type values: {}", Arrays.toString(class_1438.class_4053.values()));
		LOGGER.info("Extended Fox$Type values: {}", Arrays.toString(class_4019.class_4039.values()));

		SBFlammableBlocks.register();
		SBStrippableBlocks.register();
		SBDispensableItems.register();
		SBVillagerType.setupBiomes();

		((IExtendedMushroomBlock) SBBlocks.BLACK_MUSHROOM.get()).setMightyMushroom(SBConfiguredFeatures.MIGHTY_BLACK_MUSHROOM);
		((IExtendedMushroomBlock) class_2246.field_10251).setMightyMushroom(SBConfiguredFeatures.MIGHTY_BROWN_MUSHROOM);
		((IExtendedMushroomBlock) class_2246.field_10559).setMightyMushroom(SBConfiguredFeatures.MIGHTY_RED_MUSHROOM);
		((IExtendedMushroomBlock) SBBlocks.WHITE_MUSHROOM.get()).setMightyMushroom(SBConfiguredFeatures.MIGHTY_WHITE_MUSHROOM);

		SurfaceRuleManager.addSurfaceRules(SurfaceRuleManager.RuleCategory.OVERWORLD, SlayersBeasts.MOD_ID, SBSurfaceRuleData.overworldRules());
		SurfaceRuleManager.addSurfaceRules(SurfaceRuleManager.RuleCategory.NETHER, SlayersBeasts.MOD_ID, SBSurfaceRuleData.netherRules());
//		SurfaceRuleManager.addSurfaceRules(EBRuleCategory.END, SlayersBeasts.MOD_ID, SBSurfaceRuleData.endRules());
	}

	public static void clientSetup() {
		SBWoodType.values().forEach(type -> {
			class_4722.field_21712.put(type, class_4722.method_24064(type));
			class_4722.field_40515.put(type, class_4722.method_45782(type));
		});
	}

	public static void registerRegions() {
		loadConfig();
		if (CONFIG.worldgen.overworld_biomes) Regions.register(new SBOverworldRegion(CONFIG.worldgen.overworld_region_weight));
		if (CONFIG.worldgen.nether_biomes) Regions.register(new SBNetherRegion(CONFIG.worldgen.nether_region_weight));
//		if (CONFIG.worldgen.end_biomes) Regions.register(new SBEndRegion(CONFIG.worldgen.end_region_weight));
	}
}
