package net.invictusslayer.slayersbeasts.data;

import net.invictusslayer.scabbard.world.level.WoodFamily;
import net.invictusslayer.slayersbeasts.SlayersBeasts;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.invictusslayer.slayersbeasts.registries.SBItems;
import net.invictusslayer.slayersbeasts.world.level.block.SBBlockFamily;
import net.invictusslayer.slayersbeasts.world.level.block.SBWoodFamily;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2454;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5794;
import net.minecraft.class_5797;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7784;
import net.minecraft.class_7800;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_8790;
import net.minecraft.data.recipes.*;
import java.util.concurrent.CompletableFuture;

public class SBRecipeProvider extends class_2446 {
	private final class_7871<class_1792> items;

	public SBRecipeProvider(class_7225.class_7874 provider, class_8790 output) {
		super(provider, output);
		items = provider.method_46762(class_7924.field_41197);
	}

	public void method_10419() {
		generateBlockFamilies();
		generateWoodFamilies(field_53721);

		class_2454.method_35918(class_1856.method_8101(SBItems.TIED_LEATHER.get()), class_7800.field_40642, SBItems.TANNED_LEATHER.get(), 0.5F, 200).method_10469("has_tied_leather", method_10426(SBItems.TIED_LEATHER.get())).method_10431(field_53721);
		class_2447.method_10437(items, class_7800.field_40642, SBItems.TIED_LEATHER.get()).method_10434('S', class_1802.field_8276).method_10434('L', class_1802.field_8745).method_10434('M', SBItems.MUD_BALL.get())
				.method_10439("MSM").method_10439("LSL").method_10439("MSM").method_10429("has_leather", method_10426(class_1802.field_8745)).method_10431(field_53721);

		twoByTwoPacker(field_53721, class_7800.field_40634, class_2246.field_37556, SBItems.MUD_BALL.get());
		class_2454.method_17802(class_1856.method_8101(class_2246.field_37556), class_7800.field_40634, SBBlocks.CRACKED_MUD.get(), 0.1F, 200).method_10469("has_packed_mud", method_10426(class_2246.field_37556)).method_10431(field_53721);

		class_2447.method_10436(items, class_7800.field_40634, SBBlocks.PEAT.get(), 4).method_10434('M', class_2246.field_28681).method_10434('U', class_2246.field_37576).method_10439("MU").method_10439("UM").method_10429("has_moss", method_10426(class_2246.field_28681)).method_10431(field_53721);

		nineBlockStorageRecipes(field_53721, class_7800.field_40642, SBItems.JADE.get(), class_7800.field_40634, SBBlocks.JADE_BLOCK.get());

		twoByTwoPacker(field_53721, class_7800.field_40634, SBBlocks.BLACK_SANDSTONE.get(), SBBlocks.BLACK_SAND.get());
		method_32804(class_7800.field_40634, SBBlocks.BLACK_SANDSTONE_SLAB.get(), class_1856.method_8091(SBBlocks.BLACK_SANDSTONE.get(), SBBlocks.CHISELED_BLACK_SANDSTONE.get())).method_33530("has_black_sandstone", method_10426(SBBlocks.BLACK_SANDSTONE.get())).method_33530("has_chiseled_black_sandstone", method_10426(SBBlocks.CHISELED_BLACK_SANDSTONE.get())).method_10431(field_53721);
		method_32808(SBBlocks.BLACK_SANDSTONE_STAIRS.get(), class_1856.method_8091(SBBlocks.BLACK_SANDSTONE.get(), SBBlocks.CHISELED_BLACK_SANDSTONE.get(), SBBlocks.CUT_BLACK_SANDSTONE.get())).method_33530("has_black_sandstone", method_10426(SBBlocks.BLACK_SANDSTONE.get())).method_33530("has_chiseled_black_sandstone", method_10426(SBBlocks.CHISELED_BLACK_SANDSTONE.get())).method_33530("has_cut_black_sandstone", method_10426(SBBlocks.CUT_BLACK_SANDSTONE.get())).method_10431(field_53721);
		method_32809(class_7800.field_40635, SBBlocks.BLACK_SANDSTONE_WALL.get(), SBBlocks.BLACK_SANDSTONE.get());
		class_2454.method_17802(class_1856.method_8101(SBBlocks.BLACK_SANDSTONE.get()), class_7800.field_40634, SBBlocks.SMOOTH_BLACK_SANDSTONE.get().method_8389(), 0.1F, 200).method_10469("has_black_sandstone", method_10426(SBBlocks.BLACK_SANDSTONE.get())).method_10431(field_53721);
		method_33715(class_7800.field_40634, SBBlocks.BLACK_SANDSTONE_SLAB.get(), SBBlocks.BLACK_SANDSTONE.get(), 2);
		method_33717(class_7800.field_40634, SBBlocks.BLACK_SANDSTONE_STAIRS.get(), SBBlocks.BLACK_SANDSTONE.get());
		method_33717(class_7800.field_40635, SBBlocks.BLACK_SANDSTONE_WALL.get(), SBBlocks.BLACK_SANDSTONE.get());
		method_33715(class_7800.field_40634, SBBlocks.SMOOTH_BLACK_SANDSTONE_SLAB.get(), SBBlocks.SMOOTH_BLACK_SANDSTONE.get(), 2);
		method_33717(class_7800.field_40634, SBBlocks.SMOOTH_BLACK_SANDSTONE_STAIRS.get(), SBBlocks.SMOOTH_BLACK_SANDSTONE.get());
		method_33717(class_7800.field_40634, SBBlocks.CUT_BLACK_SANDSTONE.get(), SBBlocks.BLACK_SANDSTONE.get());
		method_33715(class_7800.field_40634, SBBlocks.CUT_BLACK_SANDSTONE_SLAB.get(), SBBlocks.BLACK_SANDSTONE.get(), 2);
		method_33715(class_7800.field_40634, SBBlocks.CUT_BLACK_SANDSTONE_SLAB.get(), SBBlocks.CUT_BLACK_SANDSTONE.get(), 2);
		method_33717(class_7800.field_40634, SBBlocks.CHISELED_BLACK_SANDSTONE.get(), SBBlocks.BLACK_SANDSTONE.get());

		method_33715(class_7800.field_40634, SBBlocks.PEGMATITE_SLAB.get(), SBBlocks.PEGMATITE.get(), 2);
		method_33717(class_7800.field_40634, SBBlocks.PEGMATITE_STAIRS.get(), SBBlocks.PEGMATITE.get());
		method_33717(class_7800.field_40635, SBBlocks.PEGMATITE_WALL.get(), SBBlocks.PEGMATITE.get());
		method_33717(class_7800.field_40634, SBBlocks.POLISHED_PEGMATITE.get(), SBBlocks.PEGMATITE.get());
		method_33715(class_7800.field_40634, SBBlocks.POLISHED_PEGMATITE_SLAB.get(), SBBlocks.PEGMATITE.get(), 2);
		method_33715(class_7800.field_40634, SBBlocks.POLISHED_PEGMATITE_SLAB.get(), SBBlocks.POLISHED_PEGMATITE.get(), 2);
		method_33717(class_7800.field_40634, SBBlocks.POLISHED_PEGMATITE_STAIRS.get(), SBBlocks.PEGMATITE.get());
		method_33717(class_7800.field_40634, SBBlocks.POLISHED_PEGMATITE_STAIRS.get(), SBBlocks.POLISHED_PEGMATITE.get());
	}

	private void generateWoodFamilies(class_8790 output) {
		SBWoodFamily.getAllFamilies().forEach(family -> {
			class_2248 planks = (class_2248) family.get(WoodFamily.Variant.PLANKS).get();
			class_1856 ingredient = class_1856.method_8101(planks);

			family.getVariants().forEach((variant, supplier) -> {
				if (!(supplier.get() instanceof class_1935 item)) return;
				switch (variant) {
					case BOAT -> method_24478(item, planks);
					case BUTTON -> woodenRecipe(output, method_33542(item, ingredient), planks, "button");
					case CHEST_BOAT -> method_42754(item, (class_1792) family.get(WoodFamily.Variant.BOAT).get());
					case DOOR -> woodenRecipe(output, method_33544(item, ingredient), planks, "door");
					case FENCE -> woodenRecipe(output, method_33546(item, ingredient), planks, "fence");
					case FENCE_GATE -> woodenRecipe(output, method_33548(item, ingredient), planks, "fence_gate");
					case HANGING_SIGN_ITEM -> method_46208(item, (class_2248) family.get(WoodFamily.Variant.STRIPPED_LOG).get());
					case PLANKS -> method_24475(item, family.getLogItems(), 4);
					case PRESSURE_PLATE -> woodenRecipe(output, method_32806(class_7800.field_40636, item, ingredient), planks, "pressure_plate");
					case SIGN_ITEM -> woodenRecipe(output, method_33555(item, ingredient), planks, "sign");
					case SLAB -> woodenRecipe(output, method_32804(class_7800.field_40634, item, ingredient), planks, "slab");
					case STAIRS -> woodenRecipe(output, method_32808(item, ingredient), planks, "stairs");
					case STRIPPED_WOOD -> method_24476(item, (class_2248) family.get(WoodFamily.Variant.STRIPPED_LOG).get());
					case TRAPDOOR -> woodenRecipe(output, method_33553(item, ingredient), planks, "trapdoor");
					case WOOD -> method_24476(item, (class_2248) family.get(WoodFamily.Variant.LOG).get());
				}
			});
		});
	}

	private void woodenRecipe(class_8790 output, class_5797 builder, class_2248 planks, String group) {
		builder.method_33530("has_planks", method_10426(planks)).method_33529("wooden_" + group).method_10431(output);
	}

	private void generateBlockFamilies() {
		SBBlockFamily.getAllFamilies().filter(class_5794::method_33478).forEach(family -> method_33535(family, class_7699.method_45398(class_7701.field_40177)));
	}

	public void twoByTwoPacker(class_8790 output, class_7800 category, class_1935 pPacked, class_1935 pUnpacked) {
		class_2447.method_10436(items, category, pPacked, 1).method_10434('#', pUnpacked).method_10439("##").method_10439("##").method_10429(method_32807(pUnpacked), method_10426(pUnpacked)).method_17972(output, createRecipeKey(method_36450(pUnpacked)));
	}

	public void nineBlockStorageRecipes(class_8790 output, class_7800 unpackedCategory, class_1935 unpacked, class_7800 packedCategory, class_1935 packed) {
		nineBlockStorageRecipes(output, unpackedCategory, unpacked, packedCategory, packed, method_36450(packed), method_36450(unpacked));
	}

	public void nineBlockStorageRecipes(class_8790 output, class_7800 unpackedCategory, class_1935 unpacked, class_7800 packedCategory, class_1935 packed, String packedName, String unpackedName) {
		class_2450.method_10448(items, unpackedCategory, unpacked, 9).method_10454(packed).method_10452(null).method_10442(method_32807(packed), method_10426(packed)).method_17972(output, createRecipeKey(unpackedName));
		class_2447.method_10437(items, packedCategory, packed).method_10434('#', unpacked).method_10439("###").method_10439("###").method_10439("###").method_10435(null).method_10429(method_32807(unpacked), method_10426(unpacked)).method_17972(output, createRecipeKey(packedName));
	}

	private class_5321<class_1860<?>> createRecipeKey(String path) {
		return class_5321.method_29179(class_7924.field_52178, class_2960.method_60655(SlayersBeasts.MOD_ID, path));
	}

	public static class Runner extends class_2446.class_10114 {
		public Runner(class_7784 output, CompletableFuture<class_7225.class_7874> provider) {
			super(output, provider);
		}

		public String method_10321() {
			return "SBRecipeProvider";
		}

		protected class_2446 method_62766(class_7225.class_7874 provider, class_8790 output) {
			return new SBRecipeProvider(provider, output);
		}
	}
}
