package net.invictusslayer.slayersbeasts.data.loot;

import net.invictusslayer.scabbard.world.level.WoodFamily;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.invictusslayer.slayersbeasts.registries.SBItems;
import net.invictusslayer.slayersbeasts.world.level.block.SBBlockFamily;
import net.invictusslayer.slayersbeasts.world.level.block.SBWoodFamily;
import net.minecraft.class_141;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_212;
import net.minecraft.class_215;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_44;
import net.minecraft.class_4559;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5662;
import net.minecraft.class_5794;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_7701;
import net.minecraft.class_7788;
import net.minecraft.class_7924;
import net.minecraft.class_94;
import java.util.Set;
import java.util.function.BiConsumer;

public class SBBlockLoot extends class_7788 {
	public SBBlockLoot(class_7225.class_7874 registries) {
		super(Set.of(), class_7701.field_40180.method_45383(), registries);
	}

	public void method_10379() {}

	public void method_10399(BiConsumer<class_5321<class_52>, class_52.class_53> biConsumer) {
		generateBlockFamilies();

		method_46025(SBBlocks.CRYPTALITH.get());
		method_46006(SBBlocks.INFUSED_CRYPTALITH.get(), SBBlocks.DEPLETED_CRYPTALITH.get());
		method_46025(SBBlocks.DEPLETED_CRYPTALITH.get());
		method_46025(SBBlocks.JADE_BLOCK.get());

		method_45994(SBBlocks.EXOSKELETON_ORE.get(), block -> createExoskeletonOreDrops(SBBlocks.EXOSKELETON_ORE.get()));
		method_45994(SBBlocks.DEEPSLATE_EXOSKELETON_ORE.get(), block -> createExoskeletonOreDrops(SBBlocks.DEEPSLATE_EXOSKELETON_ORE.get()));

		method_45994(SBBlocks.STYPHIUM.get(), block -> method_45983(block, class_2246.field_10445));
		method_45994(SBBlocks.DEEPSLATE_STYPHIUM.get(), block -> method_45983(block, class_2246.field_29031));

		method_46025(SBBlocks.RUDOSOL.get());
		method_46025(SBBlocks.ARIDISOL.get());
		method_46006(SBBlocks.ANTHILL.get(), SBBlocks.ARIDISOL.get());
		method_46006(SBBlocks.ANTHILL_HATCHERY.get(), SBBlocks.ARIDISOL.get());

		method_46024(SBBlocks.GLEAMING_ICE.get());
		method_46024(SBBlocks.ICICLE.get());
		method_46025(SBBlocks.OBSIDIAN_SPIKE.get());
		method_45994(SBBlocks.TALL_DEAD_BUSH.get(), this::createTallDeadBushDrops);
		method_45994(SBBlocks.CRACKED_MUD.get(), block -> method_45984(class_2246.field_37556, SBItems.MUD_BALL.get(), class_44.method_32448(4)));
		method_46025(SBBlocks.PEAT.get());
		method_45994(SBBlocks.ALGAE.get(), this::method_45995);

		method_46025(SBBlocks.BLACK_SAND.get());

		method_45994(SBBlocks.TALL_BROWN_MUSHROOM.get(), block -> method_45987(block, class_2320.field_10929, class_2756.field_12607));
		method_45994(SBBlocks.TALL_RED_MUSHROOM.get(), block -> method_45987(block, class_2320.field_10929, class_2756.field_12607));
		method_45994(SBBlocks.BLACK_MUSHROOM_BLOCK.get(), block -> method_45998(SBBlocks.BLACK_MUSHROOM_BLOCK.get(), SBBlocks.BLACK_MUSHROOM.get()));
		method_46025(SBBlocks.BLACK_MUSHROOM.get());
		method_46023(SBBlocks.POTTED_BLACK_MUSHROOM.get());
		method_45994(SBBlocks.TALL_BLACK_MUSHROOM.get(), block -> method_45987(block, class_2320.field_10929, class_2756.field_12607));
		method_45994(SBBlocks.WHITE_MUSHROOM_BLOCK.get(), block -> method_45998(SBBlocks.WHITE_MUSHROOM_BLOCK.get(), SBBlocks.WHITE_MUSHROOM.get()));
		method_46025(SBBlocks.WHITE_MUSHROOM.get());
		method_46023(SBBlocks.POTTED_WHITE_MUSHROOM.get());
		method_45994(SBBlocks.TALL_WHITE_MUSHROOM.get(), block -> method_45987(block, class_2320.field_10929, class_2756.field_12607));
//		add(SBBlocks.THIN_MUSHROOM_STEM.get(), BlockLootSubProvider::createSilkTouchOnlyTable);

		generateWoodFamilies();
		method_45994(SBBlocks.ALBINO_REDWOOD_LEAVES.get(), block -> method_45986(block, SBBlocks.ALBINO_REDWOOD_SAPLING.get(), 0.01F));
		method_46025(SBBlocks.ALBINO_REDWOOD_SAPLING.get());
		method_46023(SBBlocks.POTTED_ALBINO_REDWOOD_SAPLING.get());
		method_45994(SBBlocks.WILLOW_BRANCH.get(), block -> method_45986(block, SBBlocks.WILLOW_SAPLING.get(), 0.03F));
		method_45994(SBBlocks.WILLOW_BRANCH_PLANT.get(), block -> method_45986(block, SBBlocks.WILLOW_SAPLING.get(), 0.03F));
	}

	private void generateWoodFamilies() {
		SBWoodFamily.getAllFamilies().forEach(family -> family.getVariants().forEach((variant, supplier) -> {
			if (!(supplier.get() instanceof class_2248 block)) return;
			switch (variant) {
				case DOOR -> method_45994(block, this::method_46022);
				case LEAVES -> method_45988(block, method_45986(block, (class_2248) family.get(WoodFamily.Variant.SAPLING).get(), 0.05F));
				case POTTED_SAPLING -> method_46023(block);
				case SLAB -> method_45994(block, this::method_45980);
				case WALL_HANGING_SIGN -> method_46006(block, (class_2248) family.get(WoodFamily.Variant.HANGING_SIGN).get());
				case WALL_SIGN -> method_46006(block, (class_2248) family.get(WoodFamily.Variant.SIGN).get());
				default -> method_46025(block);
			}
		}));
	}

	private void generateBlockFamilies() {
		SBBlockFamily.getAllFamilies().forEach(family -> {
			method_46025(family.method_33469());
			family.method_33474().forEach((variant, block) -> {
				switch (variant) {
					case field_28539 -> method_45994(block, this::method_45980);
					case field_28535 -> method_45994(block, this::method_46022);
					case field_28545 -> method_46006(block, family.method_33470(class_5794.class_5796.field_28538));
					default -> method_46025(block);
				}
			});
		});
	}

	private class_52.class_53 createTallDeadBushDrops(class_2248 block) {
		return class_52.method_324().method_336(class_55.method_347().method_352(class_44.method_32448(1.0F))
				.method_351(class_77.method_411(block).method_421(method_62727())
						.method_417(method_45977(block, class_77.method_411(class_1802.field_8600)
								.method_421(class_212.method_900(block)
										.method_22584(class_4559.class_4560.method_22523()
												.method_22525(class_2741.field_12533, class_2756.field_12607)))
								.method_421(class_215.method_15972(class_47.class_50.field_935))
								.method_438(class_141.method_621(class_5662.method_32462(1.0F, 4.0F)))))));
	}

	private class_52.class_53 createExoskeletonOreDrops(class_2248 block) {
		class_7225.class_7226<class_1887> registryLookup = field_51845.method_46762(class_7924.field_41265);
		return method_45989(block, method_45977(block,
				class_77.method_411(SBItems.CRYSTALLINE_CLAW.get())
						.method_438(class_141.method_621(class_5662.method_32462(0.0F, 1.0F)))
						.method_438(class_94.method_455(registryLookup.method_46747(class_1893.field_9130)))));
	}
}
