package net.invictusslayer.slayersbeasts.data.loot;

import com.google.common.collect.Sets;
import net.invictusslayer.slayersbeasts.SlayersBeasts;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import java.util.Collections;
import java.util.Set;

public class SBLootTables {
	private static final Set<class_5321<class_52>> LOCATIONS = Sets.newHashSet();
	private static final Set<class_5321<class_52>> IMMUTABLE_LOCATIONS = Collections.unmodifiableSet(LOCATIONS);

	public static final class_5321<class_52> CRYPT_COMMON = register("chests/crypt_common");
	public static final class_5321<class_52> CRYPT_RARE = register("chests/crypt_rare");
	public static final class_5321<class_52> REDWOOD_LOGS = register("chests/redwood_logs");
	public static final class_5321<class_52> REDWOOD_TOOLS = register("chests/redwood_tools");

	private static class_5321<class_52> register(String path) {
		class_5321<class_52> key = class_5321.method_29179(class_7924.field_50079, class_2960.method_60655(SlayersBeasts.MOD_ID, path));
		if (LOCATIONS.add(key)) return key;
		else throw new IllegalArgumentException(key + " is already a registered loot table");
	}

	public static Set<class_5321<class_52>> all() {
		return IMMUTABLE_LOCATIONS;
	}
}
