package net.invictusslayer.slayersbeasts.mixin.common;

import net.invictusslayer.slayersbeasts.world.entity.SBMushroomCowVariant;
import net.minecraft.class_1438;
import net.minecraft.class_1538;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.UUID;

@SuppressWarnings("AddedMixinMembersNamePattern")
@Mixin(class_1438.class)
public abstract class MushroomCowMixin {
	@Shadow
	private UUID lastLightningBoltUUID;

	@Shadow
	public abstract class_1438.class_4053 getVariant();

	@Inject(method = "thunderHit", at = @At("HEAD"), cancellable = true)
	private void onThunderHit(class_3218 level, class_1538 lightning, CallbackInfo ci) {
		UUID uuid = lightning.method_5667();
		if (!uuid.equals(lastLightningBoltUUID)) {
			((class_1438) (Object) this).method_47846(cycleVariant(getVariant()));
			lastLightningBoltUUID = uuid;
			((class_1438) (Object) this).method_5783(class_3417.field_18266, 2.0F, 1.0F);
		}
		ci.cancel();
	}

	@Inject(method = "getOffspringVariant", at = @At("HEAD"), cancellable = true)
	private void onGetOffspringType(class_1438 mate, CallbackInfoReturnable<class_1438.class_4053> cir) {
		class_1438.class_4053 type = getVariant();
		class_1438.class_4053 mateType = mate.method_47847();
		if (type == mateType && class_5819.method_43047().method_43048(1024) == 0) {
			cir.setReturnValue(cycleVariant(type));
		}
		cir.setReturnValue(class_5819.method_43047().method_43056() ? type : mateType);
	}

	@Unique
	private static class_1438.class_4053 cycleVariant(class_1438.class_4053 type) {
		if (type == class_1438.class_4053.field_18109) return class_1438.class_4053.field_18110;
		if (type == class_1438.class_4053.field_18110) return SBMushroomCowVariant.WHITE;
		if (type == SBMushroomCowVariant.WHITE) return SBMushroomCowVariant.BLACK;
		return class_1438.class_4053.field_18109;
	}
}
