package net.invictusslayer.slayersbeasts.registries;

import net.invictusslayer.slayersbeasts.SlayersBeasts;
import net.invictusslayer.slayersbeasts.world.level.block.entity.AnthillBlockEntity;
import net.invictusslayer.slayersbeasts.world.level.block.entity.AnthillHatcheryBlockEntity;
import net.minecraft.class_2591;
import net.minecraft.class_7923;
import java.util.Set;
import java.util.function.Supplier;

public class SBBlockEntities {
	public static final Supplier<class_2591<AnthillBlockEntity>> ANTHILL = register("anthill", () -> new class_2591<>(AnthillBlockEntity::new, Set.of(SBBlocks.ANTHILL.get())));
	public static final Supplier<class_2591<AnthillHatcheryBlockEntity>> ANTHILL_HATCHERY = register("anthill_hatchery", () -> new class_2591<>(AnthillHatcheryBlockEntity::new, Set.of(SBBlocks.ANTHILL_HATCHERY.get())));

	private static <T extends class_2591<?>> Supplier<T> register(String name, Supplier<T> supplier) {
		return SlayersBeasts.PLATFORM.register(class_7923.field_41181, SlayersBeasts.MOD_ID, name, supplier);
	}

	public static void register() {
		SlayersBeasts.LOGGER.info("Registering SBBlockEntities...");
	}
}
